/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc.cli;

import gw.internal.ext.com.beust.jcommander.Parameter;
import gw.internal.ext.com.beust.jcommander.validators.PositiveInteger;
import java.util.ArrayList;
import java.util.List;

class CommandLineOptions {
    @Parameter(names={"-ca", "-checkedArithmetic"}, description="Compile with checked arithmetic")
    private boolean _checkedarithmetic;
    @Parameter(names={"-cp", "-classpath"}, description="Specify where to find user class files")
    private String _classpath;
    @Parameter(names={"-d"}, description="Specify where to place generated class files")
    private String _destDir;
    @Parameter(names={"-help"}, description="Print a synopsis of standard options", help=true)
    private boolean _help;
    @Parameter(names={"-nowarn"}, description="Generate no warnings")
    private boolean _nowarn;
    @Parameter(names={"-sourcepath"}, description="Specify where to find input source files")
    private String _sourcepath;
    @Parameter(names={"-verbose"}, description="Output messages about what the compiler is doing")
    private boolean _verbose;
    @Parameter(names={"-version"}, description="Version information")
    private boolean _version;
    @Parameter(description="<source files>")
    private List<String> _srcFiles = new ArrayList<String>();
    @Parameter(names={"-maxerrs"}, description="Set the maximum number of errors to print", validateWith={PositiveInteger.class})
    private int _maxerrs = 100;
    @Parameter(names={"-maxwarns"}, description="Set the maximum number of warnings to print", validateWith={PositiveInteger.class})
    private int _maxwarns = Integer.MAX_VALUE;

    CommandLineOptions() {
    }

    protected boolean isCheckedArithmetic() {
        return this._checkedarithmetic;
    }

    protected String getClasspath() {
        return this._classpath == null ? "" : this._classpath;
    }

    protected String getDestDir() {
        return this._destDir == null ? "" : this._destDir;
    }

    protected boolean isHelp() {
        return this._help;
    }

    protected boolean isNoWarn() {
        return this._nowarn;
    }

    protected String getSourcepath() {
        return this._sourcepath == null ? "" : this._sourcepath;
    }

    protected boolean isVerbose() {
        return this._verbose;
    }

    protected boolean isVersion() {
        return this._version;
    }

    protected List<String> getSourceFiles() {
        return this._srcFiles;
    }

    protected int getMaxErrs() {
        return this._maxerrs;
    }

    protected int getMaxWarns() {
        return this._maxwarns;
    }
}

