/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.internal.gosu.parser.StringCache;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.Keyword;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.util.concurrent.LocklessLazyVar;

public class LazyType
extends LocklessLazyVar<IType> {
    private final CharSequence _typeName;
    private final ITypeUsesMap _typeUsesMap;

    public LazyType(String typeName) {
        this._typeName = StringCache.get(typeName);
        this._typeUsesMap = null;
    }

    public LazyType(CharSequence typeName, ITypeUsesMap typeUsesMap) {
        this._typeName = typeName instanceof String ? StringCache.get((String)typeName) : typeName;
        this._typeUsesMap = typeUsesMap;
    }

    public LazyType(IType entryType) {
        this._typeName = entryType.getName();
        this._typeUsesMap = null;
        this.initDirectly(entryType);
    }

    public String getName() {
        return this._typeName.toString();
    }

    public String getNameFromType() {
        String retValue;
        try {
            IType type = (IType)this.get();
            retValue = type instanceof IMetaType ? "Type" : type.getName();
        }
        catch (Exception e) {
            retValue = this.getName();
        }
        return retValue;
    }

    @Override
    protected IType init() {
        TypeSystem.pushGlobalModule();
        try {
            IType iType = LazyType.getType(this._typeName.toString(), this._typeUsesMap);
            return iType;
        }
        catch (ClassNotFoundException e) {
            IErrorType iErrorType = TypeSystem.getErrorType();
            return iErrorType;
        }
        finally {
            TypeSystem.popGlobalModule();
        }
    }

    private static IType getType(String strType, ITypeUsesMap _typeUsesMap) throws ClassNotFoundException {
        if (strType.contains("<") || strType.startsWith(Keyword.KW_block.toString())) {
            TypeSystem.lock();
            try {
                IType iType = TypeSystem.parseType(strType, new TypeVarToTypeMap(), _typeUsesMap);
                return iType;
            }
            finally {
                TypeSystem.unlock();
            }
        }
        if (strType.startsWith("entity.")) {
            return TypeSystem.getByFullName(strType);
        }
        if (strType.endsWith("[]")) {
            String baseTypeName = strType.substring(0, strType.length() - 2);
            IType baseType = LazyType.getType(baseTypeName, _typeUsesMap);
            return baseType == null ? null : baseType.getArrayType();
        }
        return _typeUsesMap == null ? TypeSystem.getByRelativeName(strType) : TypeSystem.getByRelativeName(strType, _typeUsesMap);
    }
}

