/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.parser.IExpression;
import gw.lang.parser.IScriptPartId;
import gw.lang.reflect.AbstractType;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.FunctionTypeInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IGenericMethodInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.util.perf.objectsize.UnmodifiableSizeTwoSet;
import java.io.ObjectStreamException;
import java.util.Set;

public class ParameterizedFunctionType
extends AbstractType
implements IFunctionType {
    private FunctionType _genericFuncType;
    private IType[] _typeParams;
    private transient FunctionTypeInfo _typeInfo;
    private transient IType _retType;
    private transient Set<IType> _allTypesInHierarchy;
    private transient IType[] _paramTypes;
    private transient String _signature;

    public ParameterizedFunctionType(FunctionType genericType, IType ... typeParams) {
        this._genericFuncType = genericType;
        this._typeParams = typeParams;
    }

    @Override
    public IType getReturnType() {
        if (this._retType != null) {
            return this._retType;
        }
        IGenericMethodInfo gmi = (IGenericMethodInfo)((Object)this._genericFuncType.getMethodInfo());
        gmi = gmi == null ? this._genericFuncType : gmi;
        this._retType = gmi.getParameterizedReturnType(this._typeParams);
        return this._retType;
    }

    @Override
    public IType[] getParameterTypes() {
        if (this._paramTypes != null) {
            return this._paramTypes;
        }
        IGenericMethodInfo gmi = (IGenericMethodInfo)((Object)this._genericFuncType.getMethodInfo());
        gmi = gmi == null ? this._genericFuncType : gmi;
        this._paramTypes = gmi.getParameterizedParameterTypes2(this._genericFuncType.getOwningParameterizedType(), this._typeParams);
        return this._paramTypes;
    }

    @Override
    public IMethodInfo getMethodInfo() {
        return this._genericFuncType.getMethodInfo();
    }

    @Override
    public IFeatureInfo getMethodOrConstructorInfo() {
        return this._genericFuncType.getMethodOrConstructorInfo();
    }

    @Override
    public String getParamSignature() {
        if (this._signature == null) {
            String strParams = this._genericFuncType.getName() + "(";
            IType[] parameterTypes = this.getParameterTypes();
            if (parameterTypes != null) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    strParams = strParams + (i == 0 ? "" : ", ") + (parameterTypes[i] == null ? "" : parameterTypes[i].getName());
                }
            }
            this._signature = strParams = strParams + ")";
        }
        return this._signature;
    }

    @Override
    public String getParamSignatureForCurrentModule() {
        if (this._signature == null) {
            String strParams = this._genericFuncType.getName() + "(";
            IType[] parameterTypes = this.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                strParams = strParams + (i == 0 ? "" : ", ") + (parameterTypes[i] == null ? "" : FunctionType.getParamTypeNameFromJavaBackedType(parameterTypes[i]));
            }
            this._signature = strParams = strParams + ")";
        }
        return this._signature;
    }

    @Override
    public String getName() {
        return this._genericFuncType.getName();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getRelativeName() {
        return this.getName();
    }

    @Override
    public String getNamespace() {
        return this._genericFuncType.getNamespace();
    }

    @Override
    public ITypeLoader getTypeLoader() {
        return this._genericFuncType.getTypeLoader();
    }

    @Override
    public boolean isInterface() {
        return this._genericFuncType.isInterface();
    }

    @Override
    public IType[] getInterfaces() {
        return this._genericFuncType.getInterfaces();
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public IType getSupertype() {
        return this._genericFuncType.getSupertype();
    }

    @Override
    public IType getEnclosingType() {
        return this._genericFuncType.getEnclosingType();
    }

    @Override
    public IType getGenericType() {
        return this.isGenericType() ? this : this._genericFuncType;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isParameterizedType() {
        return true;
    }

    @Override
    public boolean isGenericType() {
        return false;
    }

    @Override
    public IGenericTypeVariable[] getGenericTypeVariables() {
        return null;
    }

    @Override
    public IFunctionType inferParameterizedTypeFromArgTypesAndContextType(IType[] eArgs, IType ctxType) {
        throw new IllegalStateException("Tried to infer parameterization on an already parameterized type.");
    }

    @Override
    public ParameterizedFunctionType getParameterizedType(IType ... paramTypes) {
        throw new IllegalStateException("Tried to parameterize an already parameterized type.");
    }

    @Override
    public IType[] getTypeParameters() {
        return this._typeParams;
    }

    public Set<IType> getAllTypesInHierarchy() {
        if (this._allTypesInHierarchy == null) {
            this._allTypesInHierarchy = new UnmodifiableSizeTwoSet<FunctionType>((FunctionType)((Object)this), this._genericFuncType);
        }
        return this._allTypesInHierarchy;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public IType getArrayType() {
        return null;
    }

    @Override
    public Object makeArrayInstance(int iLength) {
        throw new UnsupportedOperationException("Can't create an array of a parameterized function type.");
    }

    @Override
    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return null;
    }

    @Override
    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getArrayLength(Object array) throws IllegalArgumentException {
        return 0;
    }

    @Override
    public IType getComponentType() {
        return null;
    }

    @Override
    public boolean isAssignableFrom(IType type) {
        return type.getAllTypesInHierarchy().contains(this);
    }

    @Override
    public boolean isAssignableFrom(IType type, boolean bContravariant) {
        return this.isAssignableFrom(type);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public ITypeInfo getTypeInfo() {
        return this._typeInfo == null ? (this._typeInfo = new FunctionTypeInfo(this)) : this._typeInfo;
    }

    @Override
    public void unloadTypeInfo() {
        this._typeInfo = null;
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return this._genericFuncType.getParameterizedType(this._typeParams);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getModifiers() {
        return this._typeInfo != null ? Modifier.getModifiersFrom(this._typeInfo) : 1;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    public IScriptPartId getContext() {
        return this._genericFuncType.getScriptPart();
    }

    public void setContext(IScriptPartId partId) {
        this._genericFuncType.setScriptPart(partId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterizedFunctionType)) {
            return false;
        }
        ParameterizedFunctionType functionType = (ParameterizedFunctionType)o;
        return this.getParamSignature().equals(functionType.getParamSignature());
    }

    public int hashCode() {
        return this.getParamSignature().hashCode();
    }

    public String toString() {
        return this.getParamSignature().toString();
    }

    @Override
    public boolean areParamsCompatible(IFunctionType rhsType) {
        IType[] rhsParams;
        IType[] lhsParams = this.getParameterTypes();
        if (lhsParams.length != (rhsParams = rhsType.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < rhsParams.length; ++i) {
            IType otherParamType = rhsParams[i];
            IType myParamType = lhsParams[i];
            if (otherParamType.isAssignableFrom(myParamType) || myParamType instanceof ITypeVariableType) continue;
            return false;
        }
        return true;
    }

    @Override
    public IScriptPartId getScriptPart() {
        return this.getContext();
    }

    @Override
    public IType newInstance(IType[] paramTypes, IType returnType) {
        return new ParameterizedFunctionType((FunctionType)this._genericFuncType.newInstance(paramTypes, returnType), this._typeParams);
    }

    @Override
    public boolean isDiscarded() {
        return false;
    }

    @Override
    public void setDiscarded(boolean bDiscarded) {
    }

    @Override
    public boolean isCompoundType() {
        return false;
    }

    @Override
    public Set<IType> getCompoundTypeComponents() {
        return null;
    }

    @Override
    public String[] getParameterNames() {
        if (this._genericFuncType != null) {
            return this._genericFuncType.getParameterNames();
        }
        return new String[0];
    }

    @Override
    public IExpression[] getDefaultValueExpressions() {
        if (this._genericFuncType != null) {
            return this._genericFuncType.getDefaultValueExpressions();
        }
        return IExpression.EMPTY_ARRAY;
    }

    @Override
    public boolean hasOptionalParams() {
        if (this._genericFuncType != null) {
            return this._genericFuncType.hasOptionalParams();
        }
        return false;
    }
}

