/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java.asm;

import gw.internal.ext.org.objectweb.asm.Type;
import gw.lang.reflect.java.asm.AsmPrimitiveType;
import gw.lang.reflect.java.asm.AsmType;

public class AsmUtil {
    public static String makeDotName(String name) {
        return name.replace('/', '.');
    }

    public static String makeBaseName(String name) {
        if (name.length() == 1) {
            return name;
        }
        while (name.charAt(0) == '[') {
            name = name.substring(1);
        }
        if (name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        } else {
            AsmPrimitiveType asmType = AsmPrimitiveType.findPrimitive(name);
            if (asmType != null) {
                name = asmType.getName();
            }
        }
        return AsmUtil.makeDotName(name);
    }

    public static AsmType makeType(Type type) {
        if (type.getSort() >= 9) {
            return AsmUtil.makeType(type.getInternalName());
        }
        return AsmPrimitiveType.findPrimitive(type.getClassName());
    }

    public static AsmType makeType(String name) {
        if (name.length() == 1) {
            return AsmPrimitiveType.findPrimitive(name);
        }
        int iDims = 0;
        while (name.charAt(0) == '[') {
            ++iDims;
            name = name.substring(1);
        }
        if (name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        } else {
            AsmPrimitiveType asmType = AsmPrimitiveType.findPrimitive(name);
            if (asmType != null) {
                name = asmType.getName();
            }
        }
        return new AsmType(AsmUtil.makeDotName(name), iDims);
    }

    public static AsmType makeNonPrimitiveType(String name) {
        int iDims = 0;
        while (name.charAt(0) == '[') {
            ++iDims;
            name = name.substring(1);
        }
        if (name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        return new AsmType(AsmUtil.makeDotName(name), iDims);
    }

    public static AsmType makeTypeVariable(String tv) {
        return AsmUtil.makeTypeVariable(tv, false);
    }

    public static AsmType makeTypeVariable(String tv, boolean bFunctionTypeVar) {
        AsmType typeVarType = new AsmType(tv);
        typeVarType.setTypeVariable();
        typeVarType.setFunctionTypeVariable(bFunctionTypeVar);
        return typeVarType;
    }
}

