/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java.asm;

import gw.internal.ext.org.objectweb.asm.signature.SignatureVisitor;
import gw.lang.reflect.java.asm.AsmClass;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.AsmUtil;
import gw.lang.reflect.java.asm.DeclarationPartSignatureVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class TypeDeclarationSignatureVisitor
extends SignatureVisitor {
    private AsmClass _asmClass;
    private DeclarationPartSignatureVisitor _superType;
    private List<DeclarationPartSignatureVisitor> _interfaces = Collections.emptyList();
    private AsmType _csrTypeVar;

    TypeDeclarationSignatureVisitor(AsmClass asmClass) {
        super(327680);
        this._asmClass = asmClass;
    }

    public void update() {
        if (this._superType != null) {
            this._asmClass.setSuperClass(this._superType.getCurrentType());
        }
        this._asmClass.getInterfaces().clear();
        for (DeclarationPartSignatureVisitor visitor : this._interfaces) {
            this._asmClass.getInterfaces().add(visitor.getCurrentType());
        }
    }

    public void visitFormalTypeParameter(String tv) {
        this._csrTypeVar = AsmUtil.makeTypeVariable(tv);
        this._asmClass.setGeneric();
        this._asmClass.getType().addTypeParameter(this._csrTypeVar);
    }

    public SignatureVisitor visitClassBound() {
        return new DeclarationPartSignatureVisitor(this._csrTypeVar);
    }

    public SignatureVisitor visitInterfaceBound() {
        return new DeclarationPartSignatureVisitor(this._csrTypeVar);
    }

    public SignatureVisitor visitSuperclass() {
        DeclarationPartSignatureVisitor visitor;
        this._superType = visitor = new DeclarationPartSignatureVisitor();
        return visitor;
    }

    public SignatureVisitor visitInterface() {
        DeclarationPartSignatureVisitor visitor = new DeclarationPartSignatureVisitor();
        if (this._interfaces.isEmpty()) {
            this._interfaces = new ArrayList<DeclarationPartSignatureVisitor>(2);
        }
        this._interfaces.add(visitor);
        return visitor;
    }

    public void visitTypeVariable(String tv) {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitArrayType() {
        throw new IllegalStateException();
    }

    public void visitEnd() {
        throw new IllegalStateException();
    }
}

