/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.lang.reflect.TypeSystem;

public abstract class LazyInit {
    private boolean _initializing = false;
    private boolean _initialized = false;

    protected final void maybeInit() {
        TypeSystem.lock();
        try {
            if (this._initialized) {
                return;
            }
            if (this._initializing) {
                throw new IllegalStateException("Recursive Initialization");
            }
            this._initializing = true;
            try {
                this.initialize();
                this._initialized = true;
            }
            finally {
                this._initializing = false;
            }
        }
        finally {
            TypeSystem.unlock();
        }
    }

    protected abstract void initialize();
}

