/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.config.CommonServices;
import gw.lang.parser.ICoercer;
import gw.lang.parser.IExpression;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.TypeSystemAwareCache;
import gw.lang.parser.coercers.BasePrimitiveCoercer;
import gw.lang.parser.coercers.FunctionToInterfaceCoercer;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IConstructorType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IInvocableType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoaderListener;
import gw.lang.reflect.MethodScore;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import gw.util.Pair;
import gw.util.concurrent.Cache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MethodScorer {
    public static final int BOXED_COERCION_SCORE = 10;
    public static final int PRIMITIVE_COERCION_SCORE = 24;
    private static volatile MethodScorer INSTANCE = null;
    private final TypeSystemAwareCache<Pair<IType, IType>, Integer> _typeScoreCache = TypeSystemAwareCache.make("Type Score Cache", 1000, new Cache.MissHandler<Pair<IType, IType>, Integer>(){

        @Override
        public final Integer load(Pair<IType, IType> key) {
            return MethodScorer.this._addToScoreForTypes(Collections.emptyList(), key.getFirst(), key.getSecond());
        }
    });
    private final MethodScoreCache _methodScoreCache = new MethodScoreCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodScorer instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<MethodScorer> clazz = MethodScorer.class;
        synchronized (MethodScorer.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new MethodScorer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private MethodScorer() {
    }

    public List<MethodScore> scoreMethods(List<IInvocableType> funcTypes, List<IType> argTypes) {
        ArrayList<MethodScore> scores = new ArrayList<MethodScore>();
        for (IInvocableType funcType : funcTypes) {
            scores.add(this.scoreMethod(funcType, Collections.emptyList(), argTypes, Collections.emptyList(), funcTypes.size() == 1, true));
        }
        Collections.sort(scores);
        return scores;
    }

    public MethodScore scoreMethod(IInvocableType funcType, List<? extends IInvocableType> listFunctionTypes, List<IType> argTypes, List<IType> inferringTypes, boolean bSkipScoring, boolean bLookInCache) {
        MethodScore score = new MethodScore();
        score.setValid(true);
        if (!bSkipScoring) {
            IInvocableType cachedFuncType = bLookInCache ? this.getCachedMethodScore(funcType, argTypes) : null;
            if ((cachedFuncType = this.matchInOverloads(listFunctionTypes, cachedFuncType)) != null) {
                score.setRawFunctionType(cachedFuncType);
                score.setScore(0L);
            } else {
                score.setRawFunctionType(funcType);
                score.incScore(this.scoreMethod(funcType, argTypes, inferringTypes));
            }
        } else {
            score.setRawFunctionType(funcType);
        }
        return score;
    }

    private IInvocableType matchInOverloads(List<? extends IInvocableType> listOverloads, IInvocableType cachedFuncType) {
        if (cachedFuncType == null) {
            return null;
        }
        for (IInvocableType iInvocableType : listOverloads) {
            if (!iInvocableType.equals(cachedFuncType)) continue;
            return iInvocableType;
        }
        return null;
    }

    public int scoreMethod(IInvocableType funcType, List<IType> argTypes, List<IType> inferringTypes) {
        int i;
        IType[] paramTypes = funcType.getParameterTypes();
        int iScore = 0;
        for (i = 0; i < argTypes.size(); ++i) {
            if (paramTypes.length <= i) {
                iScore += 128;
                continue;
            }
            IType argType = argTypes.get(i);
            if (funcType instanceof IBlockType) {
                iScore += this.addToScoreForTypes(inferringTypes, argType, paramTypes[i]);
                continue;
            }
            iScore += this.addToScoreForTypes(inferringTypes, paramTypes[i], argType);
        }
        for (i = argTypes.size(); i < paramTypes.length; ++i) {
            iScore += 127;
        }
        return iScore;
    }

    public int addToScoreForTypes(List<IType> inferringTypes, IType paramType, IType argType) {
        if (inferringTypes.isEmpty() || !(paramType instanceof IInvocableType)) {
            IType iType = paramType = inferringTypes.isEmpty() ? paramType : TypeSystem.boundTypes(paramType, inferringTypes);
            if (argType == paramType) {
                return 0;
            }
            return (Integer)this._typeScoreCache.get(new Pair<IType, IType>(paramType, argType));
        }
        if (argType == paramType) {
            return 0;
        }
        return this._addToScoreForTypes(inferringTypes, paramType, argType);
    }

    public int _addToScoreForTypes(List<IType> inferringTypes, IType paramType, IType argType) {
        IType primitiveArgType;
        IType primitiveParamType;
        int iScore;
        if ((paramType = TypeSystem.boundTypes(paramType, inferringTypes)).equals(argType)) {
            iScore = 0;
        } else if (!paramType.isPrimitive() && argType == JavaTypes.pVOID()) {
            iScore = 1;
        } else if (this.arePrimitiveTypesCompatible(paramType, argType)) {
            iScore = BasePrimitiveCoercer.getPriorityOf(paramType, argType);
        } else if (TypeSystem.isBoxedTypeFor(paramType, argType) || TypeSystem.isBoxedTypeFor(argType, paramType)) {
            iScore = 10;
        } else if (argType.isPrimitive() && StandardCoercionManager.isBoxed(paramType) && this.arePrimitiveTypesCompatible(primitiveParamType = TypeSystem.getPrimitiveType(paramType), argType)) {
            iScore = 10 + BasePrimitiveCoercer.getPriorityOf(primitiveParamType, argType);
        } else if (StandardCoercionManager.isBoxed(argType) && paramType.isPrimitive() && this.arePrimitiveTypesCompatible(paramType, primitiveArgType = TypeSystem.getPrimitiveType(argType))) {
            iScore = 10 + BasePrimitiveCoercer.getPriorityOf(paramType, primitiveArgType);
        } else if (StandardCoercionManager.isBoxed(argType) && StandardCoercionManager.isBoxed(paramType) && this.arePrimitiveTypesCompatible(primitiveParamType = TypeSystem.getPrimitiveType(paramType), primitiveArgType = TypeSystem.getPrimitiveType(argType))) {
            iScore = 20 + BasePrimitiveCoercer.getPriorityOf(primitiveParamType, primitiveArgType);
        } else {
            IFunctionType funcType;
            int iFunctionToInterfacePenalty = 0;
            if (paramType.isInterface() && argType instanceof IInvocableType && (funcType = FunctionToInterfaceCoercer.getRepresentativeFunctionType(paramType)) != null) {
                paramType = funcType;
                iFunctionToInterfacePenalty = 2;
            }
            if (paramType instanceof IInvocableType && argType instanceof IInvocableType) {
                int iDegrees = this.addDegreesOfSeparation(paramType, argType, inferringTypes);
                int paramCountPlusReturn = Math.max(((IInvocableType)paramType).getParameterTypes().length, ((IInvocableType)argType).getParameterTypes().length) + 1;
                iScore = Math.min(117, (iDegrees + paramCountPlusReturn - 1) / paramCountPlusReturn);
                iScore += iFunctionToInterfacePenalty;
            } else {
                ICoercer iCoercer;
                IType boxedArgType;
                iScore = argType.isPrimitive() && argType != JavaTypes.pVOID() && !paramType.isPrimitive() && paramType.isAssignableFrom(boxedArgType = TypeSystem.getBoxType(argType)) ? 10 + this.addDegreesOfSeparation(paramType, boxedArgType, inferringTypes) : (paramType.isAssignableFrom(argType) ? (!(argType instanceof IInvocableType) ? this.addDegreesOfSeparation(paramType, argType, inferringTypes) : 125) : (StandardCoercionManager.isStructurallyAssignable(paramType, argType) ? 125 : ((iCoercer = CommonServices.getCoercionManager().findCoercer(paramType, argType, false)) != null ? (iCoercer instanceof BasePrimitiveCoercer ? 24 + iCoercer.getPriority(paramType, argType) : 127 - iCoercer.getPriority(paramType, argType) - 1) : 126)));
            }
        }
        return iScore;
    }

    private boolean arePrimitiveTypesCompatible(IType paramType, IType argType) {
        return StandardCoercionManager.arePrimitiveTypesAssignable(paramType, argType) || paramType.isPrimitive() && argType.isPrimitive() && paramType != JavaTypes.pBOOLEAN() && argType != JavaTypes.pBOOLEAN() && paramType != JavaTypes.pCHAR() && argType != JavaTypes.pCHAR() && paramType != JavaTypes.pVOID() && argType != JavaTypes.pVOID() && BasePrimitiveCoercer.losesInformation(argType, paramType) <= 1;
    }

    public int addDegreesOfSeparation(IType parameterType, IType exprType, List<IType> inferringTypes) {
        return this.addDegreesOfSeparation(parameterType, exprType instanceof IInvocableType ? Collections.singleton(exprType) : exprType.getAllTypesInHierarchy(), inferringTypes);
    }

    /*
     * WARNING - void declaration
     */
    public int addDegreesOfSeparation(IType parameterType, Set<? extends IType> types, List<IType> inferringTypes) {
        int iScore = 0;
        if (parameterType.isParameterizedType()) {
            parameterType = this.getGenericType(parameterType);
        }
        for (IType iType : types) {
            void var6_6;
            IType iType2;
            if (iType.isParameterizedType() && types.contains(iType2 = this.getGenericType(iType)) || parameterType == var6_6) continue;
            if (parameterType instanceof IInvocableType && var6_6 instanceof IInvocableType) {
                iScore += this.scoreMethod((IInvocableType)parameterType, Arrays.asList(((IInvocableType)var6_6).getParameterTypes()), inferringTypes);
                if (!(parameterType instanceof IFunctionType) || !(var6_6 instanceof IFunctionType)) continue;
                iScore += this.addToScoreForTypes(inferringTypes, ((IFunctionType)parameterType).getReturnType(), ((IFunctionType)var6_6).getReturnType());
                continue;
            }
            if (!parameterType.isAssignableFrom((IType)var6_6)) continue;
            ++iScore;
        }
        return iScore;
    }

    public <E extends IType> E getGenericType(E type) {
        if (type == null || TypeSystem.isDeleted(type)) {
            return null;
        }
        if (type.isArray()) {
            return (E)this.getGenericType(type.getComponentType()).getArrayType();
        }
        while (type.isParameterizedType()) {
            type = type.getGenericType();
        }
        return type;
    }

    public IInvocableType getCachedMethodScore(IInvocableType funcType, List<IType> argTypes) {
        return (IInvocableType)this._methodScoreCache.get(new MethodScoreKey(argTypes, funcType));
    }

    public void putCachedMethodScore(MethodScore score) {
        score.setScore(0L);
        List<IExpression> argExpressions = score.getArguments();
        ArrayList<IType> argTypes = new ArrayList<IType>(argExpressions.size());
        for (IExpression argExpression : argExpressions) {
            argTypes.add(argExpression.getType());
        }
        this._methodScoreCache.put(new MethodScoreKey(argTypes, score.getRawFunctionType()), score.getRawFunctionType());
    }

    private class MethodScoreKey {
        private String _methodName;
        private IType _enclosingType;
        private List<IType> _argTypes;

        private MethodScoreKey(List<IType> argTypes, IInvocableType funcType) {
            this._argTypes = argTypes;
            if (funcType instanceof IConstructorType) {
                this._methodName = "construct";
                this._enclosingType = ((IConstructorType)funcType).getDeclaringType();
            } else {
                this._methodName = funcType.getDisplayName();
                this._enclosingType = funcType.getEnclosingType();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodScoreKey that = (MethodScoreKey)o;
            if (!this._argTypes.equals(that._argTypes)) {
                return false;
            }
            if (this._enclosingType != null ? !this._enclosingType.equals(that._enclosingType) : that._enclosingType != null) {
                return false;
            }
            return this._methodName.equals(that._methodName);
        }

        public int hashCode() {
            int result = this._methodName.hashCode();
            result = 31 * result + (this._enclosingType != null ? this._enclosingType.hashCode() : 0);
            result = 31 * result + this._argTypes.hashCode();
            return result;
        }
    }

    private static class MethodScoreCache
    extends HashMap<MethodScoreKey, IInvocableType>
    implements ITypeLoaderListener {
        MethodScoreCache() {
            TypeSystem.addTypeLoaderListenerAsWeakRef(this);
        }

        @Override
        public void refreshed() {
            this.clear();
        }

        @Override
        public void refreshedTypes(RefreshRequest request) {
            this.clear();
        }
    }
}

