/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.interval;

import gw.lang.reflect.interval.AbstractLongIterator;
import gw.lang.reflect.interval.NumberInterval;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LongInterval
extends NumberInterval<Long, LongInterval> {
    public LongInterval(Long left, Long right) {
        this(left, right, 1L, true, true, false);
    }

    public LongInterval(Long left, Long right, long lStep, boolean bLeftClosed, boolean bRightClosed, boolean bReverse) {
        super(left, right, lStep, bLeftClosed, bRightClosed, bReverse);
        if (lStep <= 0L) {
            throw new IllegalArgumentException("The step must be greater than 0: " + lStep);
        }
    }

    @Override
    public Iterator<Long> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<Long> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public Long getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isLeftClosed()) {
            ++iStepIndex;
        }
        long value = (Long)this.getLeftEndpoint() + (Long)this.getStep() * (long)iStepIndex;
        if (this.isRightClosed() ? value <= (Long)this.getRightEndpoint() : value < (Long)this.getRightEndpoint()) {
            return value;
        }
        return null;
    }

    @Override
    public Long getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isRightClosed()) {
            ++iStepIndex;
        }
        long value = (Long)this.getRightEndpoint() - (Long)this.getStep() * (long)iStepIndex;
        if (this.isLeftClosed() ? value >= (Long)this.getLeftEndpoint() : value > (Long)this.getLeftEndpoint()) {
            return value;
        }
        return null;
    }

    private class ReverseIterator
    extends AbstractLongIterator {
        private long _csr;

        public ReverseIterator() {
            this._csr = (Long)LongInterval.this.getRightEndpoint();
            if (!LongInterval.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr > (Long)LongInterval.this.getLeftEndpoint() || LongInterval.this.isLeftClosed() && this._csr == (Long)LongInterval.this.getLeftEndpoint();
        }

        @Override
        public Long next() {
            return this.nextLong();
        }

        @Override
        public long nextLong() {
            if (this._csr < (Long)LongInterval.this.getLeftEndpoint() || !LongInterval.this.isLeftClosed() && this._csr == (Long)LongInterval.this.getLeftEndpoint()) {
                throw new NoSuchElementException();
            }
            long ret = this._csr;
            this._csr -= ((Long)LongInterval.this.getStep()).longValue();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class ForwardIterator
    extends AbstractLongIterator {
        private long _csr;

        public ForwardIterator() {
            this._csr = (Long)LongInterval.this.getLeftEndpoint();
            if (!LongInterval.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr < (Long)LongInterval.this.getRightEndpoint() || LongInterval.this.isRightClosed() && this._csr == (Long)LongInterval.this.getRightEndpoint();
        }

        @Override
        public Long next() {
            return this.nextLong();
        }

        @Override
        public long nextLong() {
            if (this._csr > (Long)LongInterval.this.getRightEndpoint() || !LongInterval.this.isRightClosed() && this._csr == (Long)LongInterval.this.getRightEndpoint()) {
                throw new NoSuchElementException();
            }
            long ret = this._csr;
            this._csr += ((Long)LongInterval.this.getStep()).longValue();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

