/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import com.github.benmanes.caffeine.cache.CacheLoader;
import gw.config.BaseService;
import gw.config.CommonServices;
import gw.internal.gosu.parser.IParameterizableType;
import gw.lang.GosuShop;
import gw.lang.IDimension;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.ICoercer;
import gw.lang.parser.ICoercionManager;
import gw.lang.parser.IFullParserState;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.IParserState;
import gw.lang.parser.TypeSystemAwareCache;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.parser.coercers.BasePrimitiveCoercer;
import gw.lang.parser.coercers.BigDecimalCoercer;
import gw.lang.parser.coercers.BigIntegerCoercer;
import gw.lang.parser.coercers.BlockCoercer;
import gw.lang.parser.coercers.BooleanCoercer;
import gw.lang.parser.coercers.BooleanHighPriorityCoercer;
import gw.lang.parser.coercers.BooleanPHighPriorityCoercer;
import gw.lang.parser.coercers.ByteCoercer;
import gw.lang.parser.coercers.ByteHighPriorityCoercer;
import gw.lang.parser.coercers.BytePHighPriorityCoercer;
import gw.lang.parser.coercers.CharCoercer;
import gw.lang.parser.coercers.CharHighPriorityCoercer;
import gw.lang.parser.coercers.CharPHighPriorityCoercer;
import gw.lang.parser.coercers.DoubleCoercer;
import gw.lang.parser.coercers.DoubleHighPriorityCoercer;
import gw.lang.parser.coercers.DoublePHighPriorityCoercer;
import gw.lang.parser.coercers.FeatureReferenceToBlockCoercer;
import gw.lang.parser.coercers.FloatCoercer;
import gw.lang.parser.coercers.FloatHighPriorityCoercer;
import gw.lang.parser.coercers.FloatPHighPriorityCoercer;
import gw.lang.parser.coercers.FunctionFromInterfaceCoercer;
import gw.lang.parser.coercers.FunctionToInterfaceCoercer;
import gw.lang.parser.coercers.IMonitorLockCoercer;
import gw.lang.parser.coercers.IdentityCoercer;
import gw.lang.parser.coercers.IntCoercer;
import gw.lang.parser.coercers.IntHighPriorityCoercer;
import gw.lang.parser.coercers.IntPHighPriorityCoercer;
import gw.lang.parser.coercers.LongCoercer;
import gw.lang.parser.coercers.LongHighPriorityCoercer;
import gw.lang.parser.coercers.LongPHighPriorityCoercer;
import gw.lang.parser.coercers.MetaTypeToClassCoercer;
import gw.lang.parser.coercers.NonWarningStringCoercer;
import gw.lang.parser.coercers.RuntimeCoercer;
import gw.lang.parser.coercers.ShortCoercer;
import gw.lang.parser.coercers.ShortHighPriorityCoercer;
import gw.lang.parser.coercers.ShortPHighPriorityCoercer;
import gw.lang.parser.coercers.StandardCoercer;
import gw.lang.parser.coercers.StringCoercer;
import gw.lang.parser.coercers.TypeVariableCoercer;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.resources.Res;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IHasJavaClass;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeVariableArrayType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.features.FeatureReference;
import gw.lang.reflect.features.IMethodReference;
import gw.lang.reflect.gs.IGosuArrayClass;
import gw.lang.reflect.gs.IGosuArrayClassInstance;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.java.IJavaArrayType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuExceptionUtil;
import gw.util.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class StandardCoercionManager
extends BaseService
implements ICoercionManager {
    private static final DecimalFormat BIG_DECIMAL_FORMAT = new DecimalFormat();
    public static final Object NO_DICE;
    public final TypeSystemAwareCache<Pair<IType, IType>, ICoercer> _coercerCache = TypeSystemAwareCache.make("Coercer Cache", 1000, new CacheLoader<Pair<IType, IType>, ICoercer>(){

        public final ICoercer load(Pair<IType, IType> key) {
            ICoercer coercer = StandardCoercionManager.this.findCoercerImpl(key.getFirst(), key.getSecond(), false);
            if (coercer == null) {
                return NullSentinalCoercer.instance();
            }
            return coercer;
        }
    });
    private IType NULL_COMP = TypeSystem.getErrorType("_NULL_COMP_");
    private final TypeSystemAwareCache<TypesComp, IType> _compCache = TypeSystemAwareCache.make("verifyTypesComparable Cache", 2000, tc -> {
        IType type = this._verifyTypesComparable(tc._lhs, tc._rhs, tc._bBiDirectional);
        if (type == null) {
            return this.NULL_COMP;
        }
        return type;
    });

    @Override
    public final boolean canCoerce(IType lhsType, IType rhsType) {
        ICoercer iCoercer = this.findCoercer(lhsType, rhsType, false);
        return iCoercer != null;
    }

    private Object coerce(IType intrType, IType runtimeType, Object value) {
        ICoercer coercer = this.findCoercer(intrType, runtimeType, true);
        if (coercer != null) {
            return coercer.coerceValue(intrType, value);
        }
        return null;
    }

    private boolean hasPotentialLossOfPrecisionOrScale(IType lhsType, IType rhsType) {
        if ((lhsType.isPrimitive() || JavaTypes.NUMBER().isAssignableFrom(lhsType)) && rhsType.isFinal() && JavaTypes.IDIMENSION().isAssignableFrom(rhsType)) {
            IType rhsDimension = TypeSystem.findParameterizedType(rhsType, JavaTypes.IDIMENSION());
            IType[] typeParameters = rhsDimension.getTypeParameters();
            if (typeParameters == null) {
                return true;
            }
            rhsType = typeParameters[1];
        }
        if (lhsType == JavaTypes.pBYTE() || lhsType == JavaTypes.BYTE()) {
            return rhsType != JavaTypes.pBYTE() && rhsType != JavaTypes.BYTE();
        }
        if (lhsType == JavaTypes.pCHAR() || lhsType == JavaTypes.CHARACTER()) {
            return rhsType != JavaTypes.pCHAR() && rhsType != JavaTypes.CHARACTER();
        }
        if (lhsType == JavaTypes.pDOUBLE() || lhsType == JavaTypes.DOUBLE()) {
            return rhsType != JavaTypes.DOUBLE() && !rhsType.isPrimitive() && (JavaTypes.BIG_DECIMAL().isAssignableFrom(rhsType) || JavaTypes.BIG_INTEGER().isAssignableFrom(rhsType));
        }
        if (lhsType == JavaTypes.pFLOAT() || lhsType == JavaTypes.FLOAT()) {
            return rhsType == JavaTypes.pDOUBLE() || rhsType == JavaTypes.DOUBLE() || JavaTypes.BIG_DECIMAL().isAssignableFrom(rhsType) || JavaTypes.BIG_INTEGER().isAssignableFrom(rhsType);
        }
        if (lhsType == JavaTypes.pINT() || lhsType == JavaTypes.INTEGER()) {
            return rhsType != JavaTypes.pINT() && rhsType != JavaTypes.INTEGER() && rhsType != JavaTypes.pSHORT() && rhsType != JavaTypes.SHORT() && rhsType != JavaTypes.pBYTE() && rhsType != JavaTypes.BYTE() && rhsType != JavaTypes.pCHAR() && rhsType != JavaTypes.CHARACTER();
        }
        if (lhsType == JavaTypes.pLONG() || lhsType == JavaTypes.LONG()) {
            return rhsType != JavaTypes.pLONG() && rhsType != JavaTypes.LONG() && rhsType != JavaTypes.pINT() && rhsType != JavaTypes.INTEGER() && rhsType != JavaTypes.pSHORT() && rhsType != JavaTypes.SHORT() && rhsType != JavaTypes.pBYTE() && rhsType != JavaTypes.BYTE() && rhsType != JavaTypes.pCHAR() && rhsType != JavaTypes.CHARACTER();
        }
        if (lhsType == JavaTypes.pSHORT() || lhsType == JavaTypes.SHORT()) {
            return rhsType != JavaTypes.pSHORT() && rhsType != JavaTypes.SHORT() && rhsType != JavaTypes.pBYTE() && rhsType != JavaTypes.BYTE();
        }
        if (JavaTypes.BIG_INTEGER().isAssignableFrom(lhsType)) {
            return rhsType != JavaTypes.BIG_INTEGER() && this.hasPotentialLossOfPrecisionOrScale(JavaTypes.LONG(), rhsType);
        }
        return false;
    }

    @Override
    public final ICoercer findCoercer(IType lhsType, IType rhsType, boolean runtime) {
        if (runtime) {
            return this.findCoercerImpl(lhsType, rhsType, runtime);
        }
        ICoercer iCoercer = (ICoercer)this._coercerCache.get(new Pair<IType, IType>(lhsType, rhsType));
        if (iCoercer == NullSentinalCoercer.instance()) {
            return null;
        }
        return iCoercer;
    }

    private ICoercer findCoercerImpl(IType lhsType, IType rhsType, boolean runtime) {
        IType[] interfaces;
        ICoercer coercer = this.getCoercerInternal(lhsType, rhsType, runtime);
        if (coercer != null) {
            return coercer;
        }
        for (IType anInterface1 : interfaces = rhsType.getInterfaces()) {
            coercer = this.findCoercer(lhsType, anInterface1, runtime);
            if (coercer == null) continue;
            return coercer;
        }
        if (rhsType.getSupertype() == null || this.isPrimitiveOrBoxed(lhsType)) {
            return null;
        }
        return this.findCoercer(lhsType, rhsType.getSupertype(), runtime);
    }

    protected ICoercer getCoercerInternal(IType lhsType, IType rhsType, boolean runtime) {
        IBlockType rBlock;
        IBlockType lBlock;
        ICoercer coercerInternal;
        if (JavaTypes.STRING() == lhsType && !(rhsType instanceof IErrorType)) {
            if (JavaTypes.pCHAR().equals(rhsType) || JavaTypes.CHARACTER().equals(rhsType)) {
                return NonWarningStringCoercer.instance();
            }
            return StringCoercer.instance();
        }
        if (lhsType.isPrimitive() && rhsType.equals(JavaTypes.pVOID())) {
            return null;
        }
        if (this.isPrimitiveOrBoxed(lhsType) && this.isPrimitiveOrBoxed(rhsType)) {
            if (TypeSystem.isBoxedTypeFor(lhsType, rhsType) || TypeSystem.isBoxedTypeFor(rhsType, lhsType)) {
                return this.getHighPriorityPrimitiveOrBoxedConverter(lhsType);
            }
            return this.getPrimitiveOrBoxedConverter(lhsType);
        }
        if (rhsType.isPrimitive() && lhsType.isAssignableFrom(TypeSystem.getBoxType(rhsType))) {
            return this.getPrimitiveOrBoxedConverter(rhsType);
        }
        if (!rhsType.isPrimitive() && "gw.lang.IMonitorLock".equals(lhsType.getName())) {
            return IMonitorLockCoercer.instance();
        }
        if (JavaTypes.CLASS().equals(TypeSystem.getPureGenericType(lhsType)) && rhsType instanceof IMetaType && (((IMetaType)rhsType).getType() instanceof IHasJavaClass || ((IMetaType)rhsType).getType() instanceof ITypeVariableType || ((IMetaType)rhsType).getType() instanceof IMetaType && ((IMetaType)((IMetaType)rhsType).getType()).getType() instanceof IHasJavaClass) && (!lhsType.isParameterizedType() || lhsType.getTypeParameters()[0].isAssignableFrom(((IMetaType)rhsType).getType()) || StandardCoercionManager.isStructurallyAssignable(lhsType.getTypeParameters()[0], rhsType) || StandardCoercionManager.isStructurallyAssignable(lhsType.getTypeParameters()[0], ((IMetaType)rhsType).getType()) || ((IMetaType)rhsType).getType().isPrimitive() && this.canCoerce(lhsType.getTypeParameters()[0], ((IMetaType)rhsType).getType()))) {
            return MetaTypeToClassCoercer.instance();
        }
        if (lhsType instanceof IMetaType && rhsType instanceof IJavaType && JavaTypes.CLASS().equals(TypeSystem.getPureGenericType(rhsType)) && (!rhsType.isParameterizedType() || TypeSystem.canCast(((IMetaType)lhsType).getType(), rhsType.getTypeParameters()[0]) || StandardCoercionManager.isStructurallyAssignable(((IMetaType)lhsType).getType(), rhsType.getTypeParameters()[0]))) {
            return IdentityCoercer.instance();
        }
        if (TypeSystem.isNumericType(lhsType) && TypeSystem.isNumericType(rhsType)) {
            if (lhsType.isPrimitive() || StandardCoercionManager.isBoxed(lhsType)) {
                return this.getPrimitiveOrBoxedConverter(lhsType);
            }
            if (lhsType.equals(JavaTypes.BIG_DECIMAL())) {
                return BigDecimalCoercer.instance();
            }
            if (lhsType.equals(JavaTypes.BIG_INTEGER())) {
                return BigIntegerCoercer.instance();
            }
        }
        if (rhsType instanceof IFunctionType && lhsType.isInterface()) {
            IFunctionType rhsFunctionType = (IFunctionType)rhsType;
            IFunctionType lhsFunctionType = FunctionToInterfaceCoercer.getRepresentativeFunctionType(lhsType);
            if (lhsFunctionType != null) {
                if (lhsFunctionType.isAssignableFrom(rhsFunctionType)) {
                    return FunctionToInterfaceCoercer.instance();
                }
                if (lhsFunctionType.areParamsCompatible(rhsFunctionType)) {
                    ICoercer coercer;
                    IType thisType = lhsFunctionType.getReturnType();
                    IType thatType = rhsFunctionType.getReturnType();
                    if ((thisType == JavaTypes.pVOID() || thisType == JavaTypes.VOID() || thatType != JavaTypes.pVOID() && thatType != JavaTypes.VOID()) && (coercer = this.findCoercer(lhsFunctionType.getReturnType(), rhsFunctionType.getReturnType(), runtime)) != null) {
                        return FunctionToInterfaceCoercer.instance();
                    }
                }
            }
        }
        if (TypeSystem.get(IMethodReference.class).isAssignableFrom(rhsType) && lhsType.isInterface() && (coercerInternal = this.getCoercerInternal(lhsType, rhsType.getTypeParameters()[1], runtime)) != null) {
            return FunctionToInterfaceCoercer.instance();
        }
        if (rhsType instanceof IBlockClass && lhsType.isInterface()) {
            return FunctionToInterfaceCoercer.instance();
        }
        if (lhsType instanceof IFunctionType && TypeSystem.get(FeatureReference.class).getParameterizedType(TypeSystem.get(Object.class), lhsType).isAssignableFrom(rhsType)) {
            return FeatureReferenceToBlockCoercer.instance();
        }
        if (lhsType instanceof IFunctionType && rhsType instanceof IBlockClass && lhsType.isAssignableFrom(((IBlockClass)rhsType).getBlockType())) {
            return IdentityCoercer.instance();
        }
        if (lhsType instanceof IFunctionType && rhsType.isInterface() && FunctionFromInterfaceCoercer.areTypesCompatible((IFunctionType)lhsType, rhsType)) {
            return FunctionFromInterfaceCoercer.instance();
        }
        if (lhsType instanceof IBlockType && rhsType instanceof IBlockType && (lBlock = (IBlockType)lhsType).areParamsCompatible(rBlock = (IBlockType)rhsType)) {
            IType leftType = lBlock.getReturnType();
            IType rightType = rBlock.getReturnType();
            if (rightType != JavaTypes.pVOID() && !this.notCoercibleOrRequiresExplicitCoercion(leftType, rightType)) {
                return BlockCoercer.instance();
            }
        }
        return null;
    }

    @Override
    public boolean isPrimitiveOrBoxed(IType lhsType) {
        return lhsType.isPrimitive() || StandardCoercionManager.isBoxed(lhsType);
    }

    public static boolean isBoxed(IType lhsType) {
        return lhsType == JavaTypes.BOOLEAN() || lhsType == JavaTypes.BYTE() || lhsType == JavaTypes.CHARACTER() || lhsType == JavaTypes.DOUBLE() || lhsType == JavaTypes.FLOAT() || lhsType == JavaTypes.INTEGER() || lhsType == JavaTypes.LONG() || lhsType == JavaTypes.SHORT() || lhsType == JavaTypes.VOID();
    }

    protected ICoercer getPrimitiveOrBoxedConverter(IType type) {
        if (type == JavaTypes.pBOOLEAN()) {
            return BasePrimitiveCoercer.BooleanPCoercer.get();
        }
        if (type == JavaTypes.BOOLEAN()) {
            return BooleanCoercer.instance();
        }
        if (type == JavaTypes.pBYTE()) {
            return BasePrimitiveCoercer.BytePCoercer.get();
        }
        if (type == JavaTypes.BYTE()) {
            return ByteCoercer.instance();
        }
        if (type == JavaTypes.pCHAR()) {
            return BasePrimitiveCoercer.CharPCoercer.get();
        }
        if (type == JavaTypes.CHARACTER()) {
            return CharCoercer.instance();
        }
        if (type == JavaTypes.pDOUBLE()) {
            return BasePrimitiveCoercer.DoublePCoercer.get();
        }
        if (type == JavaTypes.DOUBLE()) {
            return DoubleCoercer.instance();
        }
        if (type == JavaTypes.pFLOAT()) {
            return BasePrimitiveCoercer.FloatPCoercer.get();
        }
        if (type == JavaTypes.FLOAT()) {
            return FloatCoercer.instance();
        }
        if (type == JavaTypes.pINT()) {
            return BasePrimitiveCoercer.IntPCoercer.get();
        }
        if (type == JavaTypes.INTEGER()) {
            return IntCoercer.instance();
        }
        if (type == JavaTypes.pLONG()) {
            return BasePrimitiveCoercer.LongPCoercer.get();
        }
        if (type == JavaTypes.LONG()) {
            return LongCoercer.instance();
        }
        if (type == JavaTypes.pSHORT()) {
            return BasePrimitiveCoercer.ShortPCoercer.get();
        }
        if (type == JavaTypes.SHORT()) {
            return ShortCoercer.instance();
        }
        return null;
    }

    protected ICoercer getHighPriorityPrimitiveOrBoxedConverter(IType type) {
        if (type == JavaTypes.pBOOLEAN()) {
            return BooleanPHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.BOOLEAN()) {
            return BooleanHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.pBYTE()) {
            return BytePHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.BYTE()) {
            return ByteHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.pCHAR()) {
            return CharPHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.CHARACTER()) {
            return CharHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.pDOUBLE()) {
            return DoublePHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.DOUBLE()) {
            return DoubleHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.pFLOAT()) {
            return FloatPHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.FLOAT()) {
            return FloatHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.pINT()) {
            return IntPHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.INTEGER()) {
            return IntHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.pLONG()) {
            return LongPHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.LONG()) {
            return LongHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.pSHORT()) {
            return ShortPHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.SHORT()) {
            return ShortHighPriorityCoercer.instance();
        }
        if (type == JavaTypes.pVOID()) {
            return IdentityCoercer.instance();
        }
        if (type == JavaTypes.VOID()) {
            return IdentityCoercer.instance();
        }
        return null;
    }

    @Override
    public IType verifyTypesComparable(IType lhsType, IType rhsType, boolean bBiDirectional) throws ParseException {
        return this.verifyTypesComparable(lhsType, rhsType, bBiDirectional, null);
    }

    @Override
    public IType verifyTypesComparable(IType lhsType, IType rhsType, boolean bBiDirectional, IFullParserState parserState) throws ParseException {
        if (lhsType == rhsType) {
            return lhsType;
        }
        IType resultType = (IType)this._compCache.get(new TypesComp(lhsType, rhsType, bBiDirectional));
        if (resultType != this.NULL_COMP) {
            return resultType;
        }
        String strLhs = TypeSystem.getNameWithQualifiedTypeVariables(lhsType);
        String strRhs = TypeSystem.getNameWithQualifiedTypeVariables(rhsType);
        throw new ParseException((IParserState)parserState, lhsType, Res.MSG_TYPE_MISMATCH, strLhs, strRhs);
    }

    private IType _verifyTypesComparable(IType lhsType, IType rhsType, boolean bBiDirectional) {
        if (lhsType == rhsType) {
            return lhsType;
        }
        if (lhsType.equals(rhsType)) {
            return lhsType;
        }
        if (lhsType.isAssignableFrom(rhsType)) {
            return lhsType;
        }
        if (JavaTypes.pVOID().equals(rhsType) && !lhsType.isPrimitive()) {
            return lhsType;
        }
        if (JavaTypes.pVOID().equals(lhsType) && !rhsType.isPrimitive()) {
            return rhsType;
        }
        if (lhsType instanceof IErrorType) {
            return lhsType;
        }
        if (rhsType instanceof IErrorType) {
            return rhsType;
        }
        if (lhsType instanceof IPlaceholder && ((IPlaceholder)((Object)lhsType)).isPlaceholder() || rhsType instanceof IPlaceholder && ((IPlaceholder)((Object)rhsType)).isPlaceholder()) {
            return lhsType;
        }
        if (lhsType.isArray() && rhsType.isArray() && lhsType.getComponentType().isPrimitive() == rhsType.getComponentType().isPrimitive() && lhsType.getComponentType().isAssignableFrom(rhsType.getComponentType())) {
            return lhsType;
        }
        if (bBiDirectional) {
            if (rhsType.isAssignableFrom(lhsType)) {
                return lhsType;
            }
            if (lhsType.isArray() && rhsType.isArray() && rhsType.getComponentType().isAssignableFrom(lhsType.getComponentType())) {
                return lhsType;
            }
        }
        if (StandardCoercionManager.isStructurallyAssignable(lhsType, rhsType)) {
            return lhsType;
        }
        if (this.canCoerce(lhsType, rhsType)) {
            return lhsType;
        }
        if (bBiDirectional && this.canCoerce(rhsType, lhsType)) {
            return rhsType;
        }
        return null;
    }

    private static boolean isStrictGenerics(IType type) {
        return type instanceof IParameterizableType && ((IParameterizableType)((Object)type)).isStrictGenerics();
    }

    public static boolean isStructurallyAssignable(IType toType, IType fromType) {
        if (!(toType instanceof IGosuClass && ((IGosuClass)toType).isStructure() || StandardCoercionManager.isStrictGenerics(toType) && toType.getGenericType().isAssignableFrom(TypeSystem.getPureGenericType(fromType)))) {
            return false;
        }
        return StandardCoercionManager.isStructurallyAssignable_Laxed(toType, fromType);
    }

    public static boolean isStructurallyAssignable_Laxed(IType toType, IType fromType) {
        TypeVarToTypeMap inferenceMap = new TypeVarToTypeMap();
        return StandardCoercionManager.isStructurallyAssignable_Laxed(toType, fromType, inferenceMap);
    }

    public static boolean isStructurallyAssignable_Laxed(IType toType, IType fromType, TypeVarToTypeMap inferenceMap) {
        ITypeInfo fromTypeInfo = fromType.getTypeInfo();
        MethodList fromMethods = fromTypeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)fromTypeInfo).getMethods(toType) : fromTypeInfo.getMethods();
        ITypeInfo toTypeInfo = toType.getTypeInfo();
        MethodList toMethods = toTypeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)toTypeInfo).getMethods(fromType) : toTypeInfo.getMethods();
        IType ownersType = toTypeInfo.getOwnersType();
        inferenceMap.setStructural(true);
        for (IMethodInfo toMi : toMethods) {
            IPropertyInfo fromPi;
            IMethodInfo fromMi;
            if (StandardCoercionManager.isObjectMethod(toMi) || toMi.getOwnersType() instanceof IGosuEnhancement || toMi instanceof IAttributedFeatureInfo && toMi.isDefaultImpl() || toMi.isStatic() || (fromMi = fromMethods.findAssignableMethod(toMi, fromType instanceof IMetaType && (!(((IMetaType)fromType).getType() instanceof IGosuClass) || !((IGosuClass)((IMetaType)fromType).getType()).isStructure()), inferenceMap)) != null) continue;
            if (toMi.getDisplayName().startsWith("@") && (fromPi = fromTypeInfo.getProperty(toMi.getDisplayName().substring(1))) != null) {
                boolean bAssignable;
                IType fromPropertyType = fromPi.getFeatureType();
                if (toMi.getParameters().length == 0) {
                    IType toReturnType = MethodList.maybeInferReturnType(inferenceMap, ownersType, fromPropertyType, toMi.getReturnType());
                    boolean bl = bAssignable = toReturnType.equals(fromPropertyType) || StandardCoercionManager.arePrimitiveTypesAssignable(toReturnType, fromPropertyType) || TypeSystem.isBoxedTypeFor(toReturnType, fromPropertyType) || TypeSystem.isBoxedTypeFor(fromPropertyType, toReturnType);
                    if (bAssignable) {
                        continue;
                    }
                } else {
                    IType toParamType = MethodList.maybeInferParamType(inferenceMap, ownersType, fromPropertyType, toMi.getParameters()[0].getFeatureType());
                    boolean bl = bAssignable = fromPi.isWritable(toType) && (fromPi.getFeatureType().equals(toParamType) || StandardCoercionManager.arePrimitiveTypesAssignable(fromPropertyType, toParamType) || TypeSystem.isBoxedTypeFor(toParamType, fromPropertyType) || TypeSystem.isBoxedTypeFor(fromPropertyType, toParamType));
                    if (bAssignable) continue;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean arePrimitiveTypesAssignable(IType toType, IType fromType) {
        if (toType == null || fromType == null || !toType.isPrimitive() || !fromType.isPrimitive()) {
            return false;
        }
        if (toType == fromType) {
            return true;
        }
        if (toType == JavaTypes.pDOUBLE()) {
            return fromType == JavaTypes.pFLOAT() || fromType == JavaTypes.pINT() || fromType == JavaTypes.pCHAR() || fromType == JavaTypes.pSHORT() || fromType == JavaTypes.pBYTE();
        }
        if (toType == JavaTypes.pFLOAT()) {
            return fromType == JavaTypes.pCHAR() || fromType == JavaTypes.pSHORT() || fromType == JavaTypes.pBYTE();
        }
        if (toType == JavaTypes.pLONG()) {
            return fromType == JavaTypes.pINT() || fromType == JavaTypes.pCHAR() || fromType == JavaTypes.pSHORT() || fromType == JavaTypes.pBYTE();
        }
        if (toType == JavaTypes.pINT()) {
            return fromType == JavaTypes.pSHORT() || fromType == JavaTypes.pCHAR() || fromType == JavaTypes.pBYTE();
        }
        if (toType == JavaTypes.pSHORT()) {
            return fromType == JavaTypes.pBYTE();
        }
        return false;
    }

    public static boolean isObjectMethod(IMethodInfo mi) {
        IGosuClass gosuObjectType = GosuShop.getGosuClassFrom(JavaTypes.IGOSU_OBJECT());
        if (mi.getOwnersType() == gosuObjectType || mi.getDisplayName().equals("@itype")) {
            return true;
        }
        IParameterInfo[] params = mi.getParameters();
        IType[] paramTypes = new IType[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getFeatureType();
        }
        IRelativeTypeInfo ti = (IRelativeTypeInfo)JavaTypes.OBJECT().getTypeInfo();
        IMethodInfo objMethod = ti.getMethod(JavaTypes.OBJECT(), mi.getDisplayName(), paramTypes);
        return objMethod != null;
    }

    @Override
    public boolean notCoercibleOrRequiresExplicitCoercion(IType lhsType, IType rhsType) {
        if (lhsType == rhsType) {
            return false;
        }
        if (lhsType.equals(rhsType)) {
            return false;
        }
        if (lhsType.isAssignableFrom(rhsType)) {
            return false;
        }
        if (rhsType.isPrimitive() && lhsType.isAssignableFrom(TypeSystem.getBoxType(rhsType))) {
            return false;
        }
        if (JavaTypes.pVOID().equals(rhsType)) {
            return false;
        }
        if (lhsType instanceof IErrorType) {
            return false;
        }
        if (rhsType instanceof IErrorType) {
            return false;
        }
        if (lhsType instanceof IPlaceholder && ((IPlaceholder)((Object)lhsType)).isPlaceholder() || rhsType instanceof IPlaceholder && ((IPlaceholder)((Object)rhsType)).isPlaceholder()) {
            return false;
        }
        if (lhsType.isArray() && rhsType.isArray() && lhsType.getComponentType().isAssignableFrom(rhsType.getComponentType())) {
            return false;
        }
        if (StandardCoercionManager.isStructurallyAssignable(lhsType, rhsType)) {
            return false;
        }
        if (JavaTypes.pVOID() == lhsType) {
            return false;
        }
        if (TypeSystem.isNumericType(lhsType) && TypeSystem.isNumericType(rhsType)) {
            return this.hasPotentialLossOfPrecisionOrScale(lhsType, rhsType);
        }
        if (TypeSystem.isBoxedTypeFor(lhsType, rhsType) || TypeSystem.isBoxedTypeFor(rhsType, lhsType)) {
            return false;
        }
        ICoercer iCoercer = this.findCoercer(lhsType, rhsType, false);
        return iCoercer == null || iCoercer.isExplicitCoercion();
    }

    @Override
    public final Object convertValue(Object value, IType intrType) {
        if (intrType == null) {
            return null;
        }
        intrType = this.getBoundingTypeOfTypeVariable(intrType);
        if (value == null) {
            return intrType.isPrimitive() ? this.convertNullAsPrimitive(intrType, true) : null;
        }
        IType runtimeType = TypeSystem.getFromObject(value);
        if (intrType instanceof IPlaceholder && ((IPlaceholder)((Object)intrType)).isPlaceholder() || runtimeType instanceof IPlaceholder && ((IPlaceholder)((Object)runtimeType)).isPlaceholder()) {
            return value;
        }
        if (intrType == runtimeType) {
            return value;
        }
        if (intrType.equals(runtimeType)) {
            return value;
        }
        if (intrType.isAssignableFrom(runtimeType)) {
            value = this.extractObjectArray(intrType, value);
            return value;
        }
        if (intrType.isArray() && runtimeType.isArray()) {
            if (intrType.getComponentType().isAssignableFrom(runtimeType.getComponentType())) {
                value = this.extractObjectArray(intrType, value);
                return value;
            }
            if (intrType instanceof IGosuArrayClass && value instanceof IGosuObject[]) {
                return value;
            }
        }
        if (intrType instanceof IJavaType && IGosuClass.ProxyUtil.isProxy(intrType) && runtimeType instanceof IGosuClass && intrType.getSupertype() != null && intrType.getSupertype().isAssignableFrom(runtimeType)) {
            return value;
        }
        if (intrType instanceof IJavaType && ((IJavaType)intrType).getIntrinsicClass().isAssignableFrom(value.getClass())) {
            return value;
        }
        if (intrType instanceof IGosuClass && ((IGosuClass)intrType).isStructure()) {
            return value;
        }
        Object convertedValue = this.coerce(intrType, runtimeType, value);
        if (convertedValue != null) {
            return convertedValue;
        }
        if (this.canCoerce(intrType, runtimeType)) {
            return convertedValue;
        }
        if (!runtimeType.isArray()) {
            return NO_DICE;
        }
        return value;
    }

    private IType getBoundingTypeOfTypeVariable(IType intrType) {
        int i = 0;
        while (intrType instanceof ITypeVariableArrayType) {
            ++i;
            intrType = intrType.getComponentType();
        }
        if (intrType instanceof ITypeVariableType) {
            intrType = ((ITypeVariableType)intrType).getBoundingType();
            while (i-- > 0) {
                intrType = intrType.getArrayType();
            }
        }
        return intrType;
    }

    private Object extractObjectArray(IType intrType, Object value) {
        if (intrType.isArray() && intrType instanceof IJavaArrayType && value instanceof IGosuArrayClassInstance) {
            value = ((IGosuArrayClassInstance)value).getObjectArray();
        }
        return value;
    }

    @Override
    public Object convertNullAsPrimitive(IType intrType, boolean isForBoxing) {
        if (intrType == null) {
            return null;
        }
        if (!intrType.isPrimitive()) {
            throw GosuShop.createEvaluationException(intrType.getName() + " is not a primitive type.");
        }
        if (intrType == JavaTypes.pBYTE()) {
            return (byte)0;
        }
        if (intrType == JavaTypes.pCHAR()) {
            return Character.valueOf('\u0000');
        }
        if (intrType == JavaTypes.pDOUBLE()) {
            return isForBoxing ? IGosuParser.NaN : 0.0;
        }
        if (intrType == JavaTypes.pFLOAT()) {
            return Float.valueOf(isForBoxing ? Float.NaN : 0.0f);
        }
        if (intrType == JavaTypes.pINT()) {
            return 0;
        }
        if (intrType == JavaTypes.pLONG()) {
            return 0L;
        }
        if (intrType == JavaTypes.pSHORT()) {
            return (short)0;
        }
        if (intrType == JavaTypes.pBOOLEAN()) {
            return Boolean.FALSE;
        }
        if (intrType == JavaTypes.pVOID()) {
            return null;
        }
        throw GosuShop.createEvaluationException("Unexpected primitive type: " + intrType.getName());
    }

    @Override
    public ICoercer resolveCoercerStatically(IType typeToCoerceTo, IType typeToCoerceFrom) {
        if (typeToCoerceTo == null || typeToCoerceFrom == null) {
            return null;
        }
        if (typeToCoerceTo == typeToCoerceFrom) {
            return null;
        }
        if (typeToCoerceTo.equals(typeToCoerceFrom)) {
            return null;
        }
        if (typeToCoerceTo instanceof IErrorType || typeToCoerceFrom instanceof IErrorType) {
            return null;
        }
        if (typeToCoerceTo instanceof ITypeVariableArrayType) {
            return RuntimeCoercer.instance();
        }
        if (typeToCoerceTo instanceof ITypeVariableType) {
            return TypeVariableCoercer.instance();
        }
        if (typeToCoerceTo.isAssignableFrom(typeToCoerceFrom) && (!typeToCoerceFrom.isGenericType() || typeToCoerceFrom.isParameterizedType())) {
            return null;
        }
        ICoercer coercerInternal = this.findCoercerImpl(typeToCoerceTo, typeToCoerceFrom, false);
        if (coercerInternal == null) {
            if (typeToCoerceFrom.isAssignableFrom(typeToCoerceTo) && !JavaTypes.pVOID().equals(typeToCoerceTo)) {
                if (this.areJavaClassesAndAreNotAssignable(typeToCoerceTo, typeToCoerceFrom)) {
                    return RuntimeCoercer.instance();
                }
                return this.identityOrRuntime(typeToCoerceTo, typeToCoerceFrom);
            }
            if ((typeToCoerceFrom.isInterface() || typeToCoerceTo.isInterface() || TypeSystem.canCast(typeToCoerceFrom, typeToCoerceTo)) && !typeToCoerceFrom.isPrimitive() && !typeToCoerceTo.isPrimitive()) {
                return this.identityOrRuntime(typeToCoerceTo, typeToCoerceFrom);
            }
            if (typeToCoerceTo.isPrimitive() && typeToCoerceFrom instanceof IPlaceholder && ((IPlaceholder)((Object)typeToCoerceFrom)).isPlaceholder()) {
                return IdentityCoercer.instance();
            }
        }
        return coercerInternal;
    }

    private boolean areJavaClassesAndAreNotAssignable(IType typeToCoerceTo, IType typeToCoerceFrom) {
        return typeToCoerceFrom instanceof IJavaType && typeToCoerceTo instanceof IJavaType && !((IJavaType)typeToCoerceFrom).getBackingClassInfo().isAssignableFrom(((IJavaType)typeToCoerceTo).getBackingClassInfo());
    }

    private ICoercer identityOrRuntime(IType typeToCoerceTo, IType typeToCoerceFrom) {
        if (TypeSystem.isBytecodeType(typeToCoerceFrom) && TypeSystem.isBytecodeType(typeToCoerceTo)) {
            return IdentityCoercer.instance();
        }
        if (typeToCoerceTo instanceof IGosuClass && ((IGosuClass)typeToCoerceTo).isStructure() && typeToCoerceFrom instanceof IMetaType) {
            return IdentityCoercer.instance();
        }
        return RuntimeCoercer.instance();
    }

    @Override
    public Double makeDoubleFrom(Object obj) {
        int i;
        if (obj == null) {
            return null;
        }
        if (obj instanceof IDimension) {
            obj = ((IDimension)obj).toNumber();
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (!(obj instanceof Number)) {
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? IGosuParser.ONE : IGosuParser.ZERO;
            }
            if (obj instanceof Date) {
                return ((Date)obj).getTime();
            }
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            if (CommonServices.getCoercionManager().canCoerce(JavaTypes.NUMBER(), TypeSystem.getFromObject(obj))) {
                Number num = (Number)CommonServices.getCoercionManager().convertValue(obj, JavaTypes.NUMBER());
                return num.doubleValue();
            }
            String strValue = obj.toString();
            return this.makeDoubleFrom(this.parseNumber(strValue));
        }
        double d = ((Number)obj).doubleValue();
        if (d >= 0.0 && d <= 9.0 && (double)(i = (int)d) == d && i >= 0 && i <= 9) {
            return IGosuParser.DOUBLE_DIGITS[i];
        }
        return d;
    }

    @Override
    public int makePrimitiveIntegerFrom(Object obj) {
        if (obj == null) {
            return 0;
        }
        return this.makeIntegerFrom(obj);
    }

    @Override
    public Integer makeIntegerFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IDimension) {
            obj = ((IDimension)obj).toNumber();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? IGosuParser.ONE.intValue() : IGosuParser.ZERO.intValue();
        }
        if (obj instanceof Date) {
            return (int)((Date)obj).getTime();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (CommonServices.getCoercionManager().canCoerce(JavaTypes.NUMBER(), TypeSystem.getFromObject(obj))) {
            Number num = (Number)CommonServices.getCoercionManager().convertValue(obj, JavaTypes.NUMBER());
            return num.intValue();
        }
        String strValue = obj.toString();
        return this.makeIntegerFrom(this.parseNumber(strValue));
    }

    @Override
    public long makePrimitiveLongFrom(Object obj) {
        if (obj == null) {
            return 0L;
        }
        return this.makeLongFrom(obj);
    }

    @Override
    public Long makeLongFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IDimension) {
            obj = ((IDimension)obj).toNumber();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? IGosuParser.ONE.longValue() : IGosuParser.ZERO.longValue();
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (CommonServices.getCoercionManager().canCoerce(JavaTypes.NUMBER(), TypeSystem.getFromObject(obj))) {
            Number num = (Number)CommonServices.getCoercionManager().convertValue(obj, JavaTypes.NUMBER());
            return num.longValue();
        }
        String strValue = obj.toString();
        return this.makeLongFrom(this.parseNumber(strValue));
    }

    @Override
    public BigDecimal makeBigDecimalFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IDimension) {
            obj = ((IDimension)obj).toNumber();
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof String) {
            try {
                return (BigDecimal)BIG_DECIMAL_FORMAT.parse(obj.toString());
            }
            catch (java.text.ParseException e) {
                throw GosuExceptionUtil.convertToRuntimeException(e);
            }
        }
        if (obj instanceof Integer) {
            return BigDecimal.valueOf(((Integer)obj).intValue());
        }
        if (obj instanceof BigInteger) {
            return new BigDecimal((BigInteger)obj);
        }
        if (obj instanceof Long) {
            return BigDecimal.valueOf((Long)obj);
        }
        if (obj instanceof Short) {
            return BigDecimal.valueOf(((Short)obj).shortValue());
        }
        if (obj instanceof Byte) {
            return BigDecimal.valueOf(((Byte)obj).byteValue());
        }
        if (obj instanceof Character) {
            return BigDecimal.valueOf(((Character)obj).charValue());
        }
        if (obj instanceof Float) {
            return new BigDecimal(obj.toString());
        }
        if (obj instanceof Number) {
            Double d = this.makeDoubleFrom(obj);
            return new BigDecimal(d.toString());
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (obj instanceof Date) {
            return new BigDecimal(((Date)obj).getTime());
        }
        if (CommonServices.getCoercionManager().canCoerce(JavaTypes.NUMBER(), TypeSystem.getFromObject(obj))) {
            Number num = (Number)CommonServices.getCoercionManager().convertValue(obj, JavaTypes.NUMBER());
            return this.makeBigDecimalFrom(num);
        }
        Double d = this.makeDoubleFrom(obj);
        return new BigDecimal(d.toString());
    }

    @Override
    public BigInteger makeBigIntegerFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigInteger) {
            return (BigInteger)obj;
        }
        if (obj instanceof IDimension) {
            obj = ((IDimension)obj).toNumber();
        }
        if (obj instanceof String) {
            String strValue = (String)obj;
            return this.makeBigIntegerFrom(this.parseNumber(strValue));
        }
        BigDecimal d = this.makeBigDecimalFrom(obj);
        return d.toBigInteger();
    }

    @Override
    public double makePrimitiveDoubleFrom(Object obj) {
        if (obj == null) {
            return Double.NaN;
        }
        return this.makeDoubleFrom(obj);
    }

    @Override
    public Float makeFloatFrom(Object obj) {
        if (obj == null) {
            return Float.valueOf(Float.NaN);
        }
        if (obj instanceof IDimension) {
            obj = ((IDimension)obj).toNumber();
        }
        if (obj instanceof Number) {
            return Float.valueOf(((Number)obj).floatValue());
        }
        if (obj instanceof Boolean) {
            return Float.valueOf((Boolean)obj != false ? 1.0f : 0.0f);
        }
        if (obj instanceof Date) {
            return Float.valueOf(((Date)obj).getTime());
        }
        if (obj instanceof Character) {
            return Float.valueOf(((Character)obj).charValue());
        }
        try {
            return Float.valueOf(Float.parseFloat(obj.toString()));
        }
        catch (Throwable t) {
            return Float.valueOf(Float.NaN);
        }
    }

    @Override
    public float makePrimitiveFloatFrom(Object obj) {
        if (obj == null) {
            return Float.NaN;
        }
        return this.makeFloatFrom(obj).floatValue();
    }

    @Override
    public String makeStringFrom(Object obj) {
        return obj == null ? null : obj.toString();
    }

    @Override
    public boolean makePrimitiveBooleanFrom(Object obj) {
        if (obj == null) {
            return false;
        }
        return Boolean.TRUE.equals(this.makeBooleanFrom(obj));
    }

    @Override
    public Boolean makeBooleanFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IDimension) {
            obj = ((IDimension)obj).toNumber();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() == 0.0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return Boolean.valueOf(obj.toString());
    }

    @Override
    public Date makeDateFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IDimension) {
            obj = ((IDimension)obj).toNumber();
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Number) {
            return new Date(((Number)obj).longValue());
        }
        if (obj instanceof Calendar) {
            return ((Calendar)obj).getTime();
        }
        if (!(obj instanceof String)) {
            obj = obj.toString();
        }
        try {
            return this.parseDateTime((String)obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isDateTime(String str) throws java.text.ParseException {
        return this.parseDateTime(str) != null;
    }

    @Override
    public Date parseDateTime(String str) throws java.text.ParseException {
        if (str == null) {
            return null;
        }
        return DateFormat.getDateInstance().parse(str);
    }

    @Override
    public String formatDate(Date value, String strFormat) {
        SimpleDateFormat df = new SimpleDateFormat(strFormat);
        return df.format(value);
    }

    @Override
    public String formatTime(Date value, String strFormat) {
        SimpleDateFormat df = new SimpleDateFormat(strFormat);
        return df.format(value);
    }

    @Override
    public String formatNumber(Double value, String strFormat) {
        DecimalFormat nf = new DecimalFormat(strFormat);
        return nf.format(value);
    }

    @Override
    public Number parseNumber(String strValue) {
        try {
            return Double.parseDouble(strValue);
        }
        catch (Exception e) {
            return IGosuParser.NaN;
        }
    }

    static {
        BIG_DECIMAL_FORMAT.setParseBigDecimal(true);
        NO_DICE = new Object();
    }

    private static class NullSentinalCoercer
    extends StandardCoercer {
        private static final NullSentinalCoercer INSTANCE = new NullSentinalCoercer();

        private NullSentinalCoercer() {
        }

        @Override
        public Object coerceValue(IType typeToCoerceTo, Object value) {
            throw new IllegalStateException("This is the null sentinal coercer, and is used only to represent a miss in the coercer cache.  It should never be returned for actual use");
        }

        public static NullSentinalCoercer instance() {
            return INSTANCE;
        }
    }

    class TypesComp {
        IType _lhs;
        IType _rhs;
        boolean _bBiDirectional;

        TypesComp(IType lhs, IType rhs, boolean bBiDirectional) {
            this._lhs = lhs;
            this._rhs = rhs;
            this._bBiDirectional = bBiDirectional;
        }

        public boolean equals(Object o) {
            TypesComp typesComp = (TypesComp)o;
            if (this._bBiDirectional != typesComp._bBiDirectional) {
                return false;
            }
            if (this._lhs != typesComp._lhs) {
                return false;
            }
            return this._rhs == typesComp._rhs;
        }

        public int hashCode() {
            int result = this._lhs.hashCode();
            result = 31 * result + this._rhs.hashCode();
            result = 31 * result + (this._bBiDirectional ? 1 : 0);
            return result;
        }
    }
}

