/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import com.github.benmanes.caffeine.cache.CacheLoader;
import gw.lang.reflect.AbstractTypeSystemListener;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.util.concurrent.Cache;

public class TypeSystemAwareCache<K, V>
extends Cache<K, V> {
    private final AbstractTypeSystemListener _cacheClearer = new CacheClearer(this);

    public static <K, V> TypeSystemAwareCache<K, V> make(String name, int size, CacheLoader<K, V> loader) {
        return new TypeSystemAwareCache<K, V>(name, size, loader);
    }

    public TypeSystemAwareCache(String name, int size, CacheLoader<K, V> loader) {
        super(name, size, loader);
        TypeSystem.addTypeLoaderListenerAsWeakRef(this._cacheClearer);
    }

    private static class CacheClearer
    extends AbstractTypeSystemListener {
        TypeSystemAwareCache _cache;

        private CacheClearer(TypeSystemAwareCache cache) {
            this._cache = cache;
        }

        @Override
        public void refreshed() {
            this._cache.clear();
        }

        @Override
        public void refreshedTypes(RefreshRequest request) {
            this._cache.clear();
        }
    }
}

