/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser.expressions;

import gw.internal.gosu.parser.IParameterizableType;
import gw.lang.parser.Keyword;
import gw.lang.parser.TypeSystemAwareCache;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IIntrinsicTypeReference;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Variance {
    COVARIANT(Keyword.KW_out.getName(), '+'),
    CONTRAVARIANT(Keyword.KW_in.getName(), '-'),
    INVARIANT(Keyword.KW_in.getName() + "/" + Keyword.KW_out.getName(), '='),
    DEFAULT("default", '*'),
    PENDING("pending", '?'),
    WILD_COVARIANT("wout", '>'),
    WILD_CONTRAVARIANT("win", '<');

    private static final boolean SUPPORT_DEFAULT_VARIANCE_CHECKING = true;
    private static final TypeSystemAwareCache<IType, Map<String, Variance>> DEFAULT_VARIANCE_MAP;
    private final String _desc;
    private final char _sign;

    private Variance(String desc, char sign) {
        this._desc = desc;
        this._sign = sign;
    }

    public String getDesc() {
        return this._desc;
    }

    public char getSymbol() {
        return this._sign;
    }

    public static void verifyTypeVarVariance(Variance variance, IType enclosingType, IVarianceVerifier verifier, IType type) {
        if (type instanceof IErrorType) {
            return;
        }
        if (variance == DEFAULT) {
            return;
        }
        if (type instanceof ITypeVariableType) {
            Variance typeVarVariance = Variance.getVariance((ITypeVariableType)type);
            if (typeVarVariance == WILD_COVARIANT) {
                typeVarVariance = COVARIANT;
            } else if (typeVarVariance == WILD_CONTRAVARIANT) {
                typeVarVariance = CONTRAVARIANT;
            }
            verifier.verify(variance, typeVarVariance);
        } else if (type.isArray()) {
            Variance.verifyTypeVarVariance(variance, enclosingType, verifier, type.getComponentType());
        } else if (type.isParameterizedType() && !(type instanceof IMetaType)) {
            IType[] typeParameters = type.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Variance ctxVariance;
                IType typeParam = typeParameters[i];
                IGenericTypeVariable[] gtvs = type.getGenericType().getGenericTypeVariables();
                if (i >= gtvs.length) continue;
                Variance tv = null;
                if (typeParam instanceof ITypeVariableType) {
                    tv = Variance.getVariance((ITypeVariableType)typeParam);
                }
                Variance targetTypeVarVariance = Variance.getVariance(gtvs[i].getTypeVariableDefinition().getType());
                if ((variance == COVARIANT || variance == CONTRAVARIANT) && targetTypeVarVariance == DEFAULT && typeParam instanceof ITypeVariableType && Variance.isTypeVarFromEnclosingType(enclosingType, (ITypeVariableType)typeParam) && type instanceof IParameterizableType && tv != DEFAULT) {
                    targetTypeVarVariance = Variance.maybeInferVariance(type, gtvs[i]);
                }
                Variance variance2 = variance == CONTRAVARIANT ? Variance.invertVariance(targetTypeVarVariance) : (ctxVariance = variance == COVARIANT ? targetTypeVarVariance : variance);
                if (variance == CONTRAVARIANT && (tv == WILD_COVARIANT || tv == WILD_CONTRAVARIANT)) {
                    ctxVariance = Variance.invertVariance(ctxVariance);
                }
                Variance.verifyTypeVarVariance(ctxVariance, enclosingType, verifier, typeParam);
            }
        } else if (type instanceof IFunctionType) {
            IFunctionType funcType = (IFunctionType)type;
            Variance invertedVariance = Variance.invertVariance(variance);
            for (IType paramType : funcType.getParameterTypes()) {
                Variance.verifyTypeVarVariance(invertedVariance, enclosingType, verifier, paramType);
            }
            Variance.verifyTypeVarVariance(variance, enclosingType, verifier, funcType.getReturnType());
        }
    }

    private static Variance getVariance(ITypeVariableType type) {
        Map map;
        IType typeVarOwner;
        Variance typeVarVariance = type.getTypeVarDef().getVariance();
        if (!(typeVarVariance != DEFAULT || (typeVarOwner = type.getEnclosingType()) instanceof IFunctionType || typeVarOwner instanceof IGosuClass && ((IGosuClass)typeVarOwner).isCompilingDefinitions() || (typeVarVariance = (Variance)((Object)(map = (Map)DEFAULT_VARIANCE_MAP.get(typeVarOwner)).get(type.getName()))) != null)) {
            typeVarVariance = DEFAULT;
        }
        return typeVarVariance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Variance maybeInferVariance(IType type, IGenericTypeVariable gtv) {
        Map map;
        Variance typeVarVariance = gtv.getTypeVariableDefinition().getVariance();
        if (typeVarVariance == DEFAULT && (typeVarVariance = (Variance)((Object)(map = (Map)DEFAULT_VARIANCE_MAP.get(type.getGenericType())).get(gtv.getName()))) == null) {
            Map map2 = map;
            synchronized (map2) {
                typeVarVariance = (Variance)((Object)map.get(gtv.getName()));
                if (typeVarVariance == null) {
                    Variance.inferVariance(type.getGenericType(), map);
                    typeVarVariance = (Variance)((Object)map.get(gtv.getName()));
                }
            }
        }
        return typeVarVariance;
    }

    private static boolean isTypeVarFromEnclosingType(IType enclosingType, ITypeVariableType typeVar) {
        for (IGenericTypeVariable gtv : enclosingType.getGenericTypeVariables()) {
            if ((!gtv.getTypeVariableDefinition().getType().equals(typeVar) || Variance.getVariance(typeVar) != COVARIANT && Variance.getVariance(typeVar) != CONTRAVARIANT) && Variance.getVariance(typeVar) != WILD_COVARIANT && Variance.getVariance(typeVar) != WILD_CONTRAVARIANT) continue;
            return true;
        }
        return false;
    }

    private static void inferVariance(IType genericType, Map<String, Variance> map) {
        HashMap<String, Variance> copy;
        do {
            copy = new HashMap<String, Variance>(map);
            IGenericTypeVariable[] gtvs = genericType.getGenericTypeVariables();
            for (int i = 0; i < gtvs.length; ++i) {
                for (int j = i + 1; j < gtvs.length; ++j) {
                    if (map.get(gtvs[j].getName()) != null) continue;
                    map.put(gtvs[j].getName(), PENDING);
                }
                map.put(gtvs[i].getName(), COVARIANT);
                boolean bValidOut = Variance.verifyDefaultForVariance(genericType);
                map.put(gtvs[i].getName(), CONTRAVARIANT);
                boolean bValidIn = Variance.verifyDefaultForVariance(genericType);
                map.put(gtvs[i].getName(), bValidOut ? (bValidIn ? DEFAULT : COVARIANT) : (bValidIn ? CONTRAVARIANT : INVARIANT));
            }
        } while (!copy.equals(map));
    }

    private static boolean verifyDefaultForVariance(IType type) {
        try {
            IType[] iTypeArray;
            List<? extends IMethodInfo> declaredMethods = ((IRelativeTypeInfo)type.getTypeInfo()).getDeclaredMethods();
            for (IMethodInfo iMethodInfo : declaredMethods) {
                if (iMethodInfo.isStatic()) continue;
                Variance.verifyDefaultTypeVarVariance(type, COVARIANT, iMethodInfo.getReturnType());
                Variance.verifyDefaultTypeVarVariance(type, CONTRAVARIANT, (IType[])Arrays.stream(iMethodInfo.getParameters()).map(IIntrinsicTypeReference::getFeatureType).toArray(IType[]::new));
            }
            List<? extends IPropertyInfo> declaredProperties = ((IRelativeTypeInfo)type.getTypeInfo()).getDeclaredProperties();
            for (IPropertyInfo iPropertyInfo : declaredProperties) {
                if (iPropertyInfo.isStatic()) continue;
                if (iPropertyInfo.isReadable()) {
                    Variance.verifyDefaultTypeVarVariance(type, COVARIANT, iPropertyInfo.getFeatureType());
                }
                if (!iPropertyInfo.isWritable(type)) continue;
                Variance.verifyDefaultTypeVarVariance(type, CONTRAVARIANT, iPropertyInfo.getFeatureType());
            }
            IType iType = type.getSupertype();
            if (iType != null) {
                Variance.verifyDefaultTypeVarVariance(type, COVARIANT, iType);
            }
            if ((iTypeArray = type.getInterfaces()) != null) {
                Variance.verifyDefaultTypeVarVariance(type, COVARIANT, iTypeArray);
            }
            return true;
        }
        catch (VarianceInvalidException varianceInvalidException) {
            return false;
        }
    }

    public static void verifyDefaultTypeVarVariance(IType enclosingType, Variance ctxVariance, IType ... types) {
        for (IType type : types) {
            Variance.verifyTypeVarVariance(ctxVariance, enclosingType, new DefaultVarianceVerifier(), type);
        }
    }

    private static Variance invertVariance(Variance variance) {
        return variance == COVARIANT ? CONTRAVARIANT : (variance == CONTRAVARIANT ? COVARIANT : variance);
    }

    static {
        DEFAULT_VARIANCE_MAP = new TypeSystemAwareCache("Default Variance Map", 10000, type -> new HashMap());
    }

    private static class DefaultVarianceVerifier
    implements IVarianceVerifier {
        private DefaultVarianceVerifier() {
        }

        @Override
        public void verify(Variance ctxV, Variance typeVarVariance) {
            if (typeVarVariance != ctxV && typeVarVariance != DEFAULT && typeVarVariance != INVARIANT && ctxV != PENDING && typeVarVariance != PENDING) {
                throw new VarianceInvalidException();
            }
        }
    }

    private static class VarianceInvalidException
    extends RuntimeException {
        private VarianceInvalidException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static interface IVarianceVerifier {
        public void verify(Variance var1, Variance var2);
    }
}

