/*
 * Decompiled with CFR 0.152.
 */
package gw.util.concurrent;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import gw.util.ILogger;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Cache<K, V> {
    private static final boolean ENABLE_STATS = System.getProperty("gosu.cache.stats", "").length() > 0;
    private final String _name;
    private final int _size;
    private final CacheLoader<K, V> _loader;
    private com.github.benmanes.caffeine.cache.Cache<K, V> _cacheImpl;
    private ScheduledFuture<?> _loggingTask;

    public Cache(String name, int size, CacheLoader<K, V> loader) {
        this._name = name;
        this._size = size;
        this._loader = loader;
        this.clearCacheImpl();
    }

    private void clearCacheImpl() {
        Caffeine builder = Caffeine.newBuilder().maximumSize((long)this._size);
        if (ENABLE_STATS) {
            builder.recordStats();
        }
        this._cacheImpl = builder.build();
    }

    public void evict(K key) {
        this._cacheImpl.invalidate(key);
    }

    public void put(K key, V value) {
        this._cacheImpl.put(key, value);
    }

    public V get(K key) {
        Object value = this._cacheImpl.getIfPresent(key);
        if (value == null) {
            try {
                value = this._loader.load(key);
                if (value != null) {
                    this._cacheImpl.put(key, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (V)value;
    }

    public CacheStats getStats() {
        return this._cacheImpl.stats();
    }

    public String getName() {
        return this._name;
    }

    public synchronized Cache<K, V> logEveryNSeconds(int seconds, ILogger logger) {
        if (this._loggingTask != null) {
            throw new IllegalStateException("Logging for " + this + " is already enabled");
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        this._loggingTask = service.scheduleAtFixedRate(() -> logger.info(this), seconds, seconds, TimeUnit.SECONDS);
        return this;
    }

    public synchronized void stopLogging() {
        if (this._loggingTask != null) {
            this._loggingTask.cancel(false);
        }
    }

    public void clear() {
        this.clearCacheImpl();
    }

    public String toString() {
        return this.getStats().toString();
    }

    public static <KK, VV> Cache<KK, VV> make(String name, int size, CacheLoader<KK, VV> loader) {
        return new Cache<KK, VV>(name, size, loader);
    }

    public static interface MissHandler<L, W>
    extends CacheLoader<L, W> {
    }
}

