/*
 * Decompiled with CFR 0.152.
 */
package gw.config;

import gw.config.IService;
import gw.config.ServiceKernelInit;
import gw.util.Stack;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public abstract class ServiceKernel {
    private Map<Class<? extends IService>, IService> _services;
    private Stack<IService> _initingServices = new Stack();
    private boolean _definingServices = false;

    protected ServiceKernel() {
        this.resetKernel();
    }

    protected void resetKernel() {
        this._services = new HashMap<Class<? extends IService>, IService>();
        this._definingServices = true;
        try {
            this.defineServices();
        }
        finally {
            this._definingServices = false;
        }
        this.redefineServices();
    }

    protected abstract void defineServices();

    protected abstract void redefineServices();

    public <T extends IService> T getService(Class<? extends T> service) {
        if (this._definingServices) {
            throw new IllegalStateException("Service definition in progress, access to " + service.getName() + " is not allowed.  Move this access to the init() method of the offending service.");
        }
        IService serviceImpl = this._services.get(service);
        if (serviceImpl == null) {
            throw new IllegalStateException("The service " + service.getName() + " is not provided by this ServiceKernel.");
        }
        return (T)serviceImpl;
    }

    public <T extends IService, Q extends T> void redefineService(Class<? extends T> service, Q newProvider) {
        if (this._definingServices) {
            throw new IllegalStateException("Service definition in progress, so service redefinition is not allowed.  Please move redefinitions to the redefineServices method.");
        }
        IService existingServiceImpl = this._services.get(service);
        if (existingServiceImpl == null) {
            throw new IllegalArgumentException("Service " + service.getName() + " is not defined in this ServiceKernel.");
        }
        if (existingServiceImpl.isInited()) {
            throw new IllegalStateException("Service " + service.getName() + " has already been initialized with the " + existingServiceImpl.getClass().getName() + " implementation");
        }
        this._services.put((Class<? extends IService>)service, (IService)newProvider);
    }

    public <T extends IService, Q extends T> void redefineService_Privileged(Class<? extends T> service, Q newProvider) {
        IService existingServiceImpl = this._services.get(service);
        if (existingServiceImpl == null) {
            throw new IllegalArgumentException("Service " + service.getName() + " is not defined in this ServiceKernel.");
        }
        this._services.put((Class<? extends IService>)service, (IService)newProvider);
    }

    protected <T extends IService> void defineService(Class<? extends T> serviceClass, Class<? extends T> implClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor<T> ctor = implClass.getDeclaredConstructor(new Class[0]);
        ctor.setAccessible(true);
        IService serviceImpl = (IService)ctor.newInstance(new Object[0]);
        this.defineService(serviceClass, serviceImpl);
    }

    protected <T extends IService, Q extends T> void defineService(Class<? extends T> service, Q defaultImplementation) {
        if (!this._definingServices) {
            throw new IllegalStateException("Service definition must be done only in the defineServices() method.");
        }
        if (!service.isInterface()) {
            throw new IllegalArgumentException("Services may only be defined as interfaces, and " + service.getName() + " is not an interface");
        }
        IService existingServiceImpl = this._services.get(service);
        if (existingServiceImpl != null) {
            throw new IllegalStateException("Service " + service.getName() + " has already been defined with the " + existingServiceImpl.getClass().getName() + " default implementation");
        }
        this._services.put((Class<? extends IService>)service, (IService)defaultImplementation);
    }

    protected void redefineServicesWithClass(String initClassName) {
        try {
            this.getClass();
            Class<?> aClass = Class.forName(initClassName);
            ServiceKernelInit init = (ServiceKernelInit)aClass.newInstance();
            init.init(this);
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(initClassName);
                ServiceKernelInit init = (ServiceKernelInit)aClass.newInstance();
                init.init(this);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private <T extends IService> void detectCircularInitializationDependencies(IService service) {
        if (this._initingServices.contains(service)) {
            StringBuilder sb = new StringBuilder("Circular service initialization dependency detected : ");
            for (IService initingService : this._initingServices) {
                sb.append("\n\t").append(initingService);
            }
            throw new IllegalStateException(sb.toString());
        }
    }
}

