/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.config.CommonServices;
import gw.config.IGlobalLoaderProvider;
import gw.config.IMemoryMonitor;
import gw.fs.IDirectory;
import gw.lang.GosuShop;
import gw.lang.gosuc.GosucArg;
import gw.lang.gosuc.GosucCompiler;
import gw.lang.gosuc.GosucDependency;
import gw.lang.gosuc.GosucGlobalLoaderProvider;
import gw.lang.gosuc.GosucModule;
import gw.lang.gosuc.GosucProject;
import gw.lang.gosuc.GosucProjectParser;
import gw.lang.gosuc.GosucSdk;
import gw.lang.gosuc.GosucUtil;
import gw.lang.gosuc.ICustomParser;
import gw.lang.gosuc.IGosuc;
import gw.lang.init.GosuInitialization;
import gw.lang.parser.IGosuParser;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.Dependency;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IJreModule;
import gw.lang.reflect.module.IModule;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Gosuc
implements IGosuc {
    private GosucProject _project;
    private IModule _globalModule;
    private List<GosucModule> _allGosucModules;

    public Gosuc(String projectFile, ICustomParser custParser) throws FileNotFoundException {
        File file = new File(projectFile);
        if (!file.isFile()) {
            System.err.println("The project file does not exist: " + file);
        }
        FileInputStream is = new FileInputStream(file);
        this._project = GosucProjectParser.parse(new BufferedInputStream(is), custParser);
        this._allGosucModules = this._project.getModules();
    }

    public Gosuc(ICustomParser custParser, String projectFileContent) throws FileNotFoundException {
        this._project = GosucProjectParser.parse(projectFileContent, custParser);
        this._allGosucModules = this._project.getModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeGosu() {
        CommonServices.getKernel().redefineService_Privileged(IGlobalLoaderProvider.class, new GosucGlobalLoaderProvider(this._project.getGlobalLoaders()));
        IMemoryMonitor memoryMonitor = this._project.getMemoryMonitor();
        if (memoryMonitor != null) {
            CommonServices.getKernel().redefineService_Privileged(IMemoryMonitor.class, memoryMonitor);
        }
        IExecutionEnvironment execEnv = TypeSystem.getExecutionEnvironment(this._project);
        List<IModule> modules = this.defineModules(this._project);
        modules.add(this._globalModule);
        GosuInitialization.instance(execEnv).initializeMultipleModules(modules);
        this.updateAllModuleClasspaths(this._project);
        IModule module = execEnv.getModule("_globalModule");
        TypeSystem.pushModule(module);
        try {
            Double o1 = IGosuParser.NaN;
            IJavaType iJavaType = JavaTypes.DOUBLE();
        }
        finally {
            TypeSystem.popModule(module);
        }
        this._project.startDependencies();
    }

    private List<IModule> defineModules(GosucProject project) {
        IModule module;
        IExecutionEnvironment execEnv = TypeSystem.getExecutionEnvironment(project);
        execEnv.createJreModule();
        this._globalModule = GosuShop.createGlobalModule(execEnv);
        this._globalModule.configurePaths(Collections.emptyList(), Collections.emptyList());
        this._globalModule.addDependency(new Dependency(execEnv.getJreModule(), true));
        ArrayList<IDirectory> allSourcePaths = new ArrayList<IDirectory>();
        HashMap<String, IModule> modules = new HashMap<String, IModule>();
        ArrayList<IModule> allModules = new ArrayList<IModule>();
        for (GosucModule gosucModule : this._allGosucModules) {
            module = this.defineModule(project, gosucModule);
            if (module == null) continue;
            allSourcePaths.addAll(module.getSourcePath());
            modules.put(gosucModule.getName(), module);
            allModules.add(module);
        }
        for (GosucModule gosucModule : this._allGosucModules) {
            module = (IModule)modules.get(gosucModule.getName());
            for (GosucDependency dep : gosucModule.getDependencies()) {
                IModule moduleDep = (IModule)modules.get(dep.getModuleName());
                if (moduleDep == null) continue;
                module.addDependency(new Dependency(moduleDep, this.isExported(gosucModule, dep.getModuleName())));
            }
        }
        this.addImplicitJreModuleDependency(project, allModules);
        allSourcePaths.addAll(execEnv.getJreModule().getSourcePath());
        List<IModule> rootModules = this.findRootModules(allModules);
        for (IModule rootModule : rootModules) {
            this._globalModule.addDependency(new Dependency(rootModule, true));
        }
        this._globalModule.setSourcePath(allSourcePaths);
        return allModules;
    }

    public List<IModule> findRootModules(List<IModule> modules) {
        ArrayList<IModule> moduleRoots = new ArrayList<IModule>(modules);
        for (IModule module : modules) {
            for (Dependency d : module.getDependencies()) {
                moduleRoots.remove(d.getModule());
            }
        }
        return moduleRoots;
    }

    public IModule defineModule(GosucProject project, GosucModule gosucModule) {
        IModule gosuModule = GosuShop.createModule(TypeSystem.getExecutionEnvironment(project), gosucModule.getName());
        List<IDirectory> sourceFolders = this.getSourceFolders(gosucModule);
        gosuModule.configurePaths(Gosuc.getClassPaths(gosucModule), sourceFolders);
        gosuModule.setNativeModule(gosucModule);
        gosuModule.setExcludedPaths(this.getExcludedFolders(gosucModule));
        return gosuModule;
    }

    private List<IDirectory> getSourceFolders(GosucModule gosucModule) {
        ArrayList<IDirectory> sourceFolders = new ArrayList<IDirectory>();
        for (String path : gosucModule.getAllSourceRoots()) {
            sourceFolders.add(GosucUtil.getDirectoryForPath(path));
        }
        return sourceFolders;
    }

    private List<IDirectory> getExcludedFolders(GosucModule gosucModule) {
        ArrayList<IDirectory> excludedFolders = new ArrayList<IDirectory>();
        for (String path : gosucModule.getExcludedRoots()) {
            excludedFolders.add(GosucUtil.getDirectoryForPath(path));
        }
        return excludedFolders;
    }

    public boolean isExported(GosucModule gosucModule, String childModuleName) {
        for (GosucDependency dep : gosucModule.getDependencies()) {
            if (dep.getModuleName().equals(childModuleName)) {
                return dep.isExported();
            }
            if (!this.isExported(this.findGosucModule(dep.getModuleName()), childModuleName)) continue;
            return true;
        }
        return false;
    }

    private GosucModule findGosucModule(String moduleName) {
        for (GosucModule mod : this._allGosucModules) {
            if (!mod.getName().equals(moduleName)) continue;
            return mod;
        }
        return null;
    }

    private void addImplicitJreModuleDependency(GosucProject project, List<IModule> modules) {
        IJreModule jreModule = (IJreModule)TypeSystem.getExecutionEnvironment(project).getJreModule();
        this.updateJreModuleWithProjectSdk(project, jreModule);
        for (IModule module : modules) {
            module.addDependency(new Dependency(jreModule, true));
        }
        modules.add(jreModule);
    }

    protected void updateJreModuleWithProjectSdk(GosucProject project, IJreModule jreModule) {
        GosucSdk projectSdk = project.getSdk();
        List<String> classFiles = projectSdk.getPaths();
        ArrayList<IDirectory> dirs = new ArrayList<IDirectory>();
        for (String path : classFiles) {
            dirs.add(GosucUtil.getDirectoryForPath(path));
        }
        jreModule.configurePaths(dirs, Collections.emptyList());
        jreModule.setNativeSDK(projectSdk);
    }

    void updateAllModuleClasspaths(GosucProject project) {
        List<? extends IModule> modules = TypeSystem.getExecutionEnvironment(project).getModules();
        ArrayList<GosucModule> gosucModules = new ArrayList<GosucModule>();
        for (IModule iModule : modules) {
            GosucModule gosucModule = (GosucModule)iModule.getNativeModule();
            if (gosucModule == null) continue;
            gosucModules.add(gosucModule);
        }
        Map<String, List<IDirectory>> classpathMap = this.createClassPathMap(gosucModules.toArray(new GosucModule[gosucModules.size()]));
        for (IModule iModule : modules) {
            if (iModule.getNativeModule() == null) continue;
            iModule.configurePaths(classpathMap.get(iModule.getName()), iModule.getSourcePath());
        }
    }

    private Map<String, List<IDirectory>> createClassPathMap(GosucModule[] allGosucModules) {
        HashMap<String, List<IDirectory>> classpathMap = new HashMap<String, List<IDirectory>>();
        for (GosucModule module : allGosucModules) {
            String name = module.getName();
            List<IDirectory> classPaths = Gosuc.getClassPaths(module);
            classpathMap.put(name, classPaths);
        }
        for (GosucModule module : allGosucModules) {
            List<IDirectory> referencedTotalClasspath = this.getReferencedTotalClasspath(module, classpathMap);
            if (referencedTotalClasspath == null) continue;
            List claspath = (List)classpathMap.get(module.getName());
            Iterator i = claspath.iterator();
            while (i.hasNext()) {
                IDirectory dir = (IDirectory)i.next();
                if (!referencedTotalClasspath.contains(dir)) continue;
                i.remove();
            }
        }
        return classpathMap;
    }

    private List<IDirectory> getReferencedTotalClasspath(GosucModule gosucModule, Map<String, List<IDirectory>> classpathMap) {
        ArrayList<IDirectory> totalClasspath = new ArrayList<IDirectory>();
        List<GosucModule> referencedModules = this.getAllRequiredModules(gosucModule);
        for (GosucModule m : referencedModules) {
            totalClasspath.addAll((Collection<IDirectory>)classpathMap.get(m.getName()));
        }
        return totalClasspath;
    }

    public List<GosucModule> getAllRequiredModules(GosucModule gosucModule) {
        HashSet<GosucModule> visitedProjects = new HashSet<GosucModule>();
        ArrayList<GosucModule> modules = new ArrayList<GosucModule>();
        this.getAllRequiredProjects(gosucModule, modules, visitedProjects);
        return modules;
    }

    private void getAllRequiredProjects(GosucModule gosucModule, List<GosucModule> gosucModuleList, Set<GosucModule> visitedModules) {
        visitedModules.add(gosucModule);
        for (GosucDependency dep : gosucModule.getDependencies()) {
            GosucModule depMod = this.findGosucModule(dep.getModuleName());
            if (visitedModules.contains(depMod)) continue;
            gosucModuleList.add(depMod);
            this.getAllRequiredProjects(depMod, gosucModuleList, visitedModules);
        }
    }

    private static List<IDirectory> getClassPaths(GosucModule gosucModule) {
        ArrayList<IDirectory> paths = new ArrayList<IDirectory>();
        for (String path : gosucModule.getClasspath()) {
            paths.add(GosucUtil.getDirectoryForPath(path));
        }
        return paths;
    }

    @Override
    public List<IType> compile(String moduleName, List<String> types) {
        IModule module = moduleName == null ? TypeSystem.getGlobalModule() : TypeSystem.getExecutionEnvironment().getModule(moduleName);
        return this.compile(module, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IType> compile(IModule module, List<String> types) {
        TypeSystem.pushModule(module);
        try {
            List<IType> list = new GosucCompiler().compile(this._project, types);
            return list;
        }
        finally {
            TypeSystem.popModule(module);
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        String error = GosucArg.parseArgs(args);
        if (error != null) {
            System.err.println(error);
            return;
        }
        String strFile = GosucArg.PROJECT.getValue();
        Gosuc gosuc = new Gosuc(strFile, Gosuc.maybeGetCustomParser());
        gosuc.initializeGosu();
        gosuc.compile((String)null, Collections.singletonList("-all"));
    }

    private static ICustomParser maybeGetCustomParser() {
        String cls = GosucArg.PARSER.getValue();
        if (cls != null) {
            try {
                Class.forName(cls).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

