/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.json;

import gw.lang.reflect.json.IJsonParentType;
import gw.lang.reflect.json.IJsonType;
import java.util.HashMap;
import java.util.Map;

class JsonListType
implements IJsonParentType {
    private IJsonType _componentType;
    private IJsonParentType _parent;
    private Map<String, IJsonParentType> _innerTypes;

    JsonListType(IJsonParentType parent) {
        this._parent = parent;
        this._innerTypes = new HashMap<String, IJsonParentType>();
    }

    @Override
    public String getName() {
        return "List<" + this._componentType.getName() + ">";
    }

    @Override
    public IJsonParentType getParent() {
        return this._parent;
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        this._innerTypes.put(name, type);
    }

    @Override
    public IJsonParentType findChild(String name) {
        return this._innerTypes.get(name);
    }

    public IJsonType getComponentType() {
        return this._componentType;
    }

    public void setComponentType(IJsonType compType) {
        if (this._componentType != null && this._componentType != compType) {
            throw new IllegalStateException("Component type already set to: " + this._componentType.getName() + ", which is not the same as: " + compType.getName());
        }
        this._componentType = compType;
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        for (IJsonParentType child : this._innerTypes.values()) {
            child.render(sb, indent, mutable);
        }
    }
}

