/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java.asm;

import gw.lang.reflect.java.asm.AsmType;
import java.util.HashMap;
import java.util.Map;

public class AsmPrimitiveType
extends AsmType {
    public static final AsmPrimitiveType BYTE;
    public static final AsmPrimitiveType SHORT;
    public static final AsmPrimitiveType CHAR;
    public static final AsmPrimitiveType INT;
    public static final AsmPrimitiveType LONG;
    public static final AsmPrimitiveType FLOAT;
    public static final AsmPrimitiveType DOUBLE;
    public static final AsmPrimitiveType BOOLEAN;
    public static final AsmPrimitiveType VOID;
    private static final Map<String, AsmPrimitiveType> PRIMITIVES;

    public static AsmPrimitiveType findPrimitive(String name) {
        return PRIMITIVES.get(name);
    }

    private AsmPrimitiveType(String name) {
        super(name);
    }

    @Override
    AsmType copy() {
        return this;
    }

    @Override
    AsmType copyNoArrayOrParameters() {
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public void incArrayDims() {
        throw new UnsupportedOperationException("Primitive types are immutable");
    }

    @Override
    public void addTypeParameter(AsmType type) {
        throw new UnsupportedOperationException("Primitive types are immutable");
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Primitive types are immutable");
    }

    @Override
    public void setTypeVariable() {
        throw new UnsupportedOperationException("Primitive types are immutable");
    }

    static {
        PRIMITIVES = new HashMap<String, AsmPrimitiveType>();
        BYTE = new AsmPrimitiveType("byte");
        PRIMITIVES.put("byte", BYTE);
        SHORT = new AsmPrimitiveType("short");
        PRIMITIVES.put("short", SHORT);
        CHAR = new AsmPrimitiveType("char");
        PRIMITIVES.put("char", CHAR);
        INT = new AsmPrimitiveType("int");
        PRIMITIVES.put("int", INT);
        LONG = new AsmPrimitiveType("long");
        PRIMITIVES.put("long", LONG);
        FLOAT = new AsmPrimitiveType("float");
        PRIMITIVES.put("float", FLOAT);
        DOUBLE = new AsmPrimitiveType("double");
        PRIMITIVES.put("double", DOUBLE);
        BOOLEAN = new AsmPrimitiveType("boolean");
        PRIMITIVES.put("boolean", BOOLEAN);
        VOID = new AsmPrimitiveType("void");
        PRIMITIVES.put("void", VOID);
        PRIMITIVES.put("B", BYTE);
        PRIMITIVES.put("S", SHORT);
        PRIMITIVES.put("C", CHAR);
        PRIMITIVES.put("I", INT);
        PRIMITIVES.put("J", LONG);
        PRIMITIVES.put("F", FLOAT);
        PRIMITIVES.put("D", DOUBLE);
        PRIMITIVES.put("Z", BOOLEAN);
        PRIMITIVES.put("V", VOID);
    }
}

