/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java.asm;

import gw.internal.ext.org.objectweb.asm.Type;
import gw.lang.reflect.java.asm.AsmAnnotation;
import gw.lang.reflect.java.asm.AsmClass;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.AsmUtil;
import gw.lang.reflect.java.asm.DeclarationPartSignatureVisitor;
import gw.lang.reflect.java.asm.IGeneric;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AsmMethod
implements IGeneric {
    private AsmType _methodType;
    private int _modifiers;
    private AsmType _returnType;
    private AsmType _genericReturnType;
    private List<AsmType> _parameters;
    private List<AsmType> _genericParameters;
    private List<AsmType> _exceptions;
    private List<AsmType> _genericExceptions;
    private List<AsmAnnotation> _annotations;
    private List<AsmAnnotation>[] _paramAnnotations;
    private AsmClass _owner;
    private boolean _bGeneric;
    private Object _defaultAnnoValue;
    private int _iLine;

    public AsmMethod(AsmClass owner, int access, String name, String desc, String[] exceptions) {
        this._owner = owner;
        this._modifiers = access;
        this._methodType = new AsmType(name);
        this._annotations = Collections.emptyList();
        this._exceptions = Collections.emptyList();
        this._parameters = Collections.emptyList();
        this._genericExceptions = Collections.emptyList();
        this._genericParameters = Collections.emptyList();
        this._iLine = -1;
        this.assignTypeFromDesc(desc);
        this._paramAnnotations = new List[this._parameters.size()];
        this.assignExceptions(exceptions);
    }

    public void update(List<DeclarationPartSignatureVisitor> paramTypes, DeclarationPartSignatureVisitor returnType, List<DeclarationPartSignatureVisitor> exceptionTypes) {
        for (DeclarationPartSignatureVisitor v : paramTypes) {
            if (this._genericParameters.isEmpty()) {
                this._genericParameters = new ArrayList<AsmType>();
            }
            this._genericParameters.add(v.getCurrentType());
        }
        this._genericReturnType = returnType.getCurrentType();
        for (DeclarationPartSignatureVisitor v : exceptionTypes) {
            if (this._genericExceptions.isEmpty()) {
                this._genericExceptions = new ArrayList<AsmType>();
            }
            this._genericExceptions.add(v.getCurrentType());
        }
    }

    public String getName() {
        return this._methodType.getName();
    }

    public AsmType getMethodType() {
        return this._methodType;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public List<AsmType> getParameters() {
        return this._parameters;
    }

    public List<AsmType> getGenericParameters() {
        return this._genericParameters.isEmpty() ? this._parameters : this._genericParameters;
    }

    public AsmType getReturnType() {
        return this._returnType;
    }

    void setReturnType(AsmType returnType) {
        this._returnType = returnType;
    }

    public AsmType getGenericReturnType() {
        return this._genericReturnType == null ? this._returnType : this._genericReturnType;
    }

    void initGenericReturnType() {
        this._genericReturnType = this._returnType.copyNoArrayOrParameters();
    }

    public AsmClass getDeclaringClass() {
        return this._owner;
    }

    @Override
    public boolean isGeneric() {
        return this._bGeneric;
    }

    @Override
    public void setGeneric() {
        this._bGeneric = true;
    }

    public boolean isSynthetic() {
        return (this._modifiers & 0x1000) != 0;
    }

    public boolean isBridge() {
        return (this._modifiers & 0x40) != 0;
    }

    public boolean isConstructor() {
        return this.getName().equals("<init>");
    }

    public List<AsmType> getExceptions() {
        return this._exceptions;
    }

    public List<AsmType> getGenericExceptions() {
        return this._genericExceptions.isEmpty() ? this._exceptions : this._genericExceptions;
    }

    void initGenericExceptions() {
        this._genericExceptions = new ArrayList<AsmType>(this._exceptions.size());
        for (AsmType exception : this._exceptions) {
            this._genericExceptions.add(exception.copyNoArrayOrParameters());
        }
    }

    public List<AsmAnnotation> getAnnotations() {
        return this._annotations;
    }

    public List<AsmAnnotation>[] getParameterAnnotations() {
        return this._paramAnnotations;
    }

    public Object getAnnotationDefaultValue() {
        return this._defaultAnnoValue;
    }

    public void setAnnotationDefaultValue(Object value) {
        this._defaultAnnoValue = value = AsmAnnotation.makeAppropriateValue(value);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public AsmAnnotation getAnnotation(Class annotationClass) {
        for (AsmAnnotation anno : this.getAnnotations()) {
            if (!annotationClass.getName().equals(anno.getType().getName())) continue;
            return anno;
        }
        return null;
    }

    private void assignExceptions(String[] exceptions) {
        if (exceptions == null) {
            return;
        }
        for (String exception : exceptions) {
            if (this._exceptions.isEmpty()) {
                this._exceptions = new ArrayList<AsmType>(exceptions.length);
            }
            this._exceptions.add(AsmUtil.makeType(exception));
        }
    }

    private void assignTypeFromDesc(String desc) {
        Type[] params;
        Type returnType = Type.getReturnType((String)desc);
        this._returnType = AsmUtil.makeType(returnType);
        for (Type param : params = Type.getArgumentTypes((String)desc)) {
            if (this._parameters.isEmpty()) {
                this._parameters = new ArrayList<AsmType>(params.length);
            }
            this._parameters.add(AsmUtil.makeType(param));
        }
    }

    public void addAnnotation(AsmAnnotation asmAnnotation) {
        if (this._annotations.isEmpty()) {
            this._annotations = new ArrayList<AsmAnnotation>(2);
        }
        this._annotations.add(asmAnnotation);
    }

    public void addParameterAnnotation(int iParam, AsmAnnotation asmAnnotation) {
        if (this._paramAnnotations[iParam] == null) {
            this._paramAnnotations[iParam] = new ArrayList<AsmAnnotation>(2);
        }
        this._paramAnnotations[iParam].add(asmAnnotation);
    }

    public String toString() {
        int mod = this.getModifiers();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + this.makeTypeVarsString() + (this.getGenericReturnType() == null ? this.getReturnType().getFqn() : this.getGenericReturnType().getFqn()) + " " + this.getName() + this.makeParameterString();
    }

    private String makeParameterString() {
        String paramString = "(";
        for (AsmType param : this._genericParameters.isEmpty() ? this._parameters : this._genericParameters) {
            if (paramString.length() > 1) {
                paramString = paramString + ", ";
            }
            paramString = paramString + param.getFqn();
        }
        paramString = paramString + ")";
        return paramString;
    }

    private String makeTypeVarsString() {
        String tvString = "";
        if (this.isGeneric()) {
            tvString = "<";
            for (AsmType tv : this.getMethodType().getTypeParameters()) {
                if (tvString.length() > 1) {
                    tvString = tvString + ", ";
                }
                tvString = tvString + tv.getFqn();
            }
            tvString = tvString + ">";
        }
        return tvString;
    }

    void assignLineNumber(int iLine) {
        if (this._iLine < 0) {
            this._iLine = iLine;
        }
    }

    public int getLineNumber() {
        return this._iLine;
    }

    public AsmType findTypeVariable(String tv) {
        for (AsmType p : this._methodType.getTypeParameters()) {
            if (!p.getName().equals(tv)) continue;
            return p;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsmMethod asmMethod = (AsmMethod)o;
        if (this._bGeneric != asmMethod._bGeneric) {
            return false;
        }
        if (this._modifiers != asmMethod._modifiers) {
            return false;
        }
        if (!this._annotations.equals(asmMethod._annotations)) {
            return false;
        }
        if (this._defaultAnnoValue != null ? !this._defaultAnnoValue.equals(asmMethod._defaultAnnoValue) : asmMethod._defaultAnnoValue != null) {
            return false;
        }
        if (!this._exceptions.equals(asmMethod._exceptions)) {
            return false;
        }
        if (!this._genericExceptions.equals(asmMethod._genericExceptions)) {
            return false;
        }
        if (!this._genericParameters.equals(asmMethod._genericParameters)) {
            return false;
        }
        if (!this._genericReturnType.equals(asmMethod._genericReturnType)) {
            return false;
        }
        if (!this._methodType.equals(asmMethod._methodType)) {
            return false;
        }
        if (!this._owner.equals(asmMethod._owner)) {
            return false;
        }
        if (!Arrays.equals(this._paramAnnotations, asmMethod._paramAnnotations)) {
            return false;
        }
        if (!this._parameters.equals(asmMethod._parameters)) {
            return false;
        }
        return this._returnType.equals(asmMethod._returnType);
    }

    public int hashCode() {
        int result = this._methodType.hashCode();
        result = 31 * result + this._modifiers;
        result = 31 * result + this._returnType.hashCode();
        result = 31 * result + this._genericReturnType.hashCode();
        result = 31 * result + this._parameters.hashCode();
        result = 31 * result + this._genericParameters.hashCode();
        result = 31 * result + this._exceptions.hashCode();
        result = 31 * result + this._genericExceptions.hashCode();
        result = 31 * result + this._annotations.hashCode();
        result = 31 * result + Arrays.hashCode(this._paramAnnotations);
        result = 31 * result + this._owner.hashCode();
        result = 31 * result + (this._bGeneric ? 1 : 0);
        result = 31 * result + (this._defaultAnnoValue != null ? this._defaultAnnoValue.hashCode() : 0);
        return result;
    }
}

