/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.util.Predicate;
import java.util.Collection;
import java.util.HashSet;

public class PredicatedSet<E>
extends HashSet<E> {
    private final Predicate _predicate;

    public PredicatedSet(int initialCapacity, Predicate predicate) {
        super(initialCapacity);
        this._predicate = predicate;
    }

    public PredicatedSet(Predicate predicate) {
        this._predicate = predicate;
    }

    @Override
    public boolean add(E o) {
        if (this._predicate.evaluate(o)) {
            return super.add(o);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            if (!this._predicate.evaluate(e) || !super.add(e)) continue;
            changed = true;
        }
        return changed;
    }
}

