/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.statement;

import gw.internal.ext.org.objectweb.asm.signature.SignatureVisitor;
import gw.internal.ext.org.objectweb.asm.signature.SignatureWriter;
import gw.lang.UnstableAPI;
import gw.lang.ir.IRAnnotation;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRType;
import gw.lang.ir.SignatureUtil;
import gw.lang.ir.statement.IRTerminalStatement;
import gw.lang.reflect.IType;
import java.util.Collections;
import java.util.List;

@UnstableAPI
public class IRFieldDecl
extends IRStatement {
    private int _modifiers;
    private String _name;
    private IRType _type;
    private Object _value;
    private boolean _explicitInternal;
    private List<IRAnnotation> _annotations = Collections.emptyList();
    private String _genericSignature;

    public IRFieldDecl(int modifiers, boolean explicitInternal, String name, IRType type, IType iType, Object value) {
        this._modifiers = modifiers;
        this._explicitInternal = explicitInternal;
        this._name = name;
        this._type = IRFieldDecl.maybeEraseStructuralType(type);
        this._value = value;
        this._genericSignature = this.makeGenericSignature(iType);
    }

    public IRFieldDecl(int modifiers, boolean explicitInternal, String name, IRType type, Object value) {
        this(modifiers, explicitInternal, name, type, null, value);
    }

    private String makeGenericSignature(IType type) {
        if (type == null) {
            return null;
        }
        boolean[] bGeneric = new boolean[]{false};
        SignatureWriter sw = new SignatureWriter();
        SignatureUtil.visitType((SignatureVisitor)sw, type, bGeneric);
        if (bGeneric[0]) {
            return sw.toString();
        }
        return null;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public String getName() {
        return this._name;
    }

    public IRType getType() {
        return this._type;
    }

    public Object getValue() {
        return this._value;
    }

    @Override
    public IRTerminalStatement getLeastSignificantTerminalStatement() {
        return null;
    }

    public void setAnnotations(List<IRAnnotation> irAnnotations) {
        this._annotations = irAnnotations;
    }

    public List<IRAnnotation> getAnnotations() {
        return this._annotations;
    }

    public String getGenericSignature() {
        return this._genericSignature;
    }

    public boolean isExplicitInternal() {
        return this._explicitInternal;
    }
}

