/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import gw.lang.parser.IParsedElement;
import gw.lang.parser.expressions.IProgram;
import gw.lang.parser.statements.IClassFileStatement;

public class PostCompilationAnalysis {
    private static final ThreadLocal<Boolean> isAnalysisThread = new ThreadLocal();

    public static boolean shouldAnalyze() {
        Boolean isAnalysisThread = PostCompilationAnalysis.isAnalysisThread.get();
        return isAnalysisThread != null && isAnalysisThread != false;
    }

    public static void setAnalysisThread() {
        isAnalysisThread.set(true);
    }

    public static void unsetAnalysisThread() {
        isAnalysisThread.set(false);
    }

    public static void maybeAnalyze(IParsedElement pe, IParsedElement ... other) {
        if (!PostCompilationAnalysis.shouldAnalyze()) {
            return;
        }
        if (pe instanceof IProgram || !(pe instanceof IClassFileStatement) || PostCompilationAnalysis.classFileIsNotAnInterface((IClassFileStatement)pe)) {
            // empty if block
        }
    }

    private static boolean classFileIsNotAnInterface(IClassFileStatement parsedElementToAnalyze) {
        return parsedElementToAnalyze.getClassStatement() != null && !parsedElementToAnalyze.getClassStatement().getGosuClass().isInterface();
    }
}

