/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TypeVarToTypeMap {
    public static final TypeVarToTypeMap EMPTY_MAP = new TypeVarToTypeMap(Collections.emptyMap());
    private Map<ITypeVariableType, IType> _map;
    private Set<ITypeVariableType> _typesInferredFromCovariance;
    private boolean _bStructural;

    public TypeVarToTypeMap() {
        this._map = new LinkedHashMap<ITypeVariableType, IType>(2);
        this._typesInferredFromCovariance = new HashSet<ITypeVariableType>(2);
    }

    private TypeVarToTypeMap(Map<ITypeVariableType, IType> emptyMap) {
        this._map = emptyMap;
        this._typesInferredFromCovariance = new HashSet<ITypeVariableType>(2);
    }

    public TypeVarToTypeMap(TypeVarToTypeMap from) {
        this();
        this._map.putAll(from._map);
        this._typesInferredFromCovariance = new HashSet<ITypeVariableType>(2);
        this._typesInferredFromCovariance.addAll(from._typesInferredFromCovariance);
        this._bStructural = from._bStructural;
    }

    public IType get(ITypeVariableType tvType) {
        return this._map.get(tvType);
    }

    public <E> IType getByMatcher(E tv, ITypeVarMatcher<E> matcher) {
        for (ITypeVariableType key : this._map.keySet()) {
            if (!matcher.matches(tv, key)) continue;
            return this._map.get(key);
        }
        return null;
    }

    public IType getByString(String tv) {
        for (ITypeVariableType key : this._map.keySet()) {
            if (!tv.equals(key.getRelativeName()) && !tv.equals(key.getName())) continue;
            return key;
        }
        return null;
    }

    public boolean containsKey(ITypeVariableType tvType) {
        return this._map.containsKey(tvType);
    }

    public IType put(ITypeVariableType tvType, IType type) {
        IType existing = this.remove(tvType);
        this._map.put(tvType, type);
        return existing;
    }

    public void putAll(TypeVarToTypeMap from) {
        for (ITypeVariableType x : from._map.keySet()) {
            this.put(x, from.get(x));
        }
    }

    public void putAllAndInferred(TypeVarToTypeMap from) {
        for (ITypeVariableType x : from._map.keySet()) {
            this.put(x, from.get(x));
        }
        this._typesInferredFromCovariance.addAll(from._typesInferredFromCovariance);
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public int size() {
        return this._map.size();
    }

    public Set<ITypeVariableType> keySet() {
        return this._map.keySet();
    }

    public Set<Map.Entry<ITypeVariableType, IType>> entrySet() {
        return this._map.entrySet();
    }

    public IType remove(ITypeVariableType tvType) {
        return this._map.remove(tvType);
    }

    public Collection<IType> values() {
        return this._map.values();
    }

    public boolean isStructural() {
        return this._bStructural;
    }

    public void setStructural(boolean bStructural) {
        this._bStructural = bStructural;
    }

    public boolean isInferredForCovariance(ITypeVariableType tv) {
        return !this.isStructural() || this._typesInferredFromCovariance.contains(tv);
    }

    public void setInferredForCovariance(ITypeVariableType tv) {
        this._typesInferredFromCovariance.add(tv);
    }

    public static interface ITypeVarMatcher<E> {
        public boolean matches(E var1, ITypeVariableType var2);
    }
}

