/*
 * Decompiled with CFR 0.152.
 */
package gw.xml.simple;

import gw.util.Stack;
import gw.xml.simple.SimpleXmlNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class SimpleXmlNodeHandler
extends DefaultHandler {
    private Stack<SimpleXmlNode> _elementStack = new Stack();
    private Stack<StringBuilder> _textStack = new Stack();
    private SimpleXmlNode _root = null;
    private StringBuilder _currentText;

    public SimpleXmlNode getRoot() {
        return this._root;
    }

    @Override
    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        SimpleXmlNode element = new SimpleXmlNode(this.removePrefix(qualifiedName));
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeLocalName = this.removePrefix(attributes.getQName(i));
            if (element.getAttributes().containsKey(attributeLocalName)) {
                throw new IllegalStateException("Duplicate attributes were found with identical local names of " + attributeLocalName);
            }
            element.getAttributes().put(attributeLocalName, attributes.getValue(i));
        }
        if (!this._elementStack.isEmpty()) {
            SimpleXmlNode parent = this._elementStack.peek();
            parent.getChildren().add(element);
        } else {
            this._root = element;
        }
        this._elementStack.push(element);
        this._textStack.push(this._currentText);
        this._currentText = null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this._elementStack.isEmpty()) {
            SimpleXmlNode ended = this._elementStack.pop();
            if (this._currentText != null && !this.isBlank(this._currentText)) {
                ended.setText(this._currentText.toString());
            } else {
                ended.setText(null);
            }
            this._currentText = this._textStack.pop();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._currentText == null) {
            this._currentText = new StringBuilder();
            this._currentText.append(ch, start, length);
            if (this.isBlank(this._currentText)) {
                this._currentText = null;
            }
        } else {
            this._currentText.append(ch, start, length);
        }
    }

    private boolean isBlank(StringBuilder sb) {
        for (int i = 0; i < sb.length(); ++i) {
            if (Character.isWhitespace(sb.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
    }

    private String removePrefix(String localName) {
        int lastIndex = localName.lastIndexOf(58);
        if (lastIndex != -1) {
            return localName.substring(lastIndex + 1);
        }
        return localName;
    }
}

