/*
 * Decompiled with CFR 0.152.
 */
package gw.fs.physical;

import gw.fs.IDirectory;
import gw.fs.IResource;
import gw.fs.ResourcePath;
import gw.fs.physical.IFileMetadata;
import gw.fs.physical.IPhysicalFileSystem;
import gw.fs.physical.PhysicalDirectoryImpl;
import gw.lang.UnstableAPI;
import java.io.File;
import java.io.IOException;
import java.net.URI;

@UnstableAPI
public class PhysicalResourceImpl
implements IResource {
    protected final ResourcePath _path;
    protected final IPhysicalFileSystem _backingFileSystem;

    protected PhysicalResourceImpl(ResourcePath path, IPhysicalFileSystem backingFileSystem) {
        this._path = path;
        this._backingFileSystem = backingFileSystem;
    }

    @Override
    public IDirectory getParent() {
        if (this._path.getParent() == null) {
            return null;
        }
        return new PhysicalDirectoryImpl(this._path.getParent(), this._backingFileSystem);
    }

    @Override
    public String getName() {
        return this._path.getName();
    }

    @Override
    public boolean exists() {
        return this.getIFileMetadata().exists();
    }

    @Override
    public boolean delete() throws IOException {
        return this._backingFileSystem.delete(this._path);
    }

    @Override
    public URI toURI() {
        return this.toJavaFile().toURI();
    }

    @Override
    public ResourcePath getPath() {
        return this._path;
    }

    @Override
    public boolean isChildOf(IDirectory dir) {
        return dir.getPath().isChild(this._path);
    }

    @Override
    public boolean isDescendantOf(IDirectory dir) {
        return dir.getPath().isDescendant(this._path);
    }

    @Override
    public File toJavaFile() {
        return new File(this._path.getPathString());
    }

    @Override
    public boolean isJavaFile() {
        return true;
    }

    @Override
    public boolean isInJar() {
        return false;
    }

    @Override
    public boolean create() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IResource) {
            return this._path.equals(((IResource)obj).getPath());
        }
        return false;
    }

    public String toString() {
        return this.getPath().getFileSystemPathString();
    }

    protected IFileMetadata getIFileMetadata() {
        return this._backingFileSystem.getFileMetadata(this._path);
    }
}

