/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.json;

import gw.lang.reflect.ActualName;
import gw.lang.reflect.json.IJsonParentType;
import gw.lang.reflect.json.IJsonType;
import gw.lang.reflect.json.ReservedWordMapping;
import java.util.HashMap;
import java.util.Map;

class JsonStructureType
implements IJsonParentType {
    private IJsonParentType _parent;
    private String _name;
    private Map<String, IJsonType> _members;
    private Map<String, IJsonParentType> _innerTypes;

    JsonStructureType(IJsonParentType parent, String name) {
        this._parent = parent;
        this._name = name;
        this._members = new HashMap<String, IJsonType>();
        this._innerTypes = new HashMap<String, IJsonParentType>();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public IJsonParentType getParent() {
        return this._parent;
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        this._innerTypes.put(name, type);
    }

    @Override
    public IJsonParentType findChild(String name) {
        return this._innerTypes.get(name);
    }

    public void addMember(String name, IJsonType type) {
        IJsonType existingType = this._members.get(name);
        if (existingType != null && existingType != type) {
            throw new RuntimeException("Types disagree for '" + name + "' from array data: " + type.getName() + " vs: " + existingType.getName());
        }
        this._members.put(name, type);
    }

    public IJsonType findMemberType(String name) {
        return this._members.get(name);
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        this.indent(sb, indent);
        String name = this.getName();
        String identifier = this.addActualNameAnnotation(sb, indent, name);
        sb.append("structure ").append(identifier).append(" {\n");
        this.renderTopLevelFactoryMethods(sb, indent + 2);
        for (String key : this._members.keySet()) {
            identifier = this.addActualNameAnnotation(sb, indent + 2, key);
            this.indent(sb, indent + 2);
            sb.append("property get ").append(identifier).append("(): ").append(this._members.get(key).getName()).append("\n");
            if (!mutable) continue;
            this.indent(sb, indent + 2);
            sb.append("property set ").append(identifier).append("( ").append("$value: ").append(this._members.get(key).getName()).append(" )\n");
        }
        for (IJsonParentType child : this._innerTypes.values()) {
            child.render(sb, indent + 2, mutable);
        }
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private String addActualNameAnnotation(StringBuilder sb, int indent, String name) {
        String identifier = this.makeIdentifier(name);
        if (!identifier.equals(name)) {
            this.indent(sb, indent);
            sb.append("@").append(ActualName.class.getName()).append("( \"").append(name).append("\" )\n");
        }
        return identifier;
    }

    private String makeIdentifier(String name) {
        String identifier = ReservedWordMapping.getIdentifierForName(name);
        if (!identifier.equals(name)) {
            return identifier;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_' || c == '$' || (i == 0 ? Character.isLetter(c) : Character.isLetterOrDigit(c))) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private void renderTopLevelFactoryMethods(StringBuilder sb, int indent) {
        if (this._parent != null) {
            return;
        }
        this.indent(sb, indent);
        sb.append("static function fromJson( jsonText: String ): ").append(this.getName()).append(" {\n");
        this.indent(sb, indent);
        sb.append("  return gw.lang.reflect.json.Json.fromJson( jsonText ) as ").append(this.getName()).append("\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static function fromJsonUrl( url: String ): ").append(this.getName()).append(" {\n");
        this.indent(sb, indent);
        sb.append("  return new java.net.URL( url ).JsonContent\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static function fromJsonUrl( url: java.net.URL ): ").append(this.getName()).append(" {\n");
        this.indent(sb, indent);
        sb.append("  return url.JsonContent\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static function fromJsonFile( file: java.io.File ) : ").append(this.getName()).append(" {\n");
        this.indent(sb, indent);
        sb.append("  return fromJsonUrl( file.toURI().toURL() )\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }
}

