/*
 * Decompiled with CFR 0.152.
 */
package gw.date;

public enum DayOfWeek {
    SUNDAY,
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY;

    private static final DayOfWeek[] _valueLookup;

    public static DayOfWeek fromCalendarDayOfWeek(int calendarDayOfWeek) {
        int index = calendarDayOfWeek - 1;
        if (index < 0 || index >= _valueLookup.length) {
            throw new IllegalArgumentException(calendarDayOfWeek + " is not a valid Calendar day of the week");
        }
        return _valueLookup[index];
    }

    public int toCalendarDayOfWeek() {
        return this.ordinal() + 1;
    }

    static {
        _valueLookup = DayOfWeek.values();
    }
}

