/*
 * Decompiled with CFR 0.152.
 */
package gw.fs.physical;

import gw.fs.ResourcePath;
import gw.fs.physical.AbstractCachingPhysicalFileSystem;
import gw.fs.physical.IFileMetadata;
import gw.fs.physical.IPhysicalFileSystem;
import gw.lang.UnstableAPI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@UnstableAPI
public class FuzzyTimestampCachingPhysicalFileSystem
extends AbstractCachingPhysicalFileSystem {
    private Map<String, DirCacheInfo> _dirCache = new HashMap<String, DirCacheInfo>();
    private Lock _lock = new ReentrantLock();

    public FuzzyTimestampCachingPhysicalFileSystem(IPhysicalFileSystem delegate) {
        super(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends IFileMetadata> listFiles(ResourcePath directoryPath) {
        this._lock.lock();
        try {
            String pathString = directoryPath.getPathString();
            DirCacheInfo cacheInfo = this._dirCache.get(pathString);
            if (cacheInfo == null) {
                cacheInfo = new DirCacheInfo(directoryPath);
                this._dirCache.put(pathString, cacheInfo);
            }
            List<? extends IFileMetadata> list = cacheInfo.listFiles();
            return list;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public IFileMetadata getFileMetadata(ResourcePath filePath) {
        return this._delegate.getFileMetadata(filePath);
    }

    @Override
    public void clearDirectoryCaches(ResourcePath dirPath) {
        this._lock.lock();
        try {
            this._dirCache.remove(dirPath.getPathString());
        }
        finally {
            this._lock.unlock();
        }
        this._delegate.clearDirectoryCaches(dirPath);
    }

    @Override
    public void clearAllCaches() {
        this._lock.lock();
        try {
            this._dirCache.clear();
        }
        finally {
            this._lock.unlock();
        }
        this._delegate.clearAllCaches();
    }

    private class DirCacheInfo {
        private List<? extends IFileMetadata> _files;
        private ResourcePath _absolutePath;
        private long _lastFileTimestamp;
        private long _lastRefreshTimestamp;

        private DirCacheInfo(ResourcePath absolutePath) {
            this._absolutePath = absolutePath;
            this._lastFileTimestamp = -1L;
        }

        public List<? extends IFileMetadata> listFiles() {
            this.maybeRefreshList();
            return this._files;
        }

        private void maybeRefreshList() {
            if (this._lastFileTimestamp == -1L) {
                this.doRefreshImpl();
            } else {
                long currentTimestamp = FuzzyTimestampCachingPhysicalFileSystem.this._delegate.getFileMetadata(this._absolutePath).lastModifiedTime();
                if (currentTimestamp == 0L) {
                    this._files = Collections.emptyList();
                } else if (this._lastFileTimestamp != currentTimestamp) {
                    this.doRefreshImpl();
                } else {
                    long refreshDelta = this._lastRefreshTimestamp - currentTimestamp;
                    if (refreshDelta > -16L && refreshDelta < 16L) {
                        this.doRefreshImpl();
                    }
                }
            }
        }

        private void doRefreshImpl() {
            this._lastRefreshTimestamp = System.currentTimeMillis();
            this._files = FuzzyTimestampCachingPhysicalFileSystem.this._delegate.listFiles(this._absolutePath);
        }
    }
}

