/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.reflect.AbstractType;
import gw.lang.reflect.DefaultArrayType;
import gw.lang.reflect.IDefaultTypeLoader;
import gw.lang.reflect.IType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.Array;
import gw.util.concurrent.LockingLazyVar;
import java.io.ObjectStreamException;
import java.util.HashSet;
import java.util.Set;

public abstract class TypeBase
extends AbstractType
implements IType {
    private static final IType[] EMPTY_INTRINSIC_TYPES_ARRAY = new IType[0];
    private static final IGenericTypeVariable[] EMPTY_TYPE_VARIABLES_ARRAY = new IGenericTypeVariable[0];
    private final transient LockingLazyVar<Set<? extends IType>> _allTypesInHierarchyCache;
    private final transient LockingLazyVar<IType> _arrayTypeCache;
    protected final transient IJavaClassInfo _arrayComponentClass;
    private transient boolean _bDiscarded;

    protected TypeBase(IJavaClassInfo arrayComponentClass) {
        this._arrayComponentClass = arrayComponentClass;
        this._allTypesInHierarchyCache = new LockingLazyVar<Set<? extends IType>>(){

            @Override
            protected Set<? extends IType> init() {
                return TypeBase.this.loadAllTypesInHierarchy();
            }
        };
        this._arrayTypeCache = new LockingLazyVar<IType>(){

            @Override
            protected IType init() {
                IType arrayType = TypeBase.this.makeArrayType();
                return TypeSystem.getOrCreateTypeReference(arrayType);
            }
        };
    }

    protected TypeBase(Class<?> arrayComponentClass) {
        this(TypeSystem.getJavaClassInfo(arrayComponentClass));
    }

    protected TypeBase() {
        this(Object.class);
    }

    protected IType makeArrayType() {
        return new DefaultArrayType(TypeSystem.getOrCreateTypeReference(this), this.getArrayComponentClass(), this.getTypeLoader());
    }

    @Override
    public IType getEnclosingType() {
        return null;
    }

    @Override
    public IType getGenericType() {
        return null;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isParameterizedType() {
        return false;
    }

    @Override
    public boolean isGenericType() {
        return false;
    }

    @Override
    public IGenericTypeVariable[] getGenericTypeVariables() {
        return EMPTY_TYPE_VARIABLES_ARRAY;
    }

    @Override
    public IType getParameterizedType(IType ... ofType) {
        return null;
    }

    @Override
    public IType[] getTypeParameters() {
        return EMPTY_INTRINSIC_TYPES_ARRAY;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ((Object[])array)[iIndex];
    }

    @Override
    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ((Object[])array)[iIndex] = value;
    }

    @Override
    public int getArrayLength(Object array) throws IllegalArgumentException {
        return ((Object[])array).length;
    }

    @Override
    public IType getComponentType() {
        return null;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return TypeSystem.getByFullName(this.getName());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getModifiers() {
        return 1;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Set<? extends IType> getAllTypesInHierarchy() {
        return this._allTypesInHierarchyCache.get();
    }

    protected Set<? extends IType> loadAllTypesInHierarchy() {
        Set<IType> allTypes = this.isArray() ? this.getArrayVersionsOfEachType(this.getComponentType().getAllTypesInHierarchy()) : TypeBase.getAllClassesInClassHierarchyAsIntrinsicTypes(TypeSystem.getOrCreateTypeReference(this));
        return allTypes;
    }

    protected static Set<IType> getAllClassesInClassHierarchyAsIntrinsicTypes(IType type) {
        HashSet<IType> typeSet = new HashSet<IType>();
        TypeBase.addAllClassesInClassHierarchy(type, typeSet);
        return typeSet;
    }

    private static void addAllClassesInClassHierarchy(IType type, Set<IType> set) {
        if (!set.add(type)) {
            return;
        }
        for (IType iface : type.getInterfaces()) {
            TypeBase.addAllClassesInClassHierarchy(iface, set);
        }
        if (type.getSupertype() != null) {
            TypeBase.addAllClassesInClassHierarchy(type.getSupertype(), set);
        }
        if (type.isParameterizedType()) {
            TypeBase.addAllClassesInClassHierarchy(type.getGenericType(), set);
        }
        if (type.isGenericType() || !type.isParameterizedType()) {
            TypeBase.addAllClassesInClassHierarchy(TypeSystem.getDefaultParameterizedType(type), set);
        }
    }

    protected Set<IType> getArrayVersionsOfEachType(Set<? extends IType> componentTypes) {
        HashSet<IType> allTypes = new HashSet<IType>(1 + componentTypes.size());
        allTypes.add(JavaTypes.OBJECT());
        for (IType iType : componentTypes) {
            allTypes.add(iType.getArrayType());
        }
        return allTypes;
    }

    @Override
    public boolean isAssignableFrom(IType type) {
        return type.getAllTypesInHierarchy().contains(TypeSystem.getOrCreateTypeReference(this));
    }

    @Override
    public IType getArrayType() {
        return this._arrayTypeCache.get();
    }

    @Override
    public Object makeArrayInstance(int iLength) {
        return Array.newInstance(this.getArrayComponentClass().getBackingClass(), iLength);
    }

    protected IJavaClassInfo getArrayComponentClass() {
        return this._arrayComponentClass;
    }

    @Override
    public void unloadTypeInfo() {
        this._allTypesInHierarchyCache.clear();
        if (this._arrayTypeCache.isLoaded()) {
            this._arrayTypeCache.get().unloadTypeInfo();
        }
    }

    @Override
    public boolean isDiscarded() {
        return this._bDiscarded;
    }

    @Override
    public void setDiscarded(boolean bDiscarded) {
        this._bDiscarded = bDiscarded;
    }

    @Override
    public boolean isCompoundType() {
        return false;
    }

    @Override
    public Set<IType> getCompoundTypeComponents() {
        return null;
    }

    public IJavaType loadJavaType(String fullyQualifiedName) {
        IModule module = this.getTypeLoader().getModule();
        for (IModule m : module.getModuleTraversalList()) {
            IDefaultTypeLoader typeLoader;
            IType type;
            if (m == module || (type = (typeLoader = m.getTypeLoaders(IDefaultTypeLoader.class).get(0)).getType(fullyQualifiedName)) == null) continue;
            return (IJavaType)type;
        }
        return null;
    }
}

