/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class GosucUtil {
    public static String indent(String in) {
        StringBuilder sb = new StringBuilder(in);
        sb.insert(0, "  ");
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c != '\n') continue;
            sb.insert(i + 1, "  ");
        }
        return sb.toString();
    }

    public static IDirectory getDirectoryForPath(String path) {
        return CommonServices.getFileSystem().getIDirectory(new File(path));
    }

    public static List<String> makeStringPaths(List<IDirectory> sourcePaths) {
        ArrayList<String> paths = new ArrayList<String>();
        for (IDirectory dir : sourcePaths) {
            paths.add(dir.getPath().getPathString());
        }
        return paths;
    }

    public static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            System.err.println("Could not get URL for " + file);
            return null;
        }
    }

    public static List<IDirectory> toDirectories(List<String> paths) {
        ArrayList<IDirectory> dirs = new ArrayList<IDirectory>();
        for (String path : paths) {
            dirs.add(CommonServices.getFileSystem().getIDirectory(new File(path)));
        }
        return dirs;
    }

    public static List<String> getJreJars() {
        String javaHome = System.getProperty("java.home");
        Path libsDir = FileSystems.getDefault().getPath(javaHome, "/lib");
        List<String> retval = GosucUtil.getIbmClasspath();
        try {
            retval.addAll(Files.walk(libsDir, new FileVisitOption[0]).filter(path -> path.toFile().isFile()).filter(path -> path.toString().endsWith(".jar")).map(Path::toString).collect(Collectors.toList()));
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return retval;
    }

    protected static List<String> getIbmClasspath() {
        ArrayList<String> retval = new ArrayList<String>();
        if (System.getProperty("java.vendor").equals("IBM Corporation")) {
            String[] bootClasspath;
            String fileSeparator = System.getProperty("file.separator");
            String classpathSeparator = System.getProperty("path.separator");
            for (String entry : bootClasspath = System.getProperty("sun.boot.class.path").split(classpathSeparator)) {
                if (!entry.endsWith(fileSeparator + "vm.jar")) continue;
                retval.add(entry);
                break;
            }
        }
        return retval;
    }

    public static List<String> getGosuBootstrapJars() throws ClassNotFoundException {
        return Arrays.asList(GosucUtil.getClassLocation("gw.internal.gosu.parser.MetaType"), GosucUtil.getClassLocation("gw.lang.Gosu"), GosucUtil.getClassLocation("gw.internal.ext.org.objectweb.asm.ClassWriter"), GosucUtil.getClassLocation("gw.internal.ext.com.beust.jcommander.JCommander"), GosucUtil.getClassLocation("com.sun.source.tree.Tree"));
    }

    private static String getClassLocation(String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        ProtectionDomain pDomain = clazz.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        if (cSource != null) {
            File file;
            URL loc = cSource.getLocation();
            try {
                file = new File(URLDecoder.decode(loc.getPath(), StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Unsupported Encoding for URL: " + loc);
                System.err.println(e);
                file = new File(loc.getPath());
            }
            return file.getPath();
        }
        throw new ClassNotFoundException("Cannot find the location of the requested className <" + className + "> in classpath.");
    }
}

