/*
 * Decompiled with CFR 0.152.
 */
package gw.util.diff.sorted;

import gw.util.diff.sorted.Diff;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DiffIterator<T>
implements Iterator<Diff<T>> {
    private final Iterator<T> _oldIterator;
    private final Iterator<T> _newIterator;
    private T _oldItem;
    private T _newItem;
    private final Comparator<? super T> _comparator;
    private Diff<T> _next;

    public DiffIterator(Iterator<T> oldIterator, Iterator<T> newIterator) {
        this(oldIterator, newIterator, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        });
    }

    public DiffIterator(Iterable<T> oldIterable, Iterable<T> newIterable) {
        this(oldIterable.iterator(), newIterable.iterator());
    }

    public DiffIterator(Iterable<T> oldIterable, Iterable<T> newIterable, Comparator<? super T> comparator) {
        this(oldIterable.iterator(), newIterable.iterator(), comparator);
    }

    public DiffIterator(Iterator<T> oldIterator, Iterator<T> newIterator, Comparator<? super T> comparator) {
        this._oldIterator = oldIterator;
        this._newIterator = newIterator;
        this._comparator = comparator;
        if (oldIterator.hasNext()) {
            this._oldItem = oldIterator.next();
        }
        if (newIterator.hasNext()) {
            this._newItem = newIterator.next();
        }
        this.calcNext();
    }

    @Override
    public boolean hasNext() {
        return this._next != null;
    }

    @Override
    public Diff<T> next() {
        if (this._next == null) {
            throw new NoSuchElementException();
        }
        Diff<T> lastNext = this._next;
        this.calcNext();
        return lastNext;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void calcNext() {
        Integer compare = this.compare();
        if (compare == null) {
            this._next = null;
        } else if (compare > 0) {
            this._next = new Diff<Object>(null, this._newItem);
            this.nextNew();
        } else if (compare < 0) {
            this._next = new Diff<Object>(this._oldItem, null);
            this.nextOld();
        } else {
            this._next = new Diff<T>(this._oldItem, this._newItem);
            this.nextOld();
            this.nextNew();
        }
    }

    private void nextOld() {
        this._oldItem = this._oldIterator.hasNext() ? this._oldIterator.next() : null;
    }

    private void nextNew() {
        this._newItem = this._newIterator.hasNext() ? this._newIterator.next() : null;
    }

    private Integer compare() {
        if (this._oldItem == null) {
            if (this._newItem == null) {
                return null;
            }
            return 1;
        }
        if (this._newItem == null) {
            return -1;
        }
        return this._comparator.compare(this._oldItem, this._newItem);
    }
}

