/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java.asm;

import gw.internal.ext.org.objectweb.asm.AnnotationVisitor;
import gw.internal.ext.org.objectweb.asm.Attribute;
import gw.internal.ext.org.objectweb.asm.ClassReader;
import gw.internal.ext.org.objectweb.asm.ClassVisitor;
import gw.internal.ext.org.objectweb.asm.FieldVisitor;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.ext.org.objectweb.asm.signature.SignatureReader;
import gw.internal.ext.org.objectweb.asm.signature.SignatureVisitor;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IAsmJavaClassInfo;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.asm.AsmAnnotation;
import gw.lang.reflect.java.asm.AsmAnnotationVisitor;
import gw.lang.reflect.java.asm.AsmField;
import gw.lang.reflect.java.asm.AsmInnerClassType;
import gw.lang.reflect.java.asm.AsmMethod;
import gw.lang.reflect.java.asm.AsmPrimitiveType;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.AsmUtil;
import gw.lang.reflect.java.asm.DeclarationPartSignatureVisitor;
import gw.lang.reflect.java.asm.FieldDeclarationVisitor;
import gw.lang.reflect.java.asm.IAsmType;
import gw.lang.reflect.java.asm.IGeneric;
import gw.lang.reflect.java.asm.MethodDeclarationSignatureVisitor;
import gw.lang.reflect.java.asm.MethodDeclarationVisitor;
import gw.lang.reflect.java.asm.TypeDeclarationSignatureVisitor;
import gw.lang.reflect.module.IModule;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsmClass
implements IAsmType,
IGeneric {
    public static final AsmClass BYTE;
    public static final AsmClass SHORT;
    public static final AsmClass CHAR;
    public static final AsmClass INT;
    public static final AsmClass LONG;
    public static final AsmClass FLOAT;
    public static final AsmClass DOUBLE;
    public static final AsmClass BOOLEAN;
    public static final AsmClass VOID;
    private static final Map<String, AsmClass> PRIMITIVES;
    private Object _module;
    private URI _uri;
    private int _version;
    private int _modifiers;
    private AsmType _type;
    private AsmType _superClass;
    private List<AsmType> _interfaces;
    private AsmType _enclosingType;
    private boolean _bGeneric;
    private Map<String, AsmInnerClassType> _innerClasses;
    private List<AsmField> _fields;
    private List<AsmMethod> _methodsAndCtors;
    private List<AsmAnnotation> _annotations;

    public static AsmClass findPrimitive(String className) {
        return PRIMITIVES.get(className);
    }

    AsmClass(Object module, URI uri) {
        this._module = module;
        this._uri = uri;
    }

    private AsmClass(AsmPrimitiveType ptype) {
        this._type = ptype;
        this._modifiers = 9;
        this._superClass = null;
        this._innerClasses = Collections.emptyMap();
        this._interfaces = Collections.emptyList();
        this._fields = Collections.emptyList();
        this._methodsAndCtors = Collections.emptyList();
        this._annotations = Collections.emptyList();
    }

    public void init(byte[] classBytes) {
        ClassReader cr = new ClassReader(classBytes);
        cr.accept((ClassVisitor)new AsmClassVisitor(), 7);
    }

    public URI getUri() {
        return this._uri;
    }

    public AsmType getType() {
        return this._type;
    }

    @Override
    public AsmType getRawType() {
        return this._type.getRawType();
    }

    public AsmType getEnclosingType() {
        return this._enclosingType;
    }

    @Override
    public AsmType getComponentType() {
        return null;
    }

    public AsmType getSuperClass() {
        return this._superClass;
    }

    public void setSuperClass(AsmType type) {
        this._superClass = type;
    }

    public Map<String, AsmInnerClassType> getInnerClasses() {
        return this._innerClasses;
    }

    public List<AsmType> getInterfaces() {
        return this._interfaces;
    }

    public List<AsmField> getDeclaredFields() {
        return this._fields;
    }

    private void addField(AsmField field) {
        if (this._fields.isEmpty()) {
            this._fields = new ArrayList<AsmField>();
        }
        this._fields.add(field);
    }

    public List<AsmMethod> getDeclaredMethodsAndConstructors() {
        return this._methodsAndCtors;
    }

    private void addMethod(AsmMethod method) {
        if (this._methodsAndCtors.isEmpty()) {
            this._methodsAndCtors = new ArrayList<AsmMethod>();
        }
        this._methodsAndCtors.add(method);
    }

    public List<AsmAnnotation> getDeclaredAnnotations() {
        return this._annotations;
    }

    private void addAnnotation(AsmAnnotation annotation) {
        if (this._annotations.isEmpty()) {
            this._annotations = new ArrayList<AsmAnnotation>();
        }
        this._annotations.add(annotation);
    }

    @Override
    public boolean isGeneric() {
        return this._bGeneric;
    }

    @Override
    public void setGeneric() {
        this._bGeneric = true;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public int getVersion() {
        return this._version;
    }

    public String toString() {
        return this._type.getName();
    }

    @Override
    public String getName() {
        return this._type.getName();
    }

    public String getNameWithArrayBrackets() {
        return this._type.getNameWithArrayBrackets();
    }

    @Override
    public String getSimpleName() {
        int iDollar;
        String name = this._type.getSimpleName();
        int n = iDollar = this._enclosingType == null ? -1 : name.lastIndexOf(36);
        if (iDollar > 0) {
            name = name.substring(iDollar + 1);
        }
        return name;
    }

    @Override
    public List<AsmType> getTypeParameters() {
        return this._type.getTypeParameters();
    }

    @Override
    public boolean isParameterized() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isTypeVariable() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return this._type.isPrimitive();
    }

    @Override
    public String getFqn() {
        return this._type.getFqn();
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isEnum() {
        return Modifier.isEnum(this.getModifiers());
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public AsmAnnotation getAnnotation(Class annotationClass) {
        for (AsmAnnotation anno : this.getDeclaredAnnotations()) {
            if (!annotationClass.getName().equals(anno.getType().getName())) continue;
            return anno;
        }
        return null;
    }

    static {
        PRIMITIVES = new HashMap<String, AsmClass>();
        BYTE = new AsmClass(AsmPrimitiveType.findPrimitive("byte"));
        PRIMITIVES.put("byte", BYTE);
        SHORT = new AsmClass(AsmPrimitiveType.findPrimitive("short"));
        PRIMITIVES.put("short", SHORT);
        CHAR = new AsmClass(AsmPrimitiveType.findPrimitive("char"));
        PRIMITIVES.put("char", CHAR);
        INT = new AsmClass(AsmPrimitiveType.findPrimitive("int"));
        PRIMITIVES.put("int", INT);
        LONG = new AsmClass(AsmPrimitiveType.findPrimitive("long"));
        PRIMITIVES.put("long", LONG);
        FLOAT = new AsmClass(AsmPrimitiveType.findPrimitive("float"));
        PRIMITIVES.put("float", FLOAT);
        DOUBLE = new AsmClass(AsmPrimitiveType.findPrimitive("double"));
        PRIMITIVES.put("double", DOUBLE);
        BOOLEAN = new AsmClass(AsmPrimitiveType.findPrimitive("boolean"));
        PRIMITIVES.put("boolean", BOOLEAN);
        VOID = new AsmClass(AsmPrimitiveType.findPrimitive("void"));
        PRIMITIVES.put("void", VOID);
    }

    private class AsmClassVisitor
    extends ClassVisitor {
        public AsmClassVisitor() {
            super(458752);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            AsmClass.this._type = AsmUtil.makeNonPrimitiveType(name);
            AsmClass outerClass = this.ensureOuterIsLoadedFirst();
            AsmClass.this._version = version;
            AsmClass.this._modifiers = access;
            if (outerClass != null) {
                this.barf(outerClass);
            }
            AsmClass.this._superClass = Modifier.isInterface(access) ? null : (superName != null ? AsmUtil.makeType(superName) : null);
            AsmClass.this._innerClasses = Collections.emptyMap();
            AsmClass.this._fields = Collections.emptyList();
            AsmClass.this._methodsAndCtors = Collections.emptyList();
            AsmClass.this._annotations = Collections.emptyList();
            this.assignInterfaces(interfaces);
            this.assignGenericInfo(signature);
        }

        private void barf(AsmClass outerClass) {
            AsmInnerClassType innerClass = outerClass.getInnerClasses().get(AsmClass.this._type.getName());
            if (innerClass != null) {
                AsmClass.this._modifiers = innerClass.getModifiers();
            }
        }

        private AsmClass ensureOuterIsLoadedFirst() {
            String outerName;
            IJavaClassInfo classInfo;
            String typeName = AsmClass.this._type.getName();
            int iDollar = typeName.lastIndexOf(36);
            if (iDollar > 0 && (classInfo = TypeSystem.getJavaClassInfo(outerName = typeName.substring(0, iDollar), (IModule)AsmClass.this._module)) != null) {
                AsmClass.this._enclosingType = AsmUtil.makeType(outerName);
                return (AsmClass)((IAsmJavaClassInfo)classInfo).getAsmType();
            }
            return null;
        }

        public void visitSource(String s, String s2) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
            AsmClass.this._enclosingType = owner == null ? null : AsmUtil.makeType(owner);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean bVisibleAtRuntime) {
            AsmAnnotation asmAnnotation = new AsmAnnotation(desc, bVisibleAtRuntime);
            AsmClass.this.addAnnotation(asmAnnotation);
            return new AsmAnnotationVisitor(asmAnnotation);
        }

        public void visitAttribute(Attribute attribute) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (outerName != null && !AsmUtil.makeDotName(outerName).equals(AsmClass.this.getType().getName())) {
                return;
            }
            if (innerName == null) {
                return;
            }
            int iDollar = name.lastIndexOf(36);
            if (iDollar >= 0 && iDollar < name.length() - 1 && Character.isDigit(name.charAt(iDollar + 1))) {
                return;
            }
            if (AsmClass.this._innerClasses.isEmpty()) {
                AsmClass.this._innerClasses = new HashMap(2);
            }
            String innerClass = AsmUtil.makeDotName(name);
            AsmClass.this._innerClasses.put(innerClass, new AsmInnerClassType(innerClass, access));
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            AsmField field = new AsmField(AsmClass.this, access, name, desc, value);
            if (signature != null) {
                SignatureReader sr = new SignatureReader(signature);
                DeclarationPartSignatureVisitor visitor = new DeclarationPartSignatureVisitor();
                sr.accept((SignatureVisitor)visitor);
                field.setType(visitor.getCurrentType());
            }
            AsmClass.this.addField(field);
            return new FieldDeclarationVisitor(field);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            AsmMethod method = new AsmMethod(AsmClass.this, access, name, desc, exceptions);
            if (signature != null) {
                SignatureReader sr = new SignatureReader(signature);
                MethodDeclarationSignatureVisitor visitor = new MethodDeclarationSignatureVisitor(method);
                sr.accept((SignatureVisitor)visitor);
                method.update(visitor.getParamVisitors(), visitor.getReturnVisitor(), visitor.getExceptionVisitors());
            }
            AsmClass.this.addMethod(method);
            return new MethodDeclarationVisitor(method);
        }

        public void visitEnd() {
        }

        private void assignGenericInfo(String signature) {
            if (signature != null) {
                SignatureReader sr = new SignatureReader(signature);
                TypeDeclarationSignatureVisitor visitor = new TypeDeclarationSignatureVisitor(AsmClass.this);
                sr.accept((SignatureVisitor)visitor);
                visitor.update();
            }
        }

        private void assignInterfaces(String[] interfaces) {
            if (interfaces != null) {
                ArrayList<AsmType> ifaces = new ArrayList<AsmType>(interfaces.length);
                for (int i = 0; i < interfaces.length; ++i) {
                    ifaces.add(AsmUtil.makeType(interfaces[i]));
                }
                AsmClass.this._interfaces = ifaces;
            } else {
                AsmClass.this._interfaces = Collections.emptyList();
            }
        }
    }
}

