/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.enhancements;

import gw.util.IOrderedList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OrderedList<T>
extends AbstractList<T>
implements IOrderedList<T> {
    private List<Tuple<T>> _orderByBlocks = new LinkedList<Tuple<T>>();
    private Iterable<T> _originalValues = null;
    private List<T> _values = null;

    public OrderedList(Iterable<T> values) {
        this._originalValues = values;
    }

    public void addOrderBy(IToComparable<T> block) {
        this.addOrderBy(block, null);
    }

    public void addOrderBy(IToComparable<T> block, Comparator comparator) {
        this.checkSort();
        this.checkOrderBy();
        this._orderByBlocks.add(new Tuple<T>(Direction.ASCENDING, block, comparator));
    }

    public void addOrderByDescending(IToComparable<T> block) {
        this.addOrderByDescending(block, null);
    }

    public void addOrderByDescending(IToComparable<T> block, Comparator comparator) {
        this.checkSort();
        this.checkOrderBy();
        this._orderByBlocks.add(new Tuple<T>(Direction.DESCENDING, block, comparator));
    }

    public OrderedList<T> addThenBy(IToComparable<T> block) {
        return this.addThenBy(block, null);
    }

    public OrderedList<T> addThenBy(IToComparable<T> block, Comparator comparator) {
        this.checkSort();
        OrderedList<T> lst = new OrderedList<T>(this._originalValues);
        lst._orderByBlocks = new LinkedList<Tuple<T>>(this._orderByBlocks);
        lst._orderByBlocks.add(new Tuple<T>(Direction.ASCENDING, block, comparator));
        return lst;
    }

    public OrderedList<T> addThenByDescending(IToComparable<T> block) {
        return this.addThenByDescending(block, null);
    }

    public OrderedList<T> addThenByDescending(IToComparable<T> block, Comparator comparator) {
        this.checkSort();
        OrderedList<T> lst = new OrderedList<T>(this._originalValues);
        lst._orderByBlocks = new LinkedList<Tuple<T>>(this._orderByBlocks);
        lst._orderByBlocks.add(new Tuple<T>(Direction.DESCENDING, block, comparator));
        return lst;
    }

    @Override
    public T get(int index) {
        this.maybeSort();
        return this._values.get(index);
    }

    @Override
    public int size() {
        this.maybeSort();
        return this._values.size();
    }

    @Override
    public Iterator<T> iterator() {
        this.maybeSort();
        return this._values.iterator();
    }

    private void checkOrderBy() {
        if (this._orderByBlocks.size() > 0) {
            throw new IllegalStateException("You can only orderBy() once.  After that, you must use thenBy()");
        }
    }

    private void checkSort() {
        if (this._values != null) {
            throw new IllegalStateException("This list has already been sorted!");
        }
    }

    private void maybeSort() {
        if (this._values == null) {
            this._values = new ArrayList<T>();
            for (T originalValue : this._originalValues) {
                this._values.add(originalValue);
            }
            Collections.sort(this._values, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    for (Tuple orderByBlock : OrderedList.this._orderByBlocks) {
                        int ascendingCmp;
                        Comparable c1 = orderByBlock.getBlock().toComparable(o1);
                        Comparable c2 = orderByBlock.getBlock().toComparable(o2);
                        Comparator comparator = orderByBlock.getComparator();
                        int n = ascendingCmp = comparator != null ? comparator.compare(c1, c2) : c1.compareTo(c2);
                        int cmp = orderByBlock.getDirection() == Direction.ASCENDING ? ascendingCmp : (ascendingCmp < 0 ? 1 : -ascendingCmp);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
            });
        }
    }

    public static interface IToComparable<E> {
        public Comparable toComparable(E var1);
    }

    private static class Tuple<T> {
        private Direction _direction;
        private IToComparable<T> _block;
        private Comparator _comparator;

        public Tuple(Direction direction, IToComparable<T> block, Comparator comparator) {
            this._direction = direction;
            this._block = block;
            this._comparator = comparator;
        }

        public Direction getDirection() {
            return this._direction;
        }

        public IToComparable<T> getBlock() {
            return this._block;
        }

        public Comparator getComparator() {
            return this._comparator;
        }
    }

    static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

