/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import manifold.util.JreUtil;
import manifold.util.ManExceptionUtil;

public class GosucUtil {
    public static String indent(String in) {
        StringBuilder sb = new StringBuilder(in);
        sb.insert(0, "  ");
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c != '\n') continue;
            sb.insert(i + 1, "  ");
        }
        return sb.toString();
    }

    public static IDirectory getDirectoryForPath(String uriPath) {
        return CommonServices.getFileSystem().getIDirectory(Paths.get(URI.create(uriPath)));
    }

    public static List<String> makeStringPaths(List<IDirectory> sourcePaths) {
        ArrayList<String> paths = new ArrayList<String>();
        for (IDirectory dir : sourcePaths) {
            paths.add(dir.getPath().getPathString());
        }
        return paths;
    }

    public static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            System.err.println("Could not get URL for " + file);
            return null;
        }
    }

    public static List<IDirectory> toDirectories(List<String> uriPaths) {
        ArrayList<IDirectory> dirs = new ArrayList<IDirectory>();
        for (String uri : uriPaths) {
            dirs.add(CommonServices.getFileSystem().getIDirectory(Paths.get(URI.create(uri))));
        }
        return dirs;
    }

    public static List<String> getJreJars() {
        String javaHome = System.getProperty("java.home");
        Path libsDir = FileSystems.getDefault().getPath(javaHome, "/lib");
        List<String> retval = GosucUtil.getIbmClasspath();
        try {
            retval.addAll(Files.walk(libsDir, new FileVisitOption[0]).filter(path -> path.toFile().isFile()).filter(path -> path.toString().endsWith(".jar")).map(Path::toString).collect(Collectors.toList()));
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return retval;
    }

    protected static List<String> getIbmClasspath() {
        ArrayList<String> retval = new ArrayList<String>();
        if (System.getProperty("java.vendor").equals("IBM Corporation")) {
            String[] bootClasspath;
            String fileSeparator = System.getProperty("file.separator");
            String classpathSeparator = System.getProperty("path.separator");
            for (String entry : bootClasspath = System.getProperty("sun.boot.class.path").split(classpathSeparator)) {
                if (!entry.endsWith(fileSeparator + "vm.jar")) continue;
                retval.add(entry);
                break;
            }
        }
        return retval;
    }

    public static List<String> getGosuBootstrapJars() {
        if (JreUtil.isJava8()) {
            return GosucUtil.getGosuBootstrapJars_Java8();
        }
        return GosucUtil.getGosuBootstrapJars_Java9();
    }

    public static List<String> getGosuBootstrapJars_Java8() {
        return Arrays.asList(GosucUtil.getClassLocation("gw.internal.gosu.parser.MetaType"), GosucUtil.getClassLocation("gw.lang.Gosu"), GosucUtil.getClassLocation("manifold.api.host.IManifoldHost"), GosucUtil.getClassLocation("manifold.util.ReflectUtil"), GosucUtil.getClassLocation("gw.internal.ext.org.objectweb.asm.ClassWriter"), GosucUtil.getClassLocation("com.sun.source.tree.Tree"), GosucUtil.getClassLocation("gw.internal.ext.com.beust.jcommander.JCommander"));
    }

    public static List<String> getGosuBootstrapJars_Java9() {
        return Arrays.asList(GosucUtil.getClassLocation("gw.internal.gosu.parser.MetaType"), GosucUtil.getClassLocation("gw.lang.Gosu"), GosucUtil.getClassLocation("manifold.api.host.IManifoldHost"), GosucUtil.getClassLocation("manifold.util.ReflectUtil"), GosucUtil.getClassLocation("gw.internal.ext.org.objectweb.asm.ClassWriter"), GosucUtil.getClassLocation("gw.internal.ext.com.beust.jcommander.JCommander"));
    }

    public static String getClassLocation(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Unable to locate Gosu libraries in classpath.\n", cnfe);
        }
        ProtectionDomain pDomain = clazz.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        if (cSource != null) {
            URI file;
            URL loc = cSource.getLocation();
            try {
                file = loc.toURI();
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked((Throwable)e);
            }
            return file.toString();
        }
        throw new RuntimeException("Cannot find the location of the requested className <" + className + "> in classpath.");
    }
}

