/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java;

import gw.lang.javadoc.IClassDocNode;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassField;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaClassTypeVariable;
import gw.lang.reflect.java.IJavaMethodDescriptor;
import gw.lang.reflect.java.IJavaPropertyDescriptor;
import gw.lang.reflect.java.ITypeInfoResolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.TreeSet;

public interface IJavaClassInfo
extends IJavaAnnotatedElement,
IJavaClassType,
ITypeInfoResolver {
    public static final Object LOCK = IJavaClassInfo.class;

    public String getNameSignature();

    public String getRelativeName();

    public String getDisplayName();

    @Override
    public boolean isArray();

    public boolean isEnum();

    public boolean isPrimitive();

    public boolean isAnnotation();

    public boolean isInterface();

    public boolean isAssignableFrom(IJavaClassInfo var1);

    public boolean isPublic();

    public boolean isProtected();

    public boolean isInternal();

    public boolean isPrivate();

    public Object newInstance() throws InstantiationException, IllegalAccessException;

    public IJavaClassMethod getMethod(String var1, IJavaClassInfo ... var2) throws NoSuchMethodException;

    public IJavaClassMethod getDeclaredMethod(String var1, IJavaClassInfo ... var2) throws NoSuchMethodException;

    public IJavaClassMethod[] getDeclaredMethods();

    public IJavaMethodDescriptor[] getMethodDescriptors();

    public IJavaClassInfo[] getInterfaces();

    public IJavaClassType[] getGenericInterfaces();

    public IJavaClassInfo getSuperclass();

    public IJavaClassType getGenericSuperclass();

    public IJavaClassField[] getDeclaredFields();

    default public IJavaClassField getDeclaredField(String name) {
        return Arrays.stream(this.getDeclaredFields()).filter(f -> f.getName().equals(name)).findFirst().get();
    }

    public IJavaClassField[] getFields();

    default public IJavaClassField getField(String name) {
        return Arrays.stream(this.getFields()).filter(f -> f.getName().equals(name)).findFirst().get();
    }

    public Object[] getEnumConstants();

    public IJavaPropertyDescriptor[] getPropertyDescriptors();

    public IJavaClassConstructor[] getDeclaredConstructors();

    public IJavaClassConstructor getConstructor(IJavaClassInfo ... var1) throws NoSuchMethodException;

    public IType getJavaType();

    public IJavaClassTypeVariable[] getTypeParameters();

    public IClassDocNode createClassDocNode();

    public boolean hasCustomBeanInfo();

    public boolean isVisibleViaFeatureDescriptor(IScriptabilityModifier var1);

    public boolean isHiddenViaFeatureDescriptor();

    @Override
    public IJavaClassInfo getComponentType();

    public int getModifiers();

    public IType getEnclosingType();

    public IJavaClassInfo getArrayType();

    public IJavaClassInfo[] getDeclaredClasses();

    public Class getBackingClass();

    public ISourceFileHandle getSourceFileHandle();

    public boolean equals(Object var1);

    public int hashCode();

    default public IJavaClassInfo getDeepestClassAtOffset(int offset) {
        return null;
    }

    default public boolean isCompilable() {
        return false;
    }

    default public byte[] compile() {
        throw new UnsupportedOperationException();
    }

    public static class Util {
        public static IJavaClassMethod[] getMethods(IJavaClassInfo classInfo) {
            TreeSet<IJavaClassMethod> methods = new TreeSet<IJavaClassMethod>();
            TreeSet<IJavaClassMethod> publicMethods = Util.getPublicMethods(classInfo, methods);
            return publicMethods.toArray(new IJavaClassMethod[publicMethods.size()]);
        }

        private static TreeSet<IJavaClassMethod> getPublicMethods(IJavaClassInfo classInfo, TreeSet<IJavaClassMethod> methods) {
            for (IJavaClassMethod m : classInfo.getDeclaredMethods()) {
                if (!Modifier.isPublic(m.getModifiers())) continue;
                methods.add(m);
            }
            IJavaClassInfo superclass = classInfo.getSuperclass();
            if (superclass != null) {
                Util.getPublicMethods(superclass, methods);
            }
            for (IJavaClassInfo iface : classInfo.getInterfaces()) {
                Util.getPublicMethods(iface, methods);
            }
            return methods;
        }

        public static IJavaClassMethod get(Method method) {
            IJavaClassInfo jci = TypeSystem.getJavaClassInfo(method.getDeclaringClass());
            try {
                return jci.getDeclaredMethod(method.getName(), Util.get(method.getParameterTypes()));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public static IJavaClassConstructor get(Constructor ctor) {
            IJavaClassInfo jci = TypeSystem.getJavaClassInfo(ctor.getDeclaringClass());
            try {
                return jci.getConstructor(Util.get(ctor.getParameterTypes()));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        private static IJavaClassInfo[] get(Class[] classes) {
            IJavaClassInfo[] jcis = new IJavaClassInfo[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                jcis[i] = TypeSystem.getJavaClassInfo(classes[i]);
            }
            return jcis;
        }
    }
}

