/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

public final class Array {
    private Array() {
    }

    public static Object newInstance(Class<?> componentType, int length) {
        if (!componentType.isPrimitive()) {
            return java.lang.reflect.Array.newInstance(componentType, length);
        }
        if (componentType == Boolean.TYPE) {
            return new boolean[length];
        }
        if (componentType == Byte.TYPE) {
            return new byte[length];
        }
        if (componentType == Character.TYPE) {
            return new char[length];
        }
        if (componentType == Short.TYPE) {
            return new short[length];
        }
        if (componentType == Integer.TYPE) {
            return new int[length];
        }
        if (componentType == Long.TYPE) {
            return new long[length];
        }
        if (componentType == Float.TYPE) {
            return new float[length];
        }
        if (componentType == Double.TYPE) {
            return new double[length];
        }
        throw new IllegalArgumentException();
    }

    public static Object newInstance(Class<?> componentType, int[] dimensions) {
        if (dimensions.length <= 0) {
            throw new IllegalArgumentException("Empty dimensions array.");
        }
        return java.lang.reflect.Array.newInstance(componentType, dimensions);
    }

    public static int getLength(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static Object get(Object array, int index) {
        if (array instanceof Object[]) {
            return ((Object[])array)[index];
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array)[index] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (array instanceof byte[]) {
            return new Byte(((byte[])array)[index]);
        }
        if (array instanceof char[]) {
            return new Character(((char[])array)[index]);
        }
        if (array instanceof short[]) {
            return new Short(((short[])array)[index]);
        }
        if (array instanceof int[]) {
            return new Integer(((int[])array)[index]);
        }
        if (array instanceof long[]) {
            return new Long(((long[])array)[index]);
        }
        if (array instanceof float[]) {
            return new Float(((float[])array)[index]);
        }
        if (array instanceof double[]) {
            return new Double(((double[])array)[index]);
        }
        if (array == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static boolean getBoolean(Object array, int index) {
        if (array instanceof boolean[]) {
            return ((boolean[])array)[index];
        }
        if (array == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static byte getByte(Object array, int index) {
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        if (array == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static char getChar(Object array, int index) {
        if (array instanceof char[]) {
            return ((char[])array)[index];
        }
        if (array == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static short getShort(Object array, int index) {
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        return Array.getByte(array, index);
    }

    public static int getInt(Object array, int index) {
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        if (array instanceof char[]) {
            return ((char[])array)[index];
        }
        return Array.getShort(array, index);
    }

    public static long getLong(Object array, int index) {
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        return Array.getInt(array, index);
    }

    public static float getFloat(Object array, int index) {
        if (array instanceof float[]) {
            return ((float[])array)[index];
        }
        return Array.getLong(array, index);
    }

    public static double getDouble(Object array, int index) {
        if (array instanceof double[]) {
            return ((double[])array)[index];
        }
        return Array.getFloat(array, index);
    }

    public static void set(Object array, int index, Object value) {
        if (array instanceof Object[]) {
            if (value != null && !array.getClass().getComponentType().isInstance(value)) {
                throw new IllegalArgumentException();
            }
            ((Object[])array)[index] = value;
        } else if (value instanceof Byte) {
            Array.setByte(array, index, (Byte)value);
        } else if (value instanceof Short) {
            Array.setShort(array, index, (Short)value);
        } else if (value instanceof Integer) {
            Array.setInt(array, index, (Integer)value);
        } else if (value instanceof Long) {
            Array.setLong(array, index, (Long)value);
        } else if (value instanceof Float) {
            Array.setFloat(array, index, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            Array.setDouble(array, index, (Double)value);
        } else if (value instanceof Character) {
            Array.setChar(array, index, ((Character)value).charValue());
        } else if (value instanceof Boolean) {
            Array.setBoolean(array, index, (Boolean)value);
        } else {
            if (array == null) {
                throw new NullPointerException();
            }
            throw new IllegalArgumentException();
        }
    }

    public static void setBoolean(Object array, int index, boolean value) {
        if (!(array instanceof boolean[])) {
            if (array == null) {
                throw new NullPointerException();
            }
            throw new IllegalArgumentException();
        }
        ((boolean[])array)[index] = value;
    }

    public static void setByte(Object array, int index, byte value) {
        if (array instanceof byte[]) {
            ((byte[])array)[index] = value;
        } else {
            Array.setShort(array, index, value);
        }
    }

    public static void setChar(Object array, int index, char value) {
        if (array instanceof char[]) {
            ((char[])array)[index] = value;
        } else {
            Array.setInt(array, index, value);
        }
    }

    public static void setShort(Object array, int index, short value) {
        if (array instanceof short[]) {
            ((short[])array)[index] = value;
        } else {
            Array.setInt(array, index, value);
        }
    }

    public static void setInt(Object array, int index, int value) {
        if (array instanceof int[]) {
            ((int[])array)[index] = value;
        } else {
            Array.setLong(array, index, value);
        }
    }

    public static void setLong(Object array, int index, long value) {
        if (array instanceof long[]) {
            ((long[])array)[index] = value;
        } else {
            Array.setFloat(array, index, value);
        }
    }

    public static void setFloat(Object array, int index, float value) {
        if (array instanceof float[]) {
            ((float[])array)[index] = value;
        } else {
            Array.setDouble(array, index, value);
        }
    }

    public static void setDouble(Object array, int index, double value) {
        if (!(array instanceof double[])) {
            if (array == null) {
                throw new NullPointerException();
            }
            throw new IllegalArgumentException();
        }
        ((double[])array)[index] = value;
    }
}

