/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.util.GosuObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GosuCollectionUtil {
    public static <S, T> Map<S, T> compactAndLockHashMap(HashMap<S, T> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<S, T> stEntry = map.entrySet().iterator().next();
            return Collections.singletonMap(stEntry.getKey(), stEntry.getValue());
        }
        HashMap<S, T> newMap = new HashMap<S, T>(map.size(), 1.0f);
        newMap.putAll(map);
        return Collections.unmodifiableMap(newMap);
    }

    public static <T> List<T> compactAndLockList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static boolean startsWith(List<?> list, List<?> prefix) {
        if (list.size() < prefix.size()) {
            return false;
        }
        Iterator<?> listIter = list.iterator();
        for (Object prefixElement : prefix) {
            boolean b = listIter.hasNext();
            assert (b) : "list claims to have at least as many elements as prefix, but its iterator is exhausted first";
            if (GosuObjectUtil.equals(prefixElement, listIter.next())) continue;
            return false;
        }
        return true;
    }
}

