/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.List;

public class ConditionContext {
    private List<Label> _falseList = new ArrayList<Label>();
    private List<Label> _trueList = new ArrayList<Label>();
    private int _opcode = 154;

    public Label generateFalseLabel() {
        Label label;
        if (this._falseList.isEmpty()) {
            label = new Label();
            this._falseList.add(label);
        } else {
            label = this._falseList.get(0);
        }
        return label;
    }

    public Label generateTrueLabel() {
        Label label;
        if (this._trueList.isEmpty()) {
            label = new Label();
            this._trueList.add(label);
        } else {
            label = this._trueList.get(0);
        }
        return label;
    }

    public void setFalseLabels(List<Label> labels) {
        this._falseList = new ArrayList<Label>(labels);
    }

    public void setTrueLabels(List<Label> labels) {
        this._trueList = new ArrayList<Label>(labels);
    }

    public void mergeLabels(boolean kind, ConditionContext context) {
        List<Label> labels = this.getLabels(kind);
        labels.addAll(context.getLabels(kind));
    }

    public void fixLabels(boolean kind, MethodVisitor mv) {
        List<Label> labels = this.getLabels(kind);
        for (Label l : labels) {
            mv.visitLabel(l);
        }
        labels.clear();
    }

    public List<Label> getLabels(boolean kind) {
        if (kind) {
            return this._trueList;
        }
        return this._falseList;
    }

    public void update(ConditionContext context) {
        this.setFalseLabels(context.getLabels(false));
        this.setTrueLabels(context.getLabels(true));
        this._opcode = context.getOperator();
    }

    public void setOperator(int opcode) {
        this._opcode = opcode;
    }

    public int getOperator() {
        return this._opcode;
    }

    public void clear() {
        this._falseList.clear();
        this._trueList.clear();
        this._opcode = 154;
    }
}

