/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.builder;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.builder.IRMethodBuilder;
import gw.lang.ir.statement.IRFieldDecl;
import gw.lang.ir.statement.IRMethodStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@UnstableAPI
public class IRBuilderContext {
    private IRMethodBuilder _methodBuilder;
    private Map<String, IRSymbol> _symbols;

    public IRBuilderContext(IRMethodBuilder methodBuilder) {
        this._methodBuilder = methodBuilder;
        this._symbols = new HashMap<String, IRSymbol>();
        for (IRSymbol symbol : this._methodBuilder.getParameters()) {
            this._symbols.put(symbol.getName(), symbol);
        }
    }

    public IRFieldDecl findField(String name) {
        List<IRFieldDecl> fieldDecls = this._methodBuilder.getClassBuilder().getFields();
        IRFieldDecl field = null;
        for (IRFieldDecl decl : fieldDecls) {
            if (!decl.getName().equals(name)) continue;
            field = decl;
            break;
        }
        if (field == null) {
            throw new IllegalArgumentException("No field found named " + name);
        }
        return field;
    }

    public IRMethodStatement findMethod(String name, int numArgs) {
        List<IRMethodStatement> methodDecls = this._methodBuilder.getClassBuilder().getMethods();
        IRMethodStatement method = null;
        for (IRMethodStatement decl : methodDecls) {
            if (!decl.getName().equals(name) || decl.getParameters().size() != numArgs) continue;
            if (method != null) {
                throw new IllegalArgumentException("Multiple methods named " + name + " found with " + numArgs + " on type " + this.owningType().getName());
            }
            method = decl;
        }
        return method;
    }

    public IRType owningType() {
        return this._methodBuilder.getClassBuilder().getThisType();
    }

    public IRType currentClassSuperType() {
        return this._methodBuilder.getClassBuilder().getSuperType();
    }

    public IRType currentReturnType() {
        return this._methodBuilder.getReturnType();
    }

    public IRSymbol findVar(String name) {
        IRSymbol symbol = this._symbols.get(name);
        if (symbol == null) {
            throw new IllegalArgumentException("No symbol found named " + name);
        }
        return symbol;
    }

    public IRSymbol getOrCreateVar(String name, IRType type) {
        IRSymbol symbol = this._symbols.get(name);
        if (symbol == null) {
            symbol = new IRSymbol(name, type, false);
            this._symbols.put(name, symbol);
        }
        return symbol;
    }

    public IRSymbol tempSymbol(IRType type) {
        IRSymbol temp = new IRSymbol("**temp" + this._symbols.size(), type, true);
        this._symbols.put(temp.getName(), temp);
        return temp;
    }
}

