/*
 * Decompiled with CFR 0.152.
 */
package gw.fs;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.fs.jar.IJarFileDirectory;
import gw.lang.UnstableAPI;
import gw.util.DynamicArray;
import java.util.List;

@UnstableAPI
public class IDirectoryUtil {
    public static DynamicArray<? extends IFile> allContainedFilesExcludingIgnored(IDirectory dir) {
        DynamicArray<IFile> files = new DynamicArray<IFile>();
        IDirectoryUtil.allContainedFilesExcludingIgnored(dir, dir, files);
        return files;
    }

    private static void allContainedFilesExcludingIgnored(IDirectory root, IDirectory dir, DynamicArray<IFile> files) {
        files.addAll(dir.listFiles());
        for (IDirectory iDirectory : dir.listDirs()) {
            if (CommonServices.getPlatformHelper().isPathIgnored(root.relativePath(iDirectory))) continue;
            IDirectoryUtil.allContainedFilesExcludingIgnored(root, iDirectory, files);
        }
    }

    public static DynamicArray<String> splitPath(String relativePath) {
        DynamicArray<String> results = new DynamicArray<String>();
        int left = 0;
        int cur = 0;
        int right = relativePath.length();
        boolean consumingPathSeparators = true;
        boolean first = true;
        while (left < right) {
            String pathComponent;
            while (cur < right && IDirectoryUtil.isPathSeparator(relativePath.charAt(cur)) == consumingPathSeparators) {
                ++cur;
            }
            if (!(consumingPathSeparators || cur <= left || (pathComponent = relativePath.substring(left, cur)).equals(".") && !first)) {
                if (pathComponent.equals("..") && !first) {
                    if (results.isEmpty() || results.get(results.size() - 1).equals("..")) {
                        results.add(pathComponent);
                    } else {
                        results.remove(results.size() - 1);
                    }
                } else {
                    results.add(pathComponent);
                }
            }
            if (left != cur) {
                left = cur;
                first = false;
            }
            consumingPathSeparators = !consumingPathSeparators;
        }
        return results;
    }

    private static boolean isPathSeparator(char character) {
        return character == '/' || character == '\\';
    }

    public static String relativePath(IResource root, IResource resource) {
        return root.getPath().relativePath(resource.getPath(), "/");
    }

    public static IDirectory dir(IJarFileDirectory root, String relativePath) {
        DynamicArray<String> pathComponents = IDirectoryUtil.splitPath(relativePath);
        if (pathComponents.size() == 0) {
            return root;
        }
        if (pathComponents.size() == 1) {
            return root.getOrCreateDirectory((String)pathComponents.get(0));
        }
        return IDirectoryUtil.findParentDirectory(root, pathComponents);
    }

    public static IFile file(IJarFileDirectory root, String path) {
        DynamicArray<String> pathComponents = IDirectoryUtil.splitPath(path);
        if (pathComponents.size() == 0) {
            throw new IllegalArgumentException("Cannot call file() with an empty path");
        }
        if (pathComponents.size() == 1) {
            return root.getOrCreateFile((String)pathComponents.get(0));
        }
        String fileName = (String)pathComponents.remove(pathComponents.size() - 1);
        IDirectory parentDir = IDirectoryUtil.findParentDirectory(root, pathComponents);
        return parentDir.file(fileName);
    }

    private static IDirectory findParentDirectory(IDirectory root, List<String> relativePath) {
        IDirectory parent = root;
        for (String pathComponent : relativePath) {
            if (pathComponent.equals(".")) continue;
            if (pathComponent.equals("..")) {
                parent = parent.getParent();
                continue;
            }
            parent = parent.dir(pathComponent);
        }
        return parent;
    }
}

