/*
 * Decompiled with CFR 0.152.
 */
package gw.fs.physical;

import gw.fs.IDirectory;
import gw.fs.IDirectoryUtil;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.fs.ResourcePath;
import gw.fs.physical.IFileMetadata;
import gw.fs.physical.IPhysicalFileSystem;
import gw.fs.physical.PhysicalFileImpl;
import gw.fs.physical.PhysicalResourceImpl;
import gw.lang.UnstableAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@UnstableAPI
public class PhysicalDirectoryImpl
extends PhysicalResourceImpl
implements IDirectory {
    public PhysicalDirectoryImpl(ResourcePath path, IPhysicalFileSystem backingFileSystem) {
        super(path, backingFileSystem);
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public IDirectory dir(String relativePath) {
        ResourcePath absolutePath = this._path.join(relativePath);
        return new PhysicalDirectoryImpl(absolutePath, this._backingFileSystem);
    }

    @Override
    public IFile file(String path) {
        ResourcePath absolutePath = this._path.join(path);
        return new PhysicalFileImpl(absolutePath, this._backingFileSystem);
    }

    @Override
    public boolean mkdir() throws IOException {
        return this._backingFileSystem.mkdir(this._path);
    }

    @Override
    public List<? extends IDirectory> listDirs() {
        ArrayList<PhysicalDirectoryImpl> dirs = new ArrayList<PhysicalDirectoryImpl>();
        for (IFileMetadata iFileMetadata : this._backingFileSystem.listFiles(this._path)) {
            if (!iFileMetadata.isDir()) continue;
            dirs.add(new PhysicalDirectoryImpl(this._path.join(iFileMetadata.name()), this._backingFileSystem));
        }
        return dirs;
    }

    @Override
    public List<? extends IFile> listFiles() {
        ArrayList<PhysicalFileImpl> files = new ArrayList<PhysicalFileImpl>();
        for (IFileMetadata iFileMetadata : this._backingFileSystem.listFiles(this._path)) {
            if (!iFileMetadata.isFile()) continue;
            files.add(new PhysicalFileImpl(this._path.join(iFileMetadata.name()), this._backingFileSystem));
        }
        return files;
    }

    @Override
    public String relativePath(IResource resource) {
        return IDirectoryUtil.relativePath(this, resource);
    }

    @Override
    public boolean hasChildFile(String path) {
        IFile childFile = this.file(path);
        return childFile != null && childFile.exists();
    }

    @Override
    public boolean isAdditional() {
        return false;
    }
}

