/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.init;

import gw.fs.IFile;
import gw.lang.GosuShop;
import gw.lang.init.GosuRuntimeManifoldHost;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.ISourceFileHandle;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.host.IModule;
import manifold.api.host.RefreshKind;
import manifold.api.type.ClassType;
import manifold.api.type.ContributorKind;
import manifold.api.type.ISourceKind;
import manifold.api.type.ITypeManifold;
import manifold.api.type.TypeName;
import manifold.util.ManExceptionUtil;

public class GosuTypeManifold
implements ITypeManifold {
    private IModule _module;

    public void init(IModule module) {
        this._module = module;
    }

    public IModule getModule() {
        return this._module;
    }

    public ISourceKind getSourceKind() {
        return ISourceKind.Java;
    }

    public ContributorKind getContributorKind() {
        return ContributorKind.Primary;
    }

    public boolean isType(String fqn) {
        return TypeSystem.getByFullNameIfValidNoJava(fqn) instanceof IGosuClass;
    }

    public boolean isTopLevelType(String fqn) {
        if (!this.isType(fqn)) {
            return false;
        }
        IType type = TypeSystem.getByFullNameIfValidNoJava(fqn);
        return type != null && type.getEnclosingType() == null;
    }

    public boolean isPackage(String pkg) {
        return TypeSystem.getNamespace(pkg) != null;
    }

    public ClassType getClassType(String fqn) {
        IType type = TypeSystem.getByFullNameIfValidNoJava(fqn);
        return type == null ? null : ClassType.JavaClass;
    }

    public String getPackage(String fqn) {
        IType type = TypeSystem.getByFullNameIfValidNoJava(fqn);
        return type == null ? null : type.getNamespace();
    }

    public String contribute(JavaFileManager.Location location, String fqn, String existing, DiagnosticListener<JavaFileObject> errorHandler) {
        IGosuClass gsClass = (IGosuClass)this.findGosuClass(fqn);
        return GosuShop.generateJavaStub(gsClass);
    }

    public Collection<String> getAllTypeNames() {
        return Collections.emptyList();
    }

    public Collection<TypeName> getTypeNames(String pkg) {
        return GosuClassTypeLoader.getDefaultClassLoader().getTypeNames(pkg);
    }

    public List<manifold.api.fs.IFile> findFilesForType(String fqn) {
        URL url;
        IGosuClass gsClass = (IGosuClass)this.findGosuClass(fqn);
        if (gsClass == null) {
            return Collections.emptyList();
        }
        ISourceFileHandle sfh = gsClass.getSourceFileHandle();
        if (sfh == null) {
            return Collections.emptyList();
        }
        IFile file = sfh.getFile();
        if (file == null) {
            return Collections.emptyList();
        }
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonList(GosuRuntimeManifoldHost.get().getFileSystem().getIFile(url));
    }

    public void clear() {
    }

    public boolean handlesFileExtension(String s) {
        return false;
    }

    public boolean handlesFile(manifold.api.fs.IFile file) {
        return Arrays.stream(GosuClassTypeLoader.ALL_EXTS).anyMatch(ext -> ext.equalsIgnoreCase(file.getExtension()));
    }

    public String[] getTypesForFile(manifold.api.fs.IFile iFile) {
        return new String[0];
    }

    public RefreshKind refreshedFile(manifold.api.fs.IFile iFile, String[] strings, RefreshKind refreshKind) {
        return null;
    }

    public boolean isSelfCompile(String fqn) {
        return true;
    }

    public byte[] compile(String fqn) {
        try {
            return this.findGosuClass(fqn).compile();
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked((Throwable)new IOException("Error compiling '" + fqn + "'", e));
        }
    }

    private IType findGosuClass(String fqn) {
        return TypeSystem.getByFullNameIfValidNoJava(fqn);
    }
}

