/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import gw.lang.parser.IActivationContext;
import gw.lang.parser.IScope;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.StandardSymbolTable;
import java.util.Map;

public abstract class ThreadSafeSymbolTable
implements ISymbolTable {
    private ISymbolTable _defaultSymTable;

    public ThreadSafeSymbolTable(boolean bDefineCommonSymbols) {
        this._defaultSymTable = new StandardSymbolTable(bDefineCommonSymbols);
    }

    @Override
    public ISymbolTable copy() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.copy();
    }

    @Override
    public ISymbol getSymbol(CharSequence name) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.getSymbol(name);
    }

    @Override
    public void putSymbol(ISymbol symbol) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        targetSymTable.putSymbol(symbol);
        symbol.setDynamicSymbolTable(this);
    }

    @Override
    public ISymbol removeSymbol(CharSequence name) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.removeSymbol(name);
    }

    @Override
    public Map getSymbols() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.getSymbols();
    }

    @Override
    public Map getSymbols(int iScopeOffset, int iPrivateGlobalIndex) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.getSymbols(iScopeOffset, iPrivateGlobalIndex);
    }

    @Override
    public int getTotalSymbolCount() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.getTotalSymbolCount();
    }

    @Override
    public int getScopeCount() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.getScopeCount();
    }

    @Override
    public int getPrivateGlobalScopeCount() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.getPrivateGlobalScopeCount();
    }

    @Override
    public IScope pushScope() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.pushScope();
    }

    @Override
    public IScope pushScope(IScope scope) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.pushScope(scope);
    }

    @Override
    public void pushPrivateGlobalScope(IScope scope) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        targetSymTable.pushPrivateGlobalScope(scope);
    }

    @Override
    public void popGlobalScope(IScope scope) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        targetSymTable.popGlobalScope(scope);
    }

    @Override
    public IScope popScope() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.popScope();
    }

    @Override
    public IScope peekScope() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.peekScope();
    }

    @Override
    public IScope peekScope(int iPos) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.peekScope(iPos);
    }

    @Override
    public IScope popScope(IScope scope) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.popScope(scope);
    }

    @Override
    public IScope pushIsolatedScope(IActivationContext activationCtx) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.pushIsolatedScope(activationCtx);
    }

    @Override
    public void defineCommonSymbols() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        targetSymTable.defineCommonSymbols();
    }

    @Override
    public int getNextStackIndex() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.getNextStackIndex();
    }

    @Override
    public int getNextStackIndexForScope(IScope scope) {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.getNextStackIndexForScope(scope);
    }

    @Override
    public boolean hasIsolatedScope() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.hasIsolatedScope();
    }

    @Override
    public ISymbol getThisSymbolFromStackOrMap() {
        ISymbolTable targetSymTable = this.getTargetSymbolTable();
        return targetSymTable.getThisSymbolFromStackOrMap();
    }

    public ISymbolTable getTargetSymbolTable() {
        ISymbolTable threadLocalSymTable = this.getThreadLocalSymbolTable();
        if (threadLocalSymTable != null) {
            return threadLocalSymTable;
        }
        throw new RuntimeException("Thread-local symbol table is null");
    }

    @Override
    public boolean isSymbolWithinScope(ISymbol sym, IScope scope) {
        ISymbolTable symbolTable = this.getTargetSymbolTable();
        return symbolTable.isSymbolWithinScope(sym, scope);
    }

    @Override
    public IScope peekIsolatedScope() {
        ISymbolTable symbolTable = this.getTargetSymbolTable();
        return symbolTable.peekIsolatedScope();
    }

    protected ISymbolTable getDefaultSymbolTable() {
        return this._defaultSymTable;
    }

    public void clearDefaultSymbolTable() {
        this._defaultSymTable = new StandardSymbolTable(false);
    }

    protected abstract ISymbolTable getThreadLocalSymbolTable();
}

