/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.config.CommonServices;
import gw.util.GosuObjectUtil;
import gw.util.concurrent.LockingLazyVar;
import java.io.PrintWriter;
import java.io.StringWriter;

public class GosuExceptionUtil {
    private static final LockingLazyVar<IForceThrower> FORCE_THROWER = new LockingLazyVar<IForceThrower>(){

        @Override
        protected IForceThrower init() {
            return CommonServices.getGosuIndustrialPark().getForceThrower();
        }
    };

    public static Throwable findExceptionCause(Throwable e) {
        Throwable error = e;
        Throwable cause = e;
        while (error.getCause() != null && error.getCause() != error) {
            error = cause = error.getCause();
        }
        return cause;
    }

    public static void throwArgMismatchException(IllegalArgumentException exceptionToWrap, String featureName, Class[] actualParameters, Object[] args) {
        String argTypes = "(";
        for (int i = 0; i < actualParameters.length; ++i) {
            Class aClass = actualParameters[i];
            if (i > 0) {
                argTypes = argTypes + " ,";
            }
            argTypes = argTypes + aClass.getName();
        }
        argTypes = argTypes + ")";
        String rttTypes = "(";
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                rttTypes = rttTypes + " ,";
            }
            rttTypes = args[i] != null ? rttTypes + args[i].getClass().getName() : rttTypes + "null";
        }
        rttTypes = rttTypes + ")";
        throw new RuntimeException("Tried to pass values of types: " + rttTypes + " into " + featureName + " that takes types " + argTypes, exceptionToWrap);
    }

    public static <T extends Throwable> T findException(Class<T> exceptionTypeToFind, Throwable t) {
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            if (exceptionTypeToFind.isAssignableFrom(cause.getClass())) {
                return (T)cause;
            }
            if (cause != cause.getCause()) continue;
            return null;
        }
        return null;
    }

    public static RuntimeException convertToRuntimeException(Throwable t) {
        RuntimeException e = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
        return e;
    }

    public static String getStackTraceAsString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static RuntimeException forceThrow(Throwable t) {
        return GosuExceptionUtil.forceThrow(t, null);
    }

    public static RuntimeException forceThrow(Throwable t, String ctxInfo) {
        if (ctxInfo != null) {
            GosuExceptionUtil.addContextInfoImpl(t, ctxInfo);
        }
        FORCE_THROWER.get().throwException(t);
        return null;
    }

    public static <T extends Throwable> T addContextInfo(T t, String ctxInfo) {
        return GosuExceptionUtil.addContextInfoImpl(t, ctxInfo);
    }

    public static <T extends Throwable> T addContextInfoImpl(T t, String ctxInfo) {
        StackTraceElement[] currentStack = new RuntimeException().getStackTrace();
        StackTraceElement[] throwableStack = t.getStackTrace();
        for (int i = 0; i < throwableStack.length && i < currentStack.length; ++i) {
            StackTraceElement currentElt = currentStack[currentStack.length - i - 1];
            StackTraceElement throwableElt = throwableStack[throwableStack.length - i - 1];
            if (!GosuObjectUtil.equals(throwableElt.getClassName(), currentElt.getClassName()) && !GosuExceptionUtil.areMethodsEquals(throwableElt, currentElt) && !GosuExceptionUtil.areFilesEquals(throwableElt, currentElt) && throwableElt.getLineNumber() != currentElt.getLineNumber()) break;
            if (currentStack.length - i - 1 != 2) continue;
            throwableStack[throwableStack.length - i - 1] = throwableElt = new StackTraceElement(throwableElt.getClassName(), throwableElt.getMethodName(), throwableElt.getFileName() + ":" + throwableElt.getLineNumber() + ") - (" + ctxInfo, -1);
            t.setStackTrace(throwableStack);
            break;
        }
        return t;
    }

    private static boolean areMethodsEquals(StackTraceElement throwableElt, StackTraceElement currentElt) {
        if (throwableElt.getMethodName() == null) {
            return currentElt.getMethodName() == null;
        }
        String s = throwableElt.getMethodName();
        int index = s.indexOf(32);
        if (index >= 0) {
            s = s.substring(0, index);
        }
        return s.equals(currentElt.getMethodName());
    }

    private static boolean areFilesEquals(StackTraceElement throwableElt, StackTraceElement currentElt) {
        if (throwableElt.getFileName() == null) {
            return currentElt.getFileName() == null;
        }
        String s = throwableElt.getFileName();
        int index = s.indexOf(58);
        if (index >= 0) {
            s = s.substring(0, index);
        }
        return s.equals(currentElt.getFileName());
    }

    public static interface IForceThrower {
        public void throwException(Throwable var1);
    }
}

