/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.lang.reflect.interval.ISequenceable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public final class Rational
extends Number
implements ISequenceable<Rational, Rational, Void>,
Serializable {
    public static final Rational ZERO = new Rational(BigInteger.ZERO, BigInteger.ONE, true);
    public static final Rational ONE = new Rational(BigInteger.ONE, BigInteger.ONE, true);
    private static final int VERSION_1 = 1;
    private final BigInteger _numerator;
    private final BigInteger _denominator;
    private boolean _reduced;

    public static Rational get(int numerator) {
        return Rational.get(BigInteger.valueOf(numerator), BigInteger.ONE);
    }

    public static Rational get(int numerator, int denominator) {
        return Rational.get(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public static Rational get(long numerator) {
        return Rational.get(BigInteger.valueOf(numerator), BigInteger.ONE);
    }

    public static Rational get(long numerator, long denominator) {
        return Rational.get(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public static Rational get(float f) {
        return Rational.get(Float.toString(f));
    }

    public static Rational get(double d) {
        return Rational.get(Double.toString(d));
    }

    public static Rational get(BigInteger numerator) {
        return Rational.get(numerator, BigInteger.ONE);
    }

    public static Rational get(String decimal) {
        int iDiv = decimal.indexOf("/");
        if (iDiv > 0) {
            String numerator = decimal.substring(0, iDiv).trim();
            String denominator = decimal.substring(iDiv + 1).trim();
            boolean numeratorIsDecimal = Rational.isDecimalString(numerator);
            boolean denominatorIsDecimal = Rational.isDecimalString(denominator);
            if (numeratorIsDecimal) {
                if (denominatorIsDecimal) {
                    return Rational.get(new BigDecimal(numerator)).divide(Rational.get(new BigDecimal(denominator)));
                }
                return Rational.get(new BigDecimal(numerator)).divide(new BigInteger(denominator));
            }
            if (denominatorIsDecimal) {
                return Rational.get(new BigInteger(numerator)).divide(Rational.get(new BigDecimal(denominator)));
            }
            return Rational.get(new BigInteger(numerator), new BigInteger(denominator));
        }
        if (Rational.isDecimalString(decimal)) {
            return Rational.get(new BigDecimal(decimal));
        }
        return Rational.get(new BigInteger(decimal));
    }

    private static boolean isDecimalString(String decimal) {
        return decimal.indexOf(46) >= 0 || decimal.indexOf(101) > 0 || decimal.indexOf(69) > 0;
    }

    public static Rational get(BigDecimal bd) {
        BigInteger denominator;
        BigInteger numerator;
        int scale = bd.scale();
        if (scale >= 0) {
            numerator = bd.unscaledValue();
            denominator = BigInteger.TEN.pow(scale);
        } else {
            numerator = bd.unscaledValue().multiply(BigInteger.TEN.pow(-scale));
            denominator = BigInteger.ONE;
        }
        return Rational.get(numerator, denominator);
    }

    public static Rational get(BigInteger numerator, BigInteger denominator) {
        return Rational.get(numerator, denominator, false);
    }

    private static Rational get(BigInteger numerator, BigInteger denominator, boolean reduced) {
        if (numerator.equals(BigInteger.ZERO)) {
            return ZERO;
        }
        if (numerator.equals(BigInteger.ONE) && denominator.equals(BigInteger.ONE)) {
            return ONE;
        }
        return new Rational(numerator, denominator, reduced);
    }

    private Rational(BigInteger numerator, BigInteger denominator, boolean reduced) {
        if (denominator.signum() == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (numerator.signum() == 0) {
            this._numerator = BigInteger.ZERO;
            this._denominator = BigInteger.ONE;
        } else {
            if (denominator.signum() == -1) {
                numerator = numerator.negate();
                denominator = denominator.negate();
            }
            this._numerator = numerator;
            this._denominator = denominator;
        }
        this._reduced = reduced;
    }

    public Rational reduce() {
        if (!this._reduced) {
            BigInteger gcd = this._numerator.gcd(this._denominator);
            if (gcd.compareTo(BigInteger.ONE) > 0) {
                return Rational.get(this._numerator.divide(gcd), this._denominator.divide(gcd), true);
            }
            this._reduced = true;
        }
        return this;
    }

    public BigInteger getNumerator() {
        return this._numerator;
    }

    public BigInteger getDenominator() {
        return this._denominator;
    }

    public BigInteger wholePart() {
        return this._numerator.divide(this._denominator);
    }

    public Rational fractionPart() {
        BigInteger remainder = this._numerator.remainder(this._denominator);
        if (remainder.signum() == 0) {
            return ZERO;
        }
        return Rational.get(remainder, this._denominator);
    }

    @Override
    public int intValue() {
        return this._numerator.divide(this._denominator).intValue();
    }

    @Override
    public long longValue() {
        return this._numerator.divide(this._denominator).longValue();
    }

    @Override
    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    public BigInteger toBigInteger() {
        return this.toBigDecimal().toBigInteger();
    }

    public BigDecimal toBigDecimal() {
        return this.toBigDecimal(MathContext.DECIMAL128);
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        return this.equals(ZERO) ? BigDecimal.ZERO : new BigDecimal(this._numerator).divide(new BigDecimal(this._denominator), mc);
    }

    public boolean isInteger() {
        return this._denominator.equals(BigInteger.ONE);
    }

    public Rational add(int i) {
        return i == 0 ? this : this.add(Rational.get(i));
    }

    public Rational add(long l) {
        return l == 0L ? this : this.add(Rational.get(l));
    }

    public Rational add(float f) {
        return f == 0.0f ? this : this.add(Rational.get(f));
    }

    public Rational add(double d) {
        return d == 0.0 ? this : this.add(Rational.get(d));
    }

    public Rational add(BigInteger bg) {
        if (this.signum() == 0) {
            return Rational.get(bg);
        }
        if (bg.signum() == 0) {
            return this;
        }
        return bg.equals(BigInteger.ZERO) ? this : Rational.get(this._numerator.add(this._denominator.multiply(bg)), this._denominator);
    }

    public Rational add(BigDecimal bd) {
        return bd.signum() == 0 ? this : this.add(Rational.get(bd));
    }

    public Rational add(Rational rational) {
        BigInteger denominator;
        BigInteger numerator;
        if (rational.signum() == 0) {
            return this;
        }
        if (this.signum() == 0) {
            return rational;
        }
        if (this._denominator.equals(rational._denominator)) {
            numerator = this._numerator.add(rational._numerator);
            denominator = this._denominator;
        } else {
            numerator = this._numerator.multiply(rational._denominator).add(rational._numerator.multiply(this._denominator));
            denominator = this._denominator.multiply(rational._denominator);
        }
        return numerator.signum() == 0 ? ZERO : Rational.get(numerator, denominator);
    }

    public Rational subtract(int i) {
        return this.subtract(BigInteger.valueOf(i));
    }

    public Rational subtract(long l) {
        return this.subtract(BigInteger.valueOf(l));
    }

    public Rational subtract(float f) {
        return this.subtract(Rational.get(f));
    }

    public Rational subtract(double d) {
        return this.subtract(Rational.get(d));
    }

    public Rational subtract(BigInteger bi) {
        if (bi.signum() == 0) {
            return this;
        }
        if (this.signum() == 0) {
            return Rational.get(bi.negate());
        }
        return Rational.get(this._numerator.subtract(this._denominator.multiply(bi)), this._denominator);
    }

    public Rational subtract(BigDecimal bd) {
        return bd.signum() == 0 ? this : this.subtract(Rational.get(bd));
    }

    public Rational subtract(Rational rational) {
        BigInteger denominator;
        BigInteger numerator;
        if (rational.signum() == 0) {
            return this;
        }
        if (this.signum() == 0) {
            return rational.negate();
        }
        if (this._denominator.equals(rational._denominator)) {
            numerator = this._numerator.subtract(rational._numerator);
            denominator = this._denominator;
        } else {
            numerator = this._numerator.multiply(rational._denominator).subtract(rational._numerator.multiply(this._denominator));
            denominator = this._denominator.multiply(rational._denominator);
        }
        return numerator.signum() == 0 ? ZERO : Rational.get(numerator, denominator);
    }

    public Rational multiply(int i) {
        if (i == 0 || this.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(i));
    }

    public Rational multiply(long l) {
        if (l == 0L || this.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(l));
    }

    public Rational multiply(float f) {
        if (f == 0.0f || this.signum() == 0) {
            return ZERO;
        }
        return this.multiply(Rational.get(f));
    }

    public Rational multiply(double d) {
        if (d == 0.0 || this.signum() == 0) {
            return ZERO;
        }
        return this.multiply(Rational.get(d));
    }

    public Rational multiply(BigInteger bi) {
        if (this.signum() == 0 || bi.signum() == 0) {
            return ZERO;
        }
        return Rational.get(bi.multiply(this._numerator), this._denominator);
    }

    public Rational multiply(BigDecimal bd) {
        if (this.signum() == 0 || bd.signum() == 0) {
            return ZERO;
        }
        return this.multiply(Rational.get(bd));
    }

    public Rational multiply(Rational rational) {
        if (this.signum() == 0 || rational.signum() == 0) {
            return ZERO;
        }
        return Rational.get(this._numerator.multiply(rational._numerator), this._denominator.multiply(rational._denominator));
    }

    public Rational divide(int i) {
        return this.divide(BigInteger.valueOf(i));
    }

    public Rational divide(long l) {
        return this.divide(BigInteger.valueOf(l));
    }

    public Rational divide(float f) {
        return this.divide(Rational.get(f));
    }

    public Rational divide(double d) {
        return this.divide(Rational.get(d));
    }

    public Rational divide(BigInteger bi) {
        if (bi.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.signum() == 0) {
            return ZERO;
        }
        return Rational.get(this._numerator, this._denominator.multiply(bi));
    }

    public Rational divide(BigDecimal bd) {
        if (bd.signum() == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.signum() == 0) {
            return ZERO;
        }
        return this.divide(Rational.get(bd));
    }

    public Rational divide(Rational rational) {
        if (rational.equals(ZERO)) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.signum() == 0) {
            return ZERO;
        }
        return this.multiply(rational.invert());
    }

    public Rational modulo(int i) {
        return this.modulo(BigInteger.valueOf(i));
    }

    public Rational modulo(long l) {
        return this.modulo(BigInteger.valueOf(l));
    }

    public Rational modulo(float f) {
        return this.modulo(Rational.get(f));
    }

    public Rational modulo(double d) {
        return this.modulo(Rational.get(d));
    }

    public Rational modulo(BigInteger bi) {
        if (bi.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Divide by zero");
        }
        return this.modulo(Rational.get(bi));
    }

    public Rational modulo(BigDecimal bd) {
        if (bd.signum() == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        return this.modulo(Rational.get(bd));
    }

    public Rational modulo(Rational rational) {
        Rational quotient = this.divide(rational);
        return this.subtract(rational.multiply(quotient.toBigInteger())).abs();
    }

    public Rational negate() {
        return Rational.get(this._numerator.negate(), this._denominator);
    }

    public Rational invert() {
        return Rational.get(this._denominator, this._numerator);
    }

    public Rational abs() {
        return this.signum() >= 0 ? this : this.negate();
    }

    public Rational pow(int exponent) {
        if (this.signum() == 0) {
            return exponent == 0 ? ONE : this;
        }
        return Rational.get(this._numerator.pow(exponent), this._denominator.pow(exponent));
    }

    public Rational root(int iRoot) {
        return this.root(iRoot, 10);
    }

    public Rational root(int n, int scale) {
        if (this.signum() < 0) {
            throw new IllegalArgumentException("nth root can only be calculated for positive numbers");
        }
        if (this.signum() == 0) {
            return ZERO;
        }
        BigInteger biScale = BigDecimal.ONE.movePointRight(scale).toBigInteger();
        Rational small = Rational.get(BigInteger.ONE, biScale);
        Rational rRoot = Rational.get(n);
        Rational prev = this;
        Rational x = this.divide(rRoot);
        while (x.subtract(prev).abs().compareTo(small) > 0) {
            prev = x;
            x = Rational.get(n - 1).multiply(x).add(this.divide(x.pow(n - 1))).divide(rRoot);
        }
        return x;
    }

    public Rational sqrt() {
        return Rational.get(Math.sqrt(this.doubleValue()));
    }

    @Override
    public Rational nextInSequence(Rational step, Void unit) {
        step = step == null ? ONE : step;
        return this.add(step);
    }

    @Override
    public Rational nextNthInSequence(Rational step, Void unit, int iIndex) {
        step = step == null ? ONE : step;
        return this.add(step.multiply(iIndex));
    }

    @Override
    public Rational previousInSequence(Rational step, Void unit) {
        step = step == null ? ONE : step;
        return this.subtract(step);
    }

    @Override
    public Rational previousNthInSequence(Rational step, Void unit, int iIndex) {
        step = step == null ? ONE : step;
        return this.subtract(step.multiply(iIndex));
    }

    @Override
    public int compareTo(Rational that) {
        int thatSign;
        int thisSign = this.signum();
        if (thisSign != (thatSign = that.signum()) || thisSign == 0) {
            return thisSign - thatSign;
        }
        BigInteger crossNum = this._numerator.multiply(that._denominator);
        BigInteger crossDen = this._denominator.multiply(that._numerator);
        return crossNum.compareTo(crossDen);
    }

    public int signum() {
        return this._numerator.signum();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Rational rational = (Rational)that;
        if (!this._denominator.equals(rational._denominator)) {
            return false;
        }
        return this._numerator.equals(rational._numerator);
    }

    public int hashCode() {
        int result = this._numerator.hashCode();
        result = 31 * result + this._denominator.hashCode();
        return result;
    }

    public String toFractionString() {
        if (!this._reduced) {
            return this.reduce().toFractionString();
        }
        return this._numerator + "/" + this._denominator;
    }

    public String toMixedString() {
        if (!this._reduced) {
            return this.reduce().toMixedString();
        }
        if (this._denominator.equals(BigInteger.ONE)) {
            return this._numerator.toString();
        }
        BigInteger whole = this.wholePart();
        if (whole.signum() == 0) {
            return this.fractionPart().toFractionString();
        }
        return whole + " " + this.fractionPart().abs().toFractionString();
    }

    public String toDecimalString() {
        return this.toBigDecimal().toString();
    }

    public String toPlainDecimalString() {
        return this.toBigDecimal().toPlainString();
    }

    public String toString() {
        return this._numerator + " / " + this._denominator;
    }

    private Object writeReplace() {
        return new Serializer(this);
    }

    private static class Serializer
    implements Externalizable {
        private Rational _rational;

        public Serializer() {
        }

        public Serializer(Rational rational) {
            this._rational = rational;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeObject(this._rational._numerator);
            out.writeObject(this._rational._denominator);
            out.writeBoolean(this._rational._reduced);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            switch (version) {
                case 1: {
                    BigInteger numerator = (BigInteger)in.readObject();
                    BigInteger denominator = (BigInteger)in.readObject();
                    boolean reduced = in.readBoolean();
                    this._rational = Rational.get(numerator, denominator, reduced);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported version: " + version);
                }
            }
        }

        Object readResolve() {
            return this._rational;
        }
    }
}

