/*
 * Decompiled with CFR 0.152.
 */
package gw.lang;

import gw.config.CommonServices;
import gw.lang.GosuShop;
import gw.lang.GosuVersion;
import gw.lang.ProgramFileContext;
import gw.lang.gosuc.GosucUtil;
import gw.lang.init.ClasspathToGosuPathEntryUtil;
import gw.lang.init.GosuInitialization;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IGosuProgramParser;
import gw.lang.parser.IParseResult;
import gw.lang.parser.ParserOptions;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuExceptionUtil;
import gw.util.OSPlatform;
import gw.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import sun.misc.URLClassPath;

public class Gosu {
    public static final String NOPACKAGE = "_nopackage_";
    public static final String GOSU_SCRATCHPAD_FQN = "_nopackage_.GosuScratchpad";
    public static final String JAR_REPO_DIR = "JAR-REPO";
    public static final String JAR_REPO_TXT = "jar-repo.txt";
    public static final String FAILED = "   FAILED: ";
    public static final String SUCCESS = "   SUCCESS ";
    private static List<File> _classpath;
    private static File _script;
    private static List<String> _rawArgs;

    public static void main(String[] args) {
        Gosu.start(args);
    }

    private static void checkArgsLength(int i, int length) {
        if (i >= length) {
            Gosu.showHelpAndQuit();
        }
    }

    private static void start(String[] args) {
        try {
            if (args.length == 0) {
                Gosu.launchEditor();
                return;
            }
            int i = 0;
            Gosu.checkArgsLength(i, args.length);
            String cpValue = null;
            boolean cmdLineCP = false;
            if (args[i].equals("-checkedArithmetic")) {
                Gosu.checkArgsLength(++i, args.length);
                System.setProperty("checkedArithmetic", "true");
            }
            if (args[i].equals("-classpath")) {
                cmdLineCP = true;
                Gosu.checkArgsLength(i += 2, args.length);
                cpValue = args[i - 1];
            }
            switch (args[i]) {
                case "-fqn": {
                    List<File> classpath = Gosu.makeClasspath(cpValue, "", cmdLineCP);
                    Gosu.init(classpath);
                    Gosu.runWithType(args[i + 1], Gosu.collectArgs(i + 2, args));
                    break;
                }
                case "-e": {
                    List<File> classpath = Gosu.makeClasspath(cpValue, "", cmdLineCP);
                    Gosu.init(classpath);
                    Gosu.runWithInlineScript(args[i + 1], Gosu.collectArgs(i + 2, args));
                    break;
                }
                default: {
                    File script = new File(args[i]);
                    if (!script.isFile() || !script.exists()) {
                        Gosu.showHelpAndQuit();
                    }
                    if (cpValue == null) {
                        cpValue = Gosu.extractClassPathFromSrc(script.getAbsolutePath());
                    }
                    List<File> classpath = Gosu.makeClasspath(cpValue, script.getAbsoluteFile().getParent(), cmdLineCP);
                    Gosu.init(classpath);
                    Gosu.runWithFile(script, Gosu.collectArgs(i + 1, args));
                    break;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    private static void launchEditor() throws Exception {
        Class<?> cls = Class.forName("editor.RunMe");
        Method m = cls.getMethod("launchEditor", new Class[0]);
        m.invoke(null, new Object[0]);
    }

    private static List<String> collectArgs(int i, String[] args) {
        ArrayList<String> scriptArgs = new ArrayList<String>();
        if (args != null) {
            while (i < args.length) {
                scriptArgs.add(args[i]);
                ++i;
            }
        }
        return scriptArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String extractClassPathFromSrc(String file) {
        BufferedReader br = null;
        String ret = null;
        try {
            int e;
            int b;
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()).trim().isEmpty()) {
            }
            if (line.startsWith("classpath") && (b = line.indexOf(34)) != -1 && (e = line.indexOf(34, b + 1)) != -1) {
                ret = line.substring(b + 1, e);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ret;
    }

    private static List<File> makeClasspath(String cpValue, String scriptRoot, boolean cmdLineCP) {
        ArrayList<File> cp = new ArrayList<File>();
        if (cpValue != null) {
            StringTokenizer st = new StringTokenizer(cpValue, ",", false);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.contains(":") && !OSPlatform.isWindows() || s.contains(";")) {
                    StringTokenizer sysTok = new StringTokenizer(cpValue, File.pathSeparator, false);
                    while (sysTok.hasMoreTokens()) {
                        s = sysTok.nextToken();
                        String pathname = cmdLineCP ? s : scriptRoot + File.separatorChar + s;
                        cp.add(new File(pathname));
                    }
                    continue;
                }
                String pathname = cmdLineCP ? s : scriptRoot + File.separatorChar + s;
                cp.add(new File(pathname));
            }
        }
        return cp;
    }

    private static String makeFqn(File file) {
        String path = file.getAbsolutePath();
        int srcIndex = path.indexOf("src" + File.separatorChar);
        if (srcIndex >= 0) {
            String fqn = path.substring(srcIndex + 4).replace(File.separatorChar, '.');
            return fqn.substring(0, fqn.lastIndexOf(46));
        }
        String fqn = file.getName();
        fqn = "_nopackage_." + fqn.substring(0, fqn.lastIndexOf(46)).replace(" ", "");
        return fqn;
    }

    public static void setClasspath(List<File> classpath) {
        ClassLoader loader;
        classpath = new ArrayList<File>(classpath);
        Gosu.removeDups(classpath);
        if (classpath.equals(_classpath)) {
            return;
        }
        _classpath = classpath;
        ClassLoader classLoader = loader = TypeSystem.getCurrentModule() == null ? CommonServices.getEntityAccess().getPluginClassLoader() : TypeSystem.getGosuClassLoader().getActualLoader();
        if (loader instanceof URLClassLoader) {
            Method addURL = Gosu.getAddUrlMethod();
            for (File entry : classpath) {
                try {
                    addURL.invoke((Object)loader, entry.toURI().toURL());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Gosu.reinitGosu(classpath);
        TypeSystem.refresh(true);
    }

    private static Method getAddUrlMethod() {
        Method addURL;
        try {
            addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURL.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return addURL;
    }

    public static List<File> getClasspath() {
        return _classpath;
    }

    private static void reinitGosu(List<File> classpath) {
        try {
            GosuInitialization.instance(TypeSystem.getExecutionEnvironment()).reinitializeRuntime(ClasspathToGosuPathEntryUtil.convertClasspathToGosuPathEntries(classpath), new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void removeDups(List<File> classpath) {
        for (int i = classpath.size() - 1; i >= 0; --i) {
            File f = classpath.get(i);
            classpath.remove(i);
            if (classpath.contains(f)) continue;
            classpath.add(i, f);
        }
    }

    public static void init() {
        Gosu.init(null);
    }

    public static void init(List<File> classpath) {
        ArrayList<File> combined = new ArrayList<File>();
        if (classpath != null) {
            combined.addAll(classpath);
        }
        combined.addAll(Gosu.deriveClasspathFrom(Gosu.class));
        Gosu.setClasspath(combined);
    }

    public static boolean bootstrapGosuWhenInitiatedViaClassfile() {
        if (GosuInitialization.isAnythingInitialized() && GosuInitialization.instance(TypeSystem.getExecutionEnvironment()).isInitialized()) {
            return false;
        }
        Gosu.init();
        return true;
    }

    static void showHelpAndQuit() {
        System.out.println("Gosu version: " + Gosu.getVersion() + "\nUsage:\n    gosu [-checkedArithmetic] [-classpath 'entry1,entry2...'] program.gsp [args...]\n    gosu [-checkedArithmetic] [-classpath 'entry1,entry2...'] -e 'inline script' [args...]\n");
        System.exit(1);
    }

    public static List<File> deriveClasspathFrom(Class clazz) {
        LinkedList<File> ll = new LinkedList<File>();
        for (ClassLoader loader = clazz.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                try {
                    File file = new File(url.toURI());
                    if (!file.exists()) continue;
                    ll.add(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Gosu.addBootstrapClasses(ll);
        return ll;
    }

    private static void addBootstrapClasses(List<File> ll) {
        try {
            Method m;
            try {
                m = ClassLoader.class.getDeclaredMethod("getBootstrapClassPath", new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                Gosu.getBootstrapForIbm(ll);
                return;
            }
            m.setAccessible(true);
            URLClassPath bootstrapClassPath = (URLClassPath)m.invoke(null, new Object[0]);
            for (URL url : bootstrapClassPath.getURLs()) {
                try {
                    File file = new File(url.toURI());
                    if (!file.exists() || ll.contains(file)) continue;
                    ll.add(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void getBootstrapForIbm(List<File> ll) {
        List<String> ibmClasspath = GosucUtil.getJreJars();
        ibmClasspath.stream().forEach(e -> ll.add(new File((String)e)));
    }

    public static GosuVersion getVersion() {
        InputStream in = Gosu.class.getClassLoader().getResourceAsStream("gw/lang/gosu-version.properties");
        if (in == null) {
            return new GosuVersion(0, 0);
        }
        Reader reader = StreamUtil.getInputStreamReader(in);
        return GosuVersion.parse(reader);
    }

    public static File getCurrentProgram() {
        return _script;
    }

    public static List<String> getRawArgs() {
        return _rawArgs;
    }

    public static void setRawArgs(String[] args) {
        _rawArgs = Gosu.collectArgs(1, args);
    }

    private static int runWithType(String fqn, List<String> args) throws Exception {
        _rawArgs = args;
        IType type = TypeSystem.getByFullName(fqn);
        if (type instanceof IGosuProgram) {
            Object result = ((IGosuProgram)type).getProgramInstance().evaluate(null);
            if (result != null) {
                System.out.println(result);
            }
        } else {
            IMethodInfo mainMethod = Gosu.hasStaticMain(type);
            if (mainMethod != null) {
                ReflectUtil.invokeStaticMethod(type.getName(), "main", new Object[]{new String[0]});
            } else if (type instanceof IGosuClass) {
                Gosu.runTest((IGosuClass)type);
            } else {
                throw new UnsupportedOperationException("Don't know how to run: " + fqn);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTest(IGosuClass gsType) throws Exception {
        Class cls = gsType.getBackingClass();
        Object instance = cls.newInstance();
        Gosu.runNamedOrAnnotatedMethod(instance, "beforeClass", "org.junit.BeforeClass");
        for (Method m : cls.getMethods()) {
            if (!Gosu.isTestMethod(m)) continue;
            Gosu.runNamedOrAnnotatedMethod(instance, "beforeMethod", "org.junit.Before");
            try {
                System.out.println(" - " + m.getName());
                m.invoke(instance, new Object[0]);
                System.out.println(SUCCESS);
            }
            catch (InvocationTargetException e) {
                Throwable cause = GosuExceptionUtil.findExceptionCause(e);
                if (cause instanceof AssertionError) {
                    System.out.println(FAILED + cause.getClass().getSimpleName() + " : " + cause.getMessage());
                    String lines = Gosu.findPertinentLines(gsType, cause);
                    System.out.println(lines);
                    continue;
                }
                throw GosuExceptionUtil.forceThrow(cause);
            }
            finally {
                Gosu.runNamedOrAnnotatedMethod(instance, "afterMethod", "org.junit.After");
            }
        }
        Gosu.runNamedOrAnnotatedMethod(instance, "afterClass", "org.junit.AfterClass");
    }

    private static boolean isTestMethod(Method m) throws Exception {
        int modifiers = m.getModifiers();
        return Modifier.isPublic(modifiers) && (m.getName().startsWith("test") || Gosu.hasAnnotation(m, "org.junit.Test")) && m.getParameters().length == 0;
    }

    private static void runNamedOrAnnotatedMethod(Object instance, String methodName, String annoName) throws Exception {
        for (Method m : instance.getClass().getMethods()) {
            if (m.getName().equals(methodName)) {
                m.invoke(instance, new Object[0]);
                return;
            }
            for (Annotation anno : m.getAnnotations()) {
                if (!anno.annotationType().getName().equals(annoName)) continue;
                m.invoke(instance, new Object[0]);
                return;
            }
        }
    }

    private static boolean hasAnnotation(Method m, String name) throws Exception {
        for (Annotation anno : m.getAnnotations()) {
            if (!anno.annotationType().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static IMethodInfo hasStaticMain(IType type) {
        IMethodInfo main = type.getTypeInfo().getMethod("main", JavaTypes.STRING().getArrayType());
        if (main != null && main.isStatic() && main.getReturnType() == JavaTypes.pVOID()) {
            return main;
        }
        return null;
    }

    private static void runWithFile(File script, List<String> args) throws IOException, ParseResultsException {
        _script = script;
        _rawArgs = args;
        byte[] bytes = StreamUtil.getContent(new BufferedInputStream(new FileInputStream(script)));
        String content = StreamUtil.toString(bytes);
        ProgramFileContext ctx = new ProgramFileContext(script, Gosu.makeFqn(script));
        IGosuProgramParser programParser = GosuParserFactory.createProgramParser();
        ParserOptions options = new ParserOptions().withFileContext(ctx);
        IParseResult result = programParser.parseExpressionOrProgram(content, new StandardSymbolTable(true), options);
        IGosuProgram program = result.getProgram();
        Object ret = program.getProgramInstance().evaluate(null);
        IType expressionType = result.getType();
        if (expressionType != null && !JavaTypes.pVOID().equals(expressionType)) {
            GosuShop.print(ret);
        }
    }

    private static void runWithInlineScript(String script, List<String> args) throws IOException, ParseResultsException {
        _script = null;
        _rawArgs = args;
        IGosuProgramParser programParser = GosuParserFactory.createProgramParser();
        IParseResult result = programParser.parseExpressionOrProgram(script, new StandardSymbolTable(true), new ParserOptions());
        IGosuProgram program = result.getProgram();
        Object ret = program.getProgramInstance().evaluate(null);
        IType expressionType = result.getType();
        if (expressionType != null && !JavaTypes.pVOID().equals(expressionType)) {
            GosuShop.print(ret);
        }
    }

    private static String findPertinentLines(IGosuClass gsType, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] trace = cause.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement elem = trace[i];
            if (!elem.getClassName().equals(gsType.getName())) continue;
            sb.append("     at ").append(elem.toString()).append("\n");
        }
        return sb.toString();
    }
}

