/*
 * Decompiled with CFR 0.152.
 */
package gw.date;

import gw.config.CommonServices;
import java.util.Calendar;
import java.util.Date;

public class GosuDateUtil {
    public static Date addSeconds(Date date, int iSeconds) {
        Calendar dateTime = GosuDateUtil.dateToCalendar(date);
        dateTime.add(13, iSeconds);
        return dateTime.getTime();
    }

    public static Date addMinutes(Date date, int iMinutes) {
        Calendar dateTime = GosuDateUtil.dateToCalendar(date);
        dateTime.add(12, iMinutes);
        return dateTime.getTime();
    }

    public static Date addHours(Date date, int iHours) {
        Calendar dateTime = GosuDateUtil.dateToCalendar(date);
        dateTime.add(10, iHours);
        return dateTime.getTime();
    }

    public static Date addDays(Date date, int iDays) {
        Calendar dateTime = GosuDateUtil.dateToCalendar(date);
        dateTime.add(5, iDays);
        return dateTime.getTime();
    }

    public static Date addWeeks(Date date, int iWeeks) {
        Calendar dateTime = GosuDateUtil.dateToCalendar(date);
        dateTime.add(3, iWeeks);
        return dateTime.getTime();
    }

    public static Date addMonths(Date date, int iMonths) {
        Calendar dateTime = GosuDateUtil.dateToCalendar(date);
        dateTime.add(2, iMonths);
        return dateTime.getTime();
    }

    public static Date addYears(Date date, int iYears) {
        Calendar dateTime = GosuDateUtil.dateToCalendar(date);
        dateTime.add(1, iYears);
        return dateTime.getTime();
    }

    public static int getSecond(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(13);
    }

    public static int getMinute(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(12);
    }

    public static int getHour(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(10);
    }

    public static boolean isAM(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(9) == 0;
    }

    public static boolean isPM(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(9) == 1;
    }

    public static int getHourOfDay(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(11);
    }

    public static int getDayOfWeek(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(7);
    }

    public static int getDayOfMonth(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(5);
    }

    public static int getDayOfYear(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(6);
    }

    public static int getWeekOfMonth(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(4);
    }

    public static int getWeekOfYear(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(3);
    }

    public static int getMonth(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(2) + 1;
    }

    public static int getYear(Date date) {
        return GosuDateUtil.dateToCalendar(date).get(1);
    }

    private static Calendar dateToCalendar(Date date) {
        if (date == null) {
            throw new NullPointerException("Null date");
        }
        Calendar dateTime = Calendar.getInstance(CommonServices.getEntityAccess().getTimeZone());
        dateTime.setTime(date);
        return dateTime;
    }
}

