/*
 * Decompiled with CFR 0.152.
 */
package gw.fs.jar;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IDirectoryUtil;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.fs.ResourcePath;
import gw.fs.jar.IJarFileDirectory;
import gw.fs.jar.JarEntryDirectoryImpl;
import gw.fs.jar.JarEntryFileImpl;
import gw.lang.UnstableAPI;
import gw.util.DynamicArray;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

@UnstableAPI
public class JarFileDirectoryImpl
implements IJarFileDirectory {
    private File _file;
    private JarFile _jarFile;
    private Map<String, IResource> _resources = new HashMap<String, IResource>();
    private List<IDirectory> _childDirs;
    private List<IFile> _childFiles = new ArrayList<IFile>();

    public JarFileDirectoryImpl(File file) {
        this._childDirs = new ArrayList<IDirectory>();
        this._file = file;
        if (file.exists()) {
            try {
                this._jarFile = new JarFile(file);
                Enumeration<JarEntry> entries = this._jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry e = entries.nextElement();
                    this.processJarEntry(e);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void processJarEntry(JarEntry e) {
        DynamicArray<String> pathComponents = IDirectoryUtil.splitPath(e.getName());
        if (pathComponents.isEmpty()) {
            return;
        }
        if (pathComponents.size() == 1) {
            String name = (String)pathComponents.get(0);
            if (e.isDirectory()) {
                JarEntryDirectoryImpl resource = this.getOrCreateDirectory(name);
                resource.setEntry(e);
            } else {
                JarEntryFileImpl resource = this.getOrCreateFile(name);
                resource.setEntry(e);
            }
        } else {
            JarEntryDirectoryImpl parentDirectory = this.getOrCreateDirectory((String)pathComponents.get(0));
            for (int i = 1; i < pathComponents.size() - 1; ++i) {
                parentDirectory = parentDirectory.getOrCreateDirectory((String)pathComponents.get(i));
            }
            if (e.isDirectory()) {
                JarEntryDirectoryImpl leafDir = parentDirectory.getOrCreateDirectory((String)pathComponents.get(pathComponents.size() - 1));
                leafDir.setEntry(e);
            } else {
                JarEntryFileImpl leafFile = parentDirectory.getOrCreateFile((String)pathComponents.get(pathComponents.size() - 1));
                leafFile.setEntry(e);
            }
        }
    }

    public InputStream getInputStream(JarEntry entry) throws IOException {
        return this._jarFile.getInputStream(entry);
    }

    @Override
    public JarEntryDirectoryImpl getOrCreateDirectory(String relativeName) {
        IResource resource = this._resources.get(relativeName);
        if (resource instanceof IFile) {
            throw new UnsupportedOperationException("The requested resource " + relativeName + " is now being accessed as a directory, but was previously accessed as a file.");
        }
        JarEntryDirectoryImpl result = (JarEntryDirectoryImpl)resource;
        if (result == null) {
            result = new JarEntryDirectoryImpl(relativeName, this, this);
            this._resources.put(relativeName, result);
            this._childDirs.add(result);
        }
        return result;
    }

    @Override
    public JarEntryFileImpl getOrCreateFile(String relativeName) {
        IResource resource = this._resources.get(relativeName);
        if (resource instanceof IDirectory) {
            throw new UnsupportedOperationException("The requested resource " + relativeName + " is now being accessed as a file, but was previously accessed as a directory.");
        }
        JarEntryFileImpl result = (JarEntryFileImpl)resource;
        if (result == null) {
            result = new JarEntryFileImpl(relativeName, this, this);
            this._resources.put(relativeName, result);
            this._childFiles.add(result);
        }
        return result;
    }

    @Override
    public IDirectory dir(String relativePath) {
        return IDirectoryUtil.dir(this, relativePath);
    }

    @Override
    public IFile file(String path) {
        return IDirectoryUtil.file(this, path);
    }

    @Override
    public boolean mkdir() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends IDirectory> listDirs() {
        ArrayList<IDirectory> results = new ArrayList<IDirectory>();
        for (IDirectory child : this._childDirs) {
            if (!child.exists()) continue;
            results.add(child);
        }
        return results;
    }

    @Override
    public List<? extends IFile> listFiles() {
        ArrayList<IFile> results = new ArrayList<IFile>();
        for (IFile child : this._childFiles) {
            if (!child.exists()) continue;
            results.add(child);
        }
        return results;
    }

    @Override
    public String relativePath(IResource resource) {
        return IDirectoryUtil.relativePath(this, resource);
    }

    @Override
    public IDirectory getParent() {
        File parentFile = this._file.getParentFile();
        if (parentFile != null) {
            return CommonServices.getFileSystem().getIDirectory(parentFile);
        }
        return null;
    }

    @Override
    public String getName() {
        return this._file.getName();
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public boolean delete() throws IOException {
        return this._file.delete();
    }

    @Override
    public URI toURI() {
        return this._file.toURI();
    }

    @Override
    public ResourcePath getPath() {
        return ResourcePath.parse(this._file.getAbsolutePath());
    }

    @Override
    public boolean isChildOf(IDirectory dir) {
        return dir.equals(this.getParent());
    }

    @Override
    public boolean isDescendantOf(IDirectory dir) {
        return dir.getPath().isDescendant(this.getPath());
    }

    @Override
    public File toJavaFile() {
        return this._file;
    }

    public JarFile getJarFile() {
        return this._jarFile;
    }

    @Override
    public boolean isJavaFile() {
        return true;
    }

    @Override
    public boolean isInJar() {
        return true;
    }

    @Override
    public boolean create() {
        return false;
    }

    public String toString() {
        return this.toJavaFile().getPath();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JarFileDirectoryImpl) {
            return this.getPath().equals(((JarFileDirectoryImpl)obj).getPath());
        }
        return false;
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public boolean hasChildFile(String path) {
        IFile childFile = this.file(path);
        return childFile != null && childFile.exists();
    }

    @Override
    public boolean isAdditional() {
        return false;
    }
}

