/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.Modifier;
import java.util.List;

public interface IRelativeTypeInfo
extends ITypeInfo {
    public static final int Accessibility_Size = Accessibility.values().length;

    public Accessibility getAccessibilityForType(IType var1);

    public List<? extends IPropertyInfo> getProperties(IType var1);

    public IPropertyInfo getProperty(IType var1, CharSequence var2);

    public MethodList getMethods(IType var1);

    public IMethodInfo getMethod(IType var1, CharSequence var2, IType ... var3);

    public List<? extends IConstructorInfo> getConstructors(IType var1);

    public IConstructorInfo getConstructor(IType var1, IType[] var2);

    public List<? extends IPropertyInfo> getDeclaredProperties();

    public List<? extends IMethodInfo> getDeclaredMethods();

    public List<? extends IConstructorInfo> getDeclaredConstructors();

    public static enum Accessibility {
        NONE{

            @Override
            public boolean isAccessible(int modifiers) {
                return false;
            }
        }
        ,
        PUBLIC{

            @Override
            public boolean isAccessible(int modifiers) {
                return Modifier.isPublic(modifiers);
            }
        }
        ,
        PROTECTED{

            @Override
            public boolean isAccessible(int modifiers) {
                return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
            }
        }
        ,
        INTERNAL{

            @Override
            public boolean isAccessible(int modifiers) {
                return !Modifier.isPrivate(modifiers);
            }
        }
        ,
        PRIVATE{

            @Override
            public boolean isAccessible(int modifiers) {
                return true;
            }
        };


        public abstract boolean isAccessible(int var1);

        public static Accessibility fromModifiers(int iModifiers) {
            if (Modifier.isPublic(iModifiers)) {
                return PUBLIC;
            }
            if (Modifier.isProtected(iModifiers)) {
                return PROTECTED;
            }
            if (Modifier.isInternal(iModifiers)) {
                return INTERNAL;
            }
            if (Modifier.isPrivate(iModifiers)) {
                return PRIVATE;
            }
            return PUBLIC;
        }

        public int toModifier() {
            switch (this) {
                case PUBLIC: {
                    return 1;
                }
                case PROTECTED: {
                    return 4;
                }
                case INTERNAL: {
                    return 524288;
                }
                case PRIVATE: {
                    return 2;
                }
                case NONE: {
                    return -1;
                }
            }
            throw new IllegalStateException();
        }

        public boolean isAccessible(Accessibility acc) {
            return this.isAccessible(acc.toModifier());
        }
    }
}

