/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.config.BaseService;
import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.TypeName;
import gw.lang.reflect.module.IModule;
import gw.util.GosuClassUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import manifold.api.type.TypeName;

public abstract class TypeLoaderBase
extends BaseService
implements ITypeLoader {
    protected IModule _module;
    protected Set<String> _typeNames;

    protected TypeLoaderBase() {
        this(TypeSystem.getCurrentModule());
    }

    protected TypeLoaderBase(IModule module) {
        this._module = module;
    }

    @Override
    public IModule getModule() {
        return this._module;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean handlesFile(IFile file) {
        return false;
    }

    @Override
    public boolean handlesDirectory(IDirectory dir) {
        return false;
    }

    @Override
    public String getNamespaceForDirectory(IDirectory dir) {
        return null;
    }

    @Override
    public String[] getTypesForFile(IFile file) {
        return NO_TYPES;
    }

    @Override
    public RefreshKind refreshedFile(IFile file, String[] types, RefreshKind kind) {
        return kind;
    }

    @Override
    public URL getResource(String name) {
        return null;
    }

    @Override
    public final void refreshedTypes(RefreshRequest request) {
        if (this.shouldCacheTypeNames()) {
            this.getAllTypeNames();
            if (request.kind == RefreshKind.CREATION) {
                for (String type : request.types) {
                    this._typeNames.add(type);
                }
            } else if (request.kind == RefreshKind.DELETION) {
                for (String type : request.types) {
                    this._typeNames.remove(type);
                }
            } else if (request.kind == RefreshKind.MODIFICATION) {
                for (String type : request.types) {
                    this._typeNames.add(type);
                }
            }
        } else {
            this.clearTypeNames();
        }
        this.refreshedTypesImpl(request);
    }

    protected void refreshedTypesImpl(RefreshRequest request) {
    }

    @Override
    public final void refreshed() {
        this.clearTypeNames();
        this.refreshedImpl();
    }

    protected void clearTypeNames() {
        this._typeNames = null;
    }

    protected void refreshedImpl() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for module " + this.getModule().getName();
    }

    @Override
    public Set<TypeName> getTypeNames(String namespace) {
        if (this.hasNamespace(namespace)) {
            return TypeLoaderBase.getTypeNames(namespace, this);
        }
        return Collections.emptySet();
    }

    public static Set<TypeName> getTypeNames(String parentNamespace, ITypeLoader loader) {
        HashSet<TypeName> typeNames = new HashSet<TypeName>();
        for (CharSequence charSequence : loader.getAllTypeNames()) {
            String typeName = charSequence.toString();
            String packageName = GosuClassUtil.getPackage(typeName);
            if (!packageName.equals(parentNamespace)) continue;
            typeNames.add(new TypeName(typeName, loader, TypeName.Kind.TYPE, TypeName.Visibility.PUBLIC));
        }
        for (CharSequence charSequence : loader.getAllNamespaces()) {
            String namespace = charSequence.toString();
            String containingPackageName = GosuClassUtil.getPackage(namespace);
            if (!containingPackageName.equals(parentNamespace)) continue;
            typeNames.add(new TypeName(GosuClassUtil.getNameNoPackage(namespace), loader, TypeName.Kind.NAMESPACE, TypeName.Visibility.PUBLIC));
        }
        return typeNames;
    }

    @Override
    public boolean showTypeNamesInIDE() {
        return true;
    }

    @Override
    public void shutdown() {
        if (this.shouldCacheTypeNames()) {
            this.saveTypeNames();
        }
    }

    private String getId() {
        return this._module.getName() + "$" + this.getClass().getSimpleName();
    }

    protected void deleteIndexFile() {
        File indexFile = CommonServices.getPlatformHelper().getIndexFile(this.getId());
        try {
            indexFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveTypeNames() {
        File ideaCorruptionMarkerFile = CommonServices.getPlatformHelper().getIDEACorruptionMarkerFile();
        if (ideaCorruptionMarkerFile.exists()) {
            this.deleteIndexFile();
            return;
        }
        File indexFile = CommonServices.getPlatformHelper().getIndexFile(this.getId());
        PrintWriter writer = null;
        try {
            Set<String> allTypeNames = this.getAllTypeNames();
            writer = new PrintWriter(new FileWriter(indexFile));
            for (CharSequence charSequence : allTypeNames) {
                writer.println(charSequence);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while saving Gosu Type Index for " + this);
        }
        finally {
            try {
                writer.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> loadTypeNames() {
        File indexFile = CommonServices.getPlatformHelper().getIndexFile(this.getId());
        if (indexFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new LineNumberReader(new FileReader(indexFile));
                HashSet<String> names = new HashSet<String>();
                String typeName = ((LineNumberReader)reader).readLine();
                while (typeName != null) {
                    names.add(typeName);
                    typeName = ((LineNumberReader)reader).readLine();
                }
                HashSet<String> hashSet = names;
                return hashSet;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    public final Set<String> getAllTypeNames() {
        if (this._typeNames == null) {
            Set<String> names = this.shouldCacheTypeNames() ? this.loadTypeNames() : null;
            this._typeNames = names != null ? names : new HashSet<String>(this.computeTypeNames());
        }
        return this._typeNames;
    }

    protected boolean shouldCacheTypeNames() {
        return CommonServices.getPlatformHelper().shouldCacheTypeNames();
    }
}

