/*
 * Decompiled with CFR 0.152.
 */
package gw.util.cache;

import gw.util.Predicate;
import gw.util.cache.FqnCache;
import gw.util.cache.FqnCacheNode;
import gw.util.cache.IFqnCache;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Set;

public class WeakFqnCache<T>
implements IFqnCache<T> {
    private FqnCache<Reference<T>> _cache = new FqnCache();

    @Override
    public void add(String fqn) {
        this.add(fqn, null);
    }

    @Override
    public void add(String fqn, T userData) {
        SoftReference<T> ref = new SoftReference<T>(userData);
        this._cache.add(fqn, ref);
    }

    @Override
    public boolean remove(String fqn) {
        return this._remove(fqn);
    }

    private boolean _remove(String fqn) {
        return this._cache.remove(fqn);
    }

    @Override
    public T get(String fqn) {
        Reference<T> ref = this._cache.get(fqn);
        return ref == null ? null : (T)ref.get();
    }

    @Override
    public FqnCacheNode<Reference<T>> getNode(String fqn) {
        return this._cache.getNode(fqn);
    }

    @Override
    public boolean contains(String fqn) {
        return this._cache.contains(fqn);
    }

    @Override
    public void remove(String[] fqns) {
        this._cache.remove(fqns);
    }

    @Override
    public void clear() {
        this._cache.clear();
    }

    @Override
    public Set<String> getFqns() {
        return this._cache.getFqns();
    }

    @Override
    public void visitDepthFirst(Predicate<T> visitor) {
        Predicate<Reference> delegate = node -> {
            Object userData = node == null ? null : (Object)node.get();
            return visitor.evaluate(userData);
        };
        ArrayList<FqnCacheNode<Reference<T>>> copy = new ArrayList<FqnCacheNode<Reference<T>>>(this._cache.getRoot().getChildren());
        for (FqnCacheNode fqnCacheNode : copy) {
            if (fqnCacheNode.visitDepthFirst(delegate)) continue;
            return;
        }
    }

    @Override
    public void visitNodeDepthFirst(Predicate<FqnCacheNode> visitor) {
        ArrayList<FqnCacheNode<Reference<T>>> copy = new ArrayList<FqnCacheNode<Reference<T>>>(this._cache.getRoot().getChildren());
        for (FqnCacheNode fqnCacheNode : copy) {
            if (fqnCacheNode.visitNodeDepthFirst(visitor)) continue;
            return;
        }
    }

    @Override
    public void visitBreadthFirst(Predicate<T> visitor) {
        Predicate<Reference> delegate = node -> {
            Object userData = node == null ? null : (Object)node.get();
            return visitor.evaluate(userData);
        };
        ArrayList<FqnCacheNode<Reference<T>>> copy = new ArrayList<FqnCacheNode<Reference<T>>>(this._cache.getRoot().getChildren());
        for (FqnCacheNode fqnCacheNode : copy) {
            fqnCacheNode.visitBreadthFirst(delegate);
        }
    }
}

