/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParsedElement;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableType;
import gw.util.Pair;
import gw.util.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeVarToTypeMap {
    public static final TypeVarToTypeMap EMPTY_MAP = new TypeVarToTypeMap(Collections.emptyMap());
    private Map<ITypeVariableType, Pair<IType, Boolean>> _map;
    private Set<ITypeVariableType> _typesInferredFromCovariance;
    private boolean _bStructural;
    private boolean _bReparsing;
    private IParsedElement _reparseElem;
    private Stack<List<IParseIssue>> _reparseErrorStack;

    public TypeVarToTypeMap() {
        this._map = new LinkedHashMap<ITypeVariableType, Pair<IType, Boolean>>(2);
        this._typesInferredFromCovariance = new HashSet<ITypeVariableType>(2);
    }

    private TypeVarToTypeMap(Map<ITypeVariableType, Pair<IType, Boolean>> emptyMap) {
        this._map = emptyMap;
        this._typesInferredFromCovariance = new HashSet<ITypeVariableType>(2);
    }

    public TypeVarToTypeMap(TypeVarToTypeMap from) {
        this();
        this._map.putAll(from._map);
        this._typesInferredFromCovariance.addAll(from._typesInferredFromCovariance);
        this._bStructural = from._bStructural;
    }

    public IType get(ITypeVariableType tvType) {
        Pair<IType, Boolean> pair = this._map.get(tvType);
        return pair != null ? pair.getFirst() : null;
    }

    public Pair<IType, Boolean> getPair(ITypeVariableType tvType) {
        return this._map.get(tvType);
    }

    public <E> IType getByMatcher(E tv, ITypeVarMatcher<E> matcher) {
        for (ITypeVariableType key : this._map.keySet()) {
            if (!matcher.matches(tv, key)) continue;
            return this.get(key);
        }
        return null;
    }

    public IType getByString(String tv) {
        for (ITypeVariableType key : this._map.keySet()) {
            if (!tv.equals(key.getRelativeName()) && !tv.equals(key.getName())) continue;
            return key;
        }
        return null;
    }

    public boolean containsKey(ITypeVariableType tvType) {
        return this._map.containsKey(tvType);
    }

    public IType put(ITypeVariableType tvType, IType type) {
        return this.put(tvType, type, false);
    }

    public IType put(ITypeVariableType tvType, IType type, boolean bReverse) {
        IType existing = this.remove(tvType);
        this._map.put(tvType, type == null ? null : new Pair<IType, Boolean>(type, bReverse));
        return existing;
    }

    public void putAll(TypeVarToTypeMap from) {
        for (ITypeVariableType x : from._map.keySet()) {
            this.put(x, from.get(x));
        }
    }

    public void putAllAndInferred(TypeVarToTypeMap from) {
        for (ITypeVariableType x : from._map.keySet()) {
            this.put(x, from.get(x));
        }
        this._typesInferredFromCovariance.addAll(from._typesInferredFromCovariance);
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public int size() {
        return this._map.size();
    }

    public Set<ITypeVariableType> keySet() {
        return this._map.keySet();
    }

    public Set<Map.Entry<ITypeVariableType, Pair<IType, Boolean>>> entrySet() {
        return this._map.entrySet();
    }

    public IType remove(ITypeVariableType tvType) {
        Pair<IType, Boolean> pair = this._map.remove(tvType);
        return pair != null ? pair.getFirst() : null;
    }

    public Collection<Pair<IType, Boolean>> values() {
        return this._map.values();
    }

    public boolean isStructural() {
        return this._bStructural;
    }

    public void setStructural(boolean bStructural) {
        this._bStructural = bStructural;
    }

    public boolean isInferredForCovariance(ITypeVariableType tv) {
        return !this.isStructural() || this._typesInferredFromCovariance.contains(tv);
    }

    public void setInferredForCovariance(ITypeVariableType tv) {
        this._typesInferredFromCovariance.add(tv);
    }

    public boolean isReparsing() {
        return this._bReparsing;
    }

    public void setReparsing(boolean bReparsing) {
        this._bReparsing = bReparsing;
    }

    public IParsedElement getReparseElement() {
        return this._reparseElem;
    }

    public void setReparseElement(IParsedElement reparseElem) {
        this._reparseElem = reparseElem;
    }

    public Stack<List<IParseIssue>> getReparseErrorStack() {
        return this._reparseErrorStack;
    }

    public void pushReparseErrors(List<IParseIssue> reparseErrors) {
        if (this._reparseErrorStack == null) {
            this._reparseErrorStack = new Stack();
        }
        this._reparseErrorStack.push(reparseErrors);
    }

    public void popReparseErrors() {
        this._reparseErrorStack.pop();
    }

    public static interface ITypeVarMatcher<E> {
        public boolean matches(E var1, ITypeVariableType var2);
    }
}

